#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 132 "data_structures/sequences.nw"
#ifndef ALIBIO_SYMBOL_INCLUDED
#define ALIBIO_SYMBOL_INCLUDED

#include <iostream>
#include <stdlib.h>
#include <string>
#include <assert.h>
#include <ctype.h>

namespace alibio {

#line 152 "data_structures/sequences.nw"
class symbol
{
public:
    
#line 177 "data_structures/sequences.nw"
    //Constructor prototypes
symbol();
symbol(char c);
symbol(char c,std::string s);
    //Function prototypes
void print();
void set_id(char c);
void set_name(std::string s);
char get_id() const;
std::string get_name() const;

#line 157 "data_structures/sequences.nw"
private:
    
#line 169 "data_structures/sequences.nw"
char id;
std::string name;
#line 159 "data_structures/sequences.nw"
};

#line 193 "data_structures/sequences.nw"
symbol::symbol()
{
    id=' ';
    name="unknown";
}

#line 204 "data_structures/sequences.nw"
symbol::symbol(char c)
{
    id=toupper(c);
    name="unknown";
}

#line 216 "data_structures/sequences.nw"
symbol::symbol(char c,std::string s)
{
    assert(s.length()>=0);
 
    id=toupper(c);
    name=s;
}

#line 230 "data_structures/sequences.nw"
void symbol::print()
{
    assert(name.length()>=0);
    
    std::cout << "Name:" << name << "\nSymbol:" << id << "\n";
}

#line 241 "data_structures/sequences.nw"
void symbol::set_id(char c)
{
    id=toupper(c);
}

#line 251 "data_structures/sequences.nw"
void symbol::set_name(std::string s)
{
    assert(s.length()>=0);
 
    name=s;
}

#line 263 "data_structures/sequences.nw"
char symbol::get_id() const
{
    return id;
}

#line 275 "data_structures/sequences.nw"
std::string symbol::get_name() const
{
    assert(name.length()>=0);

    return name;
}


#line 146 "data_structures/sequences.nw"
}

#endif //ALIBIO_SYMBOL_INCLUDED
