#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 1265 "data_structures/sequences.nw"
#ifndef ALIBIO_TERTIARY_STRUCTURE_INCLUDED
#define ALIBIO_TERTIARY_STRUCTURE_INCLUDED

#include <iostream>
#include <stdlib.h>
#include <string>
#include <vector>
#include <alibio/three_d_coordinates.hpp>

namespace alibio {

#line 1285 "data_structures/sequences.nw"
class tertiary_structure
{
public:
    
#line 1302 "data_structures/sequences.nw"
typedef std::vector<three_d_coordinates> points_vector;

#line 1289 "data_structures/sequences.nw"
    
#line 1321 "data_structures/sequences.nw"
    //Functions prototypes
void print(std::string s);
bool add_point(int p,float x,float y,float z,std::string s);
bool remove_point(int p);
bool change_point(int p,float x,float y,float z);
bool find_point(int p);
three_d_coordinates get_point(int p);
points_vector &get_all_points();
bool resize (int l);


#line 1291 "data_structures/sequences.nw"
private:
    
#line 1312 "data_structures/sequences.nw"
points_vector points;
#line 1293 "data_structures/sequences.nw"
};

#line 1344 "data_structures/sequences.nw"
void tertiary_structure::print(std::string s)
{
    three_d_coordinates aux;
    int n=points.size();

    if (n==0) {
        std::cout << "\nNo known points specified.\n";
        return;
    }

    if (s.length()<=(points.back()).get_position()) {
        std::cout << "\nSequence and coordinates are not consistent.\n";
        return;
    } 
        
    std::cout << "\n---Known points coordinates---\n";
    for (int i=0;i<n;i++) {
        std::cout << s[points[i].get_position()]
        << " in position " << points[i].get_position() << ": ";
        points[i].print();
        std::cout << "\n";           
    }
}

#line 1392 "data_structures/sequences.nw"
bool tertiary_structure::add_point(int p,float x,float y,float z,std::string s)
{
    points_vector::iterator i;
    three_d_coordinates c(p,x,y,z);

    if ((p<0)||(p>=s.length())) {
        #ifdef DEBUG   
            std::cout << "\nError: position out of bounds.\n"
        #endif
        return false;
    }

    if (points.empty())
        points.push_back(c);
    else {
        
        for (i=points.begin();
        (i!=points.end())&&(i->get_position()<p);i++);
    
        if ((i!=points.end())&&(i->get_position()==p)) {
            #ifdef DEBUG
                std::cout << "\nError: known point already present.\n";
            #endif
            return false;
        }
    
        points.insert(i,c);
    }
    return true;
}

#line 1440 "data_structures/sequences.nw"
bool tertiary_structure::remove_point(int p)
{
    points_vector::iterator i;
        
    for (i=points.begin();
    (i!=points.end())&&(i->get_position()<p);i++);
    
    if (i==points.end()) {
        #ifdef DEBUG
            std::cout << "\nError: known point not present.\n";
        #endif
        return false;    
    }
     
    if (i!=points.end())
        if (i->get_position()>p) {
            #ifdef DEBUG
                std::cout << "\nError: known point not present.\n";
            #endif
            return false;    
        }

    points.erase(i);
    return true;
}

#line 1486 "data_structures/sequences.nw"
bool tertiary_structure::change_point(int p,float x,float y,float z)
{
    int i;    
    three_d_coordinates c(p,x,y,z);
 
    for (i=0;(i<points.size())&&(points[i].get_position())<p;i++);
    
    if (i==points.size()) {
        #ifdef DEBUG
            std::cout << "\nError: known point not present.\n"
        #endif
        return false;
    }
    
    if (i!=points.size())
        if (points[i].get_position()>p) {
        #ifdef DEBUG
            std::cout << "\nError: known point not present.\n"
        #endif
        return false;
    }

    points[i].set_xyz(x,y,z);
}

#line 1525 "data_structures/sequences.nw"
bool tertiary_structure::find_point(int p)
{
    int i;
  
    for (i=0;(i<points.size())&&(points[i].get_position())<p;i++);
    
    if (i==points.size())
        return false;
    
    if (i!=points.size())
        if (points[i].get_position()>p)
            return false;

    return true;
}

#line 1554 "data_structures/sequences.nw"
three_d_coordinates tertiary_structure::get_point(int p)
{
    int i;
    three_d_coordinates tdc;
  
    for (i=0;(i<points.size())&&(points[i].get_position())<p;i++);
    
    if (i==points.size())
        return tdc;
    
    if (i!=points.size())
        if (points[i].get_position()>p)
            return tdc;

    return points[i];
}

#line 1576 "data_structures/sequences.nw"
tertiary_structure::points_vector &tertiary_structure::get_all_points()
{
    return points;
}


#line 1598 "data_structures/sequences.nw"
bool tertiary_structure::resize(int l)
{
    points_vector::iterator i;
        
    if (l<0) {
        #ifdef DEBUG
            std::cout << "\nError: graph size must be greater than zero.\n";
        #endif 
        return false;
    }

    if (points.empty())
        return true;

    if (l<(points.back()).get_position()) {
        for (i=points.begin();
            (i!=points.end())&&(i->get_position()<l);i++);
        points.erase(i,points.end());
    }
  
    return true;
}


#line 1279 "data_structures/sequences.nw"
}

#endif //ALIBIO_TERTIARY_STRUCTURE_INCLUDED
