#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 558 "data_structures/sequences.nw"
#ifndef ALIBIO_THREE_D_COORDINATES_INCLUDED
#define ALIBIO_THREE_D_COORDINATES_INCLUDED

#include <iostream>
#include <stdlib.h>

namespace alibio {

#line 575 "data_structures/sequences.nw"
class three_d_coordinates
{
public:
    
#line 604 "data_structures/sequences.nw"
    //Constructor prototypes
three_d_coordinates();
three_d_coordinates(int p);
three_d_coordinates(float x,float y,float z);
three_d_coordinates(int p,float x,float y,float z);
    //Function prototypes
void print();
bool set_position(int p);
void set_xyz(float x,float y,float z);
void set_x(float x);
void set_y(float y);
void set_z(float z);
int get_position();
float get_x();
float get_y();
float get_z();

#line 580 "data_structures/sequences.nw"
private:
    
#line 594 "data_structures/sequences.nw"
int position;
float x_coord;
float y_coord;
float z_coord;
#line 582 "data_structures/sequences.nw"
};

#line 626 "data_structures/sequences.nw"
three_d_coordinates::three_d_coordinates()
{
    position=-1;
    x_coord=0;
    y_coord=0;
    z_coord=0;
}    

#line 639 "data_structures/sequences.nw"
three_d_coordinates::three_d_coordinates(int p)
{
    position=(p>=0)?p:-1;
    x_coord=0;
    y_coord=0;
    z_coord=0;   
}

#line 652 "data_structures/sequences.nw"
three_d_coordinates::three_d_coordinates(float x,float y,float z)
{
    position=-1;

    x_coord=x;
    y_coord=y;
    z_coord=z;
}
        
#line 667 "data_structures/sequences.nw"
three_d_coordinates::three_d_coordinates(int p,float x,float y,float z)
{
    position=(p>=0)?p:-1;

    x_coord=x;
    y_coord=y;
    z_coord=z;
}  

#line 681 "data_structures/sequences.nw"
void three_d_coordinates::print()
{
    std::cout << "(" << x_coord << ", " << y_coord << ", " << z_coord << ")";
}

#line 693 "data_structures/sequences.nw"
bool three_d_coordinates::set_position(int p)
{
    if (p>=0) {
        position=p;
        return true;
    }

    #ifdef DEBUG
        std::cout << "\nError: position must be greater or equal than zero.\n";
    #endif
    return false;
}

#line 711 "data_structures/sequences.nw"
void three_d_coordinates::set_xyz(float x,float y,float z)
{
    x_coord=x;
    y_coord=y;
    z_coord=z;
}    

#line 722 "data_structures/sequences.nw"
void three_d_coordinates::set_x(float x)
{
    x_coord=x;
}

#line 731 "data_structures/sequences.nw"
void three_d_coordinates::set_y(float y)
{
    y_coord=y;
}

#line 740 "data_structures/sequences.nw"
void three_d_coordinates::set_z(float z)
{
    z_coord=z;
}

#line 749 "data_structures/sequences.nw"
int three_d_coordinates::get_position()
{
    return position;
}    

#line 758 "data_structures/sequences.nw"
float three_d_coordinates::get_x()
{
    return x_coord;
}    

#line 767 "data_structures/sequences.nw"
float three_d_coordinates::get_y()
{
    return y_coord;
}    

#line 776 "data_structures/sequences.nw"
float three_d_coordinates::get_z()
{
    return z_coord;
}


#line 569 "data_structures/sequences.nw"
}

#endif //ALIBIO_THREE_D_COORDINATES_INCLUDED
