/*
 * Decompiled with CFR 0.152.
 */
package tabpane;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import tabpane.MyAnnotationFrame;

public class AminoNet
extends JApplet
implements ItemListener,
ActionListener {
    public static final long serialVersionUID = 0L;
    public volatile Vector<Vector> rowDataA;
    public Vector<Vector> rowDataB;
    public Vector<Vector> rowDataI;
    public Vector<Vector> rowDataC;
    public int[] N = new int[4];
    public int[][] K = new int[4][];
    public int[][] S = new int[4][];
    public double[][] C = new double[4][];
    public double[][] Cw = new double[4][];
    public int[][] D = new int[4][];
    public int[] Ksum;
    public int[] Ssum;
    public double[] Csum;
    public double[] Cwsum;
    public int[] ccount;
    public int[] Lsum;
    double[] r = new double[4];
    double LVCD = 5.0;
    int maxZSize = 100;
    JTextField jFileN = new JTextField("", 7);
    JTextField jtdist = new JTextField("", 4);
    JCheckBox cb0 = new JCheckBox("All");
    JCheckBox cb1 = new JCheckBox("Phobic");
    JCheckBox cb2 = new JCheckBox("Philic");
    JCheckBox cb3 = new JCheckBox("Charged");
    JFileChooser fileChooser = new JFileChooser();
    JPanel selPanel = new SelectionPanel();
    Vector<String> column_names = new Vector(1, 1);
    MyAnnotationFrame aFrame;
    JMenuItem show;
    JMenuItem hide;
    Vector<Vector<Vector<String>>> dataA;
    Vector<Vector<Vector<String>>> dataB;
    Vector<Vector<Vector<String>>> dataI;
    Vector<Vector<Vector<String>>> dataC;
    Vector<String> chain;
    JTextField tfr;
    JButton uvb = new JButton("Show");
    JComboBox tfc;
    JComboBox lsr;
    JCheckBox cAlpha;
    JComboBox jgp;
    JComboBox jnp;
    JComboBox jrp;
    Boolean[] found = new Boolean[4];
    JTabbedPane jtp = new JTabbedPane();
    ResiduesPanel rp = new ResiduesPanel();
    ValuesPanel vp;
    GraphsPanel gp;
    NetworksPanel np;
    UValuesPanel uv;
    TwoDViewsPanel tp;
    RanksPanel zp;
    File fileN;
    BufferedReader br = null;
    JCheckBox[] vhcb = new JCheckBox[4];
    int[][] grABIC = new int[4][];
    int[] M = new int[4];
    int[][] Clu = new int[4][];
    JComboBox[] clus = new JComboBox[4];
    int[][] clNo = new int[4][];
    int[][][] wAdj = new int[4][][];
    JCheckBox jclb = new JCheckBox("Show Label");
    JButton jrb = new JButton("Reset");
    JCheckBox jrclb = new JCheckBox("Show Label");
    JButton jrrb = new JButton("Reset");

    @Override
    public void init() {
        String string = this.getParameter("maxZSize");
        if (string == null) {
            this.maxZSize = 100;
        } else {
            try {
                this.maxZSize = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.maxZSize = 100;
            }
        }
        this.LVCD = 5.0;
        this.aFrame = new MyAnnotationFrame();
        this.setLayout(new BorderLayout());
        this.add((Component)this.selPanel, "First");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        this.add(this.jtp);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Annotations");
        jMenu2.setMnemonic('A');
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem("Open...");
        jMenu.add(jMenuItem);
        jMenuItem.setMnemonic('O');
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Quit");
        jMenu.add(jMenuItem2);
        jMenuItem2.setMnemonic('Q');
        this.show = new JMenuItem("Show");
        this.show.setMnemonic('S');
        jMenu2.add(this.show);
        this.show.addActionListener(this);
        this.hide = new JMenuItem("Hide");
        this.hide.setMnemonic('i');
        jMenu2.add(this.hide);
        this.hide.addActionListener(this);
        this.hide.setEnabled(false);
        this.cAlpha.addActionListener(this);
        this.cAlpha.setActionCommand("cAlpha");
        this.lsr.addActionListener(this);
        this.lsr.setActionCommand("lsr");
        this.lsr.addItem("any");
        this.lsr.addItem("long");
        this.lsr.addItem("short");
        this.jFileN.addActionListener(this);
        this.jFileN.setActionCommand("jFileN");
        this.jtdist.addActionListener(this);
        this.jtdist.setActionCommand("jtdist");
        this.column_names.addElement("No.");
        this.column_names.addElement("Name");
        this.column_names.addElement("Chain");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Show")) {
            this.aFrame.setVisible(true);
            this.hide.setEnabled(true);
            this.show.setEnabled(false);
        }
        if (string.equals("Hide")) {
            this.aFrame.setVisible(false);
            this.hide.setEnabled(false);
            this.show.setEnabled(true);
        }
        if (string.equals("cAlpha")) {
            this.showStatus("Please wait recalculating...........");
            try {
                if (!this.jFileN.getText().equals("")) {
                    this.calculate(this.lsr.getSelectedIndex());
                    this.jtp.removeAll();
                    this.vp = new ValuesPanel();
                    this.gp = new GraphsPanel();
                    this.np = new NetworksPanel();
                    this.uv = new UValuesPanel();
                    this.tp = new TwoDViewsPanel();
                    this.zp = new RanksPanel();
                    this.jtp.addTab("Residues", this.rp);
                    this.jtp.addTab("Values", this.vp);
                    this.jtp.addTab("Graphs", this.gp);
                    this.jtp.addTab("Networks", this.np);
                    this.jtp.addTab("User Values", this.uv);
                    this.jtp.addTab("2D Views", this.tp);
                    this.jtp.addTab("Ranks", this.zp);
                }
                super.repaint();
                this.showStatus("Recalculation done.");
            }
            catch (Exception exception) {
                super.repaint();
                System.out.println("Parlam na " + exception);
                this.showStatus("File Exception." + exception);
            }
            this.cb0.setSelected(false);
            this.cb0.setSelected(true);
            this.cb1.setSelected(false);
            this.cb2.setSelected(false);
            this.cb3.setSelected(false);
        }
        if (string.equals("lsr")) {
            this.showStatus("Please wait recalculating...........");
            try {
                System.out.println("any long short " + this.lsr.getSelectedIndex());
                if (!this.jFileN.getText().equals("")) {
                    this.calculate(this.lsr.getSelectedIndex());
                    this.jtp.removeAll();
                    this.vp = new ValuesPanel();
                    this.gp = new GraphsPanel();
                    this.np = new NetworksPanel();
                    this.uv = new UValuesPanel();
                    this.tp = new TwoDViewsPanel();
                    this.zp = new RanksPanel();
                    this.jtp.addTab("Residues", this.rp);
                    this.jtp.addTab("Values", this.vp);
                    this.jtp.addTab("Graphs", this.gp);
                    this.jtp.addTab("Networks", this.np);
                    this.jtp.addTab("User Values", this.uv);
                    this.jtp.addTab("2D Views", this.tp);
                    this.jtp.addTab("Ranks", this.zp);
                }
                super.repaint();
                this.showStatus("Recalculation done.");
            }
            catch (Exception exception) {
                super.repaint();
                System.out.println("Parlam na " + exception);
                this.showStatus("File Exception." + exception);
            }
            this.cb0.setSelected(false);
            this.cb0.setSelected(true);
            this.cb1.setSelected(false);
            this.cb2.setSelected(false);
            this.cb3.setSelected(false);
        }
        if (string.equals("jtdist")) {
            this.showStatus("Please wait recalculating...........");
            try {
                this.LVCD = Double.parseDouble(this.jtdist.getText());
                System.out.println("dist " + this.jtdist.getText() + "  " + this.LVCD);
                this.calculate(this.lsr.getSelectedIndex());
                this.jtp.removeAll();
                this.vp = new ValuesPanel();
                this.gp = new GraphsPanel();
                this.np = new NetworksPanel();
                this.uv = new UValuesPanel();
                this.tp = new TwoDViewsPanel();
                this.zp = new RanksPanel();
                this.jtp.addTab("Residues", this.rp);
                this.jtp.addTab("Values", this.vp);
                this.jtp.addTab("Graphs", this.gp);
                this.jtp.addTab("Networks", this.np);
                this.jtp.addTab("User Values", this.uv);
                this.jtp.addTab("2D Views", this.tp);
                this.jtp.addTab("Ranks", this.zp);
                super.repaint();
                this.showStatus("Recalculation done.");
            }
            catch (Exception exception) {
                this.jtdist.setText("" + this.LVCD);
                super.repaint();
                System.out.println("faltu sonkha");
                this.showStatus("File Exception." + exception);
            }
            this.cb0.setSelected(false);
            this.cb0.setSelected(true);
            this.cb1.setSelected(false);
            this.cb2.setSelected(false);
            this.cb3.setSelected(false);
        }
        try {
            if (string.equals("Open...") || string.equals("jFileN")) {
                Object object;
                String string2;
                int n;
                if (string.equals("Open...") && (n = this.fileChooser.showOpenDialog(this)) == 0) {
                    this.fileN = this.fileChooser.getSelectedFile();
                    string2 = this.fileN.getName();
                    string2 = this.fileChooser.getCurrentDirectory() + "/" + string2;
                    object = this.fileN.getName().substring(0, this.fileN.getName().lastIndexOf(46));
                    this.jFileN.setText((String)object);
                    this.LVCD = 5.0;
                    this.jtdist.setText("5.0");
                    this.showStatus("Please wait loading file...........");
                    InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string2));
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    this.tryread(bufferedReader);
                    this.showStatus("File opened. Please wait calculating...........");
                    this.calculate(this.lsr.getSelectedIndex());
                    this.showStatus("File Loaded.");
                }
                if ("jFileN".equals(actionEvent.getActionCommand())) {
                    String string3 = new String("http://www.pdb.org/pdb/files/");
                    string2 = this.jFileN.getText();
                    string3 = string2.endsWith(".pdb") ? string3 + string2 : string3 + string2 + ".pdb";
                    this.showStatus("Please wait fetching file...........");
                    object = null;
                    object = new URL(string3).openConnection().getInputStream();
                    this.br = new BufferedReader(new InputStreamReader((InputStream)object));
                    this.tryread(this.br);
                    this.showStatus("File fetched. Please wait calculating...........");
                    this.calculate(this.lsr.getSelectedIndex());
                    this.showStatus("File Loaded.");
                }
                this.rp = new ResiduesPanel();
                this.vp = new ValuesPanel();
                this.gp = new GraphsPanel();
                this.np = new NetworksPanel();
                this.uv = new UValuesPanel();
                this.tp = new TwoDViewsPanel();
                this.zp = new RanksPanel();
                this.jtp.removeAll();
                this.jtp.addTab("Residues", this.rp);
                this.jtp.addTab("Values", this.vp);
                this.jtp.addTab("Graphs", this.gp);
                this.jtp.addTab("Networks", this.np);
                this.jtp.addTab("User Values", this.uv);
                this.jtp.addTab("2D Views", this.tp);
                this.jtp.addTab("Ranks", this.zp);
                this.cb0.setSelected(false);
                this.cb0.setSelected(true);
                this.cb1.setSelected(false);
                this.cb2.setSelected(false);
                this.cb3.setSelected(false);
                super.repaint();
            }
        }
        catch (Exception exception) {
            this.jtdist.setText("" + this.LVCD);
            this.jtp.removeAll();
            System.out.println(exception + "faltu ");
            this.showStatus("File Exception." + exception);
        }
    }

    public void tryread(BufferedReader bufferedReader) throws Exception {
        this.rowDataA = new Vector(1, 1);
        this.rowDataB = new Vector(1, 1);
        this.rowDataI = new Vector(1, 1);
        this.rowDataC = new Vector(1, 1);
        this.dataA = new Vector(1, 1);
        this.dataB = new Vector(1, 1);
        this.dataI = new Vector(1, 1);
        this.dataC = new Vector(1, 1);
        this.chain = new Vector(1, 1);
        String[] stringArray = new String[]{"PHE", "MET", "TRP", "ILE", "VAL", "LEU", "PRO", "ALA", "ASN", "CYS", "GLN", "GLY", "SER", "THR", "TYR", "ARG", "ASP", "GLU", "HIS", "LYS"};
        int n = -999;
        char c = '*';
        Vector vector = new Vector(1, 1);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() < 4 || !string.substring(0, 4).equals("ATOM") || string.substring(13, 16).equals("N  ") || string.substring(13, 16).equals("C  ") || string.substring(13, 16).equals("O  ") || string.substring(17, 18).equals(" ")) continue;
                Vector<String> vector2 = new Vector<String>(1, 1);
                vector2.addElement(string.substring(22, 26));
                vector2.addElement(string.substring(30, 38));
                vector2.addElement(string.substring(38, 46));
                vector2.addElement(string.substring(46, 54));
                vector2.addElement(string.substring(21, 22));
                vector2.addElement(string.substring(13, 16));
                if (string.charAt(21) != c) {
                    this.chain.add(string.substring(21, 22));
                }
                if (Integer.valueOf(string.substring(22, 26).trim()) != n) {
                    int n2;
                    vector = new Vector(1, 1);
                    this.dataA.addElement(vector);
                    Vector<String> vector3 = new Vector<String>(1, 1);
                    vector3.addElement(string.substring(22, 26));
                    vector3.addElement(string.substring(17, 20));
                    vector3.addElement(string.substring(21, 22));
                    this.rowDataA.add(vector3);
                    for (n2 = 0; n2 < 8; ++n2) {
                        if (!string.substring(17, 20).equals(stringArray[n2])) continue;
                        this.dataB.addElement(vector);
                        this.rowDataB.add(vector3);
                        break;
                    }
                    for (n2 = 8; n2 < 15; ++n2) {
                        if (!string.substring(17, 20).equals(stringArray[n2])) continue;
                        this.dataI.addElement(vector);
                        this.rowDataI.add(vector3);
                        break;
                    }
                    for (n2 = 15; n2 < 20; ++n2) {
                        if (!string.substring(17, 20).equals(stringArray[n2])) continue;
                        this.dataC.addElement(vector);
                        this.rowDataC.add(vector3);
                        break;
                    }
                }
                vector.addElement(vector2);
                n = Integer.valueOf(string.substring(22, 26).trim());
                c = string.charAt(21);
            }
        }
        catch (Exception exception) {
            System.out.println(exception + "dubiechhe");
            throw new Exception();
        }
    }

    public void calculate(int n) {
        this.N[0] = this.rowDataA.size();
        this.N[1] = this.rowDataB.size();
        this.N[2] = this.rowDataI.size();
        this.N[3] = this.rowDataC.size();
        this.Ksum = new int[4];
        this.Ssum = new int[4];
        this.Csum = new double[4];
        this.Cwsum = new double[4];
        this.Lsum = new int[4];
        this.ccount = new int[4];
        this.make(0, n);
        this.make(1, n);
        this.make(2, n);
        this.make(3, n);
        Runtime runtime = Runtime.getRuntime();
        System.out.println(runtime.freeMemory());
        runtime.gc();
        System.out.println(runtime.freeMemory());
        System.out.println(runtime.totalMemory());
    }

    void make(int n, int n2) {
        this.wAdj[n] = new int[this.N[n]][this.N[n]];
        switch (n) {
            case 0: {
                this.showStatus("Please wait calculating for all residues network..........");
                this.wAdj[0] = this.calcAdj(0, this.dataA, n2);
                break;
            }
            case 1: {
                this.showStatus("Please wait calculating for hydrophobic residues network..........");
                this.wAdj[1] = this.calcAdj(1, this.dataB, n2);
                break;
            }
            case 2: {
                this.showStatus("Please wait calculating for hydrophilic residues network..........");
                this.wAdj[2] = this.calcAdj(2, this.dataI, n2);
                break;
            }
            case 3: {
                this.showStatus("Please wait calculating for charged residues network..........");
                this.wAdj[3] = this.calcAdj(3, this.dataC, n2);
            }
        }
        this.calcGr(this.wAdj[n], n);
        System.out.println("calcGr done " + n);
        this.clNo[n] = new int[this.M[n]];
        this.createCluster(n);
        System.out.println("createCluster done " + n);
        this.calcValues(this.wAdj[n], n, this.clNo[n][0]);
    }

    public int[][] calcAdj(int n, Vector<Vector<Vector<String>>> vector, int n2) {
        int[][] nArray = new int[this.N[n]][this.N[n]];
        for (int i = 0; i < this.N[n]; ++i) {
            block14: for (int j = i + 1; j < this.N[n]; ++j) {
                int n3;
                try {
                    n3 = 1;
                    switch (n) {
                        case 0: {
                            n3 = Integer.valueOf(this.rowDataA.elementAt(j).elementAt(0).toString().trim()) - Integer.valueOf(this.rowDataA.elementAt(i).elementAt(0).toString().trim());
                            break;
                        }
                        case 1: {
                            n3 = Integer.valueOf(this.rowDataB.elementAt(j).elementAt(0).toString().trim()) - Integer.valueOf(this.rowDataB.elementAt(i).elementAt(0).toString().trim());
                            break;
                        }
                        case 2: {
                            n3 = Integer.valueOf(this.rowDataI.elementAt(j).elementAt(0).toString().trim()) - Integer.valueOf(this.rowDataI.elementAt(i).elementAt(0).toString().trim());
                            break;
                        }
                        case 3: {
                            n3 = Integer.valueOf(this.rowDataC.elementAt(j).elementAt(0).toString().trim()) - Integer.valueOf(this.rowDataC.elementAt(i).elementAt(0).toString().trim());
                        }
                    }
                    switch (n2) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (n3 < 10) {
                                nArray[i][j] = 0;
                                nArray[j][i] = 0;
                                continue block14;
                            }
                            break;
                        }
                        case 2: {
                            if (n3 >= 10) {
                                nArray[i][j] = 0;
                                nArray[j][i] = 0;
                                continue block14;
                            } else {
                                break;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("pakar liya " + exception);
                }
                for (n3 = 0; n3 < vector.elementAt(i).size(); ++n3) {
                    if (this.cAlpha.isSelected() && !vector.elementAt(i).elementAt(n3).elementAt(5).equals("CA ")) continue;
                    for (int k = 0; k < vector.elementAt(j).size(); ++k) {
                        if (this.cAlpha.isSelected() && !vector.elementAt(j).elementAt(k).elementAt(5).equals("CA ")) continue;
                        Double d = new Double(0.0);
                        for (int i2 = 1; i2 < 4; ++i2) {
                            float f = Float.parseFloat(vector.elementAt(i).elementAt(n3).elementAt(i2));
                            float f2 = Float.parseFloat(vector.elementAt(j).elementAt(k).elementAt(i2));
                            d = d + (double)((f2 - f) * (f2 - f));
                        }
                        if (!((d = Double.valueOf(Math.sqrt(d))) <= this.LVCD)) continue;
                        int[] nArray2 = nArray[i];
                        int n4 = j;
                        nArray2[n4] = nArray2[n4] + 1;
                        int[] nArray3 = nArray[j];
                        int n5 = i;
                        nArray3[n5] = nArray3[n5] + 1;
                    }
                }
            }
        }
        return nArray;
    }

    void calcGr(int[][] nArray, int n) {
        int n2;
        this.grABIC[n] = new int[this.N[n]];
        for (n2 = 0; n2 < this.N[n]; ++n2) {
            this.grABIC[n][n2] = -1;
        }
        n2 = 0;
        for (int i = 0; i < this.N[n]; ++i) {
            if (this.grABIC[n][i] >= 0) continue;
            this.frag(i, n2, nArray, n);
            ++n2;
        }
        this.M[n] = n2;
        System.out.println("group====>  " + n);
    }

    void frag(int n, int n2, int[][] nArray, int n3) {
        this.grABIC[n3][n] = n2;
        for (int i = 0; i < this.N[n3]; ++i) {
            if (nArray[n][i] < 1 || this.grABIC[n3][i] != -1) continue;
            this.frag(i, n2, nArray, n3);
        }
    }

    void createCluster(int n) {
        int n2;
        this.Clu[n] = new int[this.M[n]];
        System.out.println("create " + this.M[n] + " " + this.Clu[n][0]);
        for (n2 = 0; n2 < this.N[n]; ++n2) {
            int[] nArray = this.Clu[n];
            int n3 = this.grABIC[n][n2];
            nArray[n3] = nArray[n3] + 1;
        }
        System.out.println("create first loop done" + this.M[n]);
        n2 = 0;
        for (int i = 0; i < this.M[n]; ++i) {
            if (this.Clu[n][i] < 30) continue;
            this.clNo[n][n2] = i;
            System.out.println("testing create >30  inner " + this.clNo[n][n2] + " " + this.Clu[n][i]);
            ++n2;
        }
        System.out.println("create second loop done" + this.M[n]);
        this.M[n] = n2;
    }

    void calcValues(int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        this.Ksum[n] = 0;
        this.Ssum[n] = 0;
        this.Csum[n] = 0.0;
        this.Cwsum[n] = 0.0;
        this.ccount[n] = 0;
        this.K[n] = new int[this.N[n]];
        this.S[n] = new int[this.N[n]];
        this.D[n] = new int[this.N[n]];
        this.C[n] = new double[this.N[n]];
        this.Cw[n] = new double[this.N[n]];
        for (int i = 0; i < this.N[n]; ++i) {
            this.C[n][i] = 0.0;
            this.Cw[n][i] = 0.0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (this.grABIC[n][i] != n2) continue;
            for (int j = 0; j < this.N[n]; ++j) {
                if (this.grABIC[n][j] != n2 || nArray[i][j] <= 0) continue;
                ++n7;
                n8 += nArray[i][j];
                for (int k = j + 1; k < this.N[n]; ++k) {
                    if (this.grABIC[n][k] != n2 || nArray[k][j] * nArray[i][k] == 0) continue;
                    ++n5;
                    n6 += nArray[i][k] + nArray[i][j];
                }
            }
            int n9 = n;
            this.Ksum[n9] = this.Ksum[n9] + n7;
            int n10 = n;
            this.Ssum[n10] = this.Ssum[n10] + n8;
            this.K[n][i] = n7;
            this.S[n][i] = n8;
            if (this.K[n][i] <= 1 || n6 <= 0) continue;
            this.C[n][i] = 2.0 * (double)n5 / (double)this.K[n][i] / (double)(this.K[n][i] - 1);
            int n11 = n;
            this.Csum[n11] = this.Csum[n11] + this.C[n][i];
            this.Cw[n][i] = (double)n6 * 1.0 / (double)this.S[n][i] / (double)(this.K[n][i] - 1);
            if (this.S[n][i] == 5 && this.K[n][i] == 2 && n == 3) {
                System.out.println("VULLLLLLLLLL = " + n6 + this.Cw[n][i]);
            }
            int n12 = n;
            this.Cwsum[n12] = this.Cwsum[n12] + this.Cw[n][i];
            int n13 = n;
            this.ccount[n13] = this.ccount[n13] + 1;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int[][] nArray2 = new int[this.N[n]][this.N[n]];
        for (n4 = 0; n4 < this.N[n]; ++n4) {
            if (this.grABIC[n][n4] != n2) continue;
            for (n3 = 0; n3 < this.N[n]; ++n3) {
                if (this.grABIC[n][n3] != n2) continue;
                nArray2[n4][n3] = nArray[n4][n3];
                if (nArray[n4][n3] > 0) {
                    d4 += 1.0;
                    d += (double)(this.K[n][n4] * this.K[n][n3]);
                    d2 += (double)(this.K[n][n4] + this.K[n][n3]);
                    d3 += (double)(this.K[n][n4] * this.K[n][n4] + this.K[n][n3] * this.K[n][n3]);
                    nArray2[n4][n3] = 1;
                    continue;
                }
                if (n4 == n3) continue;
                nArray2[n4][n3] = 9999;
            }
        }
        this.r[n] = (4.0 * d * d4 - d2 * d2) / (2.0 * d3 * d4 - d2 * d2);
        this.Lsum[n] = 0;
        for (n4 = 0; n4 < this.N[n]; ++n4) {
            this.D[n][n4] = 0;
            if (this.grABIC[n][n4] != n2) continue;
            for (n3 = 0; n3 < this.N[n]; ++n3) {
                if (this.grABIC[n][n3] != n2) continue;
                for (int i = 0; i < this.N[n]; ++i) {
                    if (this.grABIC[n][i] != n2 || nArray2[n3][i] <= nArray2[n3][n4] + nArray2[n4][i]) continue;
                    nArray2[n3][i] = nArray2[n3][n4] + nArray2[n4][i];
                }
            }
        }
        for (n4 = 0; n4 < this.N[n]; ++n4) {
            if (this.grABIC[n][n4] != n2) continue;
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.grABIC[n][n3] != n2 || nArray2[n4][n3] >= 9999) continue;
                int[] nArray3 = this.D[n];
                int n14 = n4;
                nArray3[n14] = nArray3[n14] + nArray2[n4][n3];
            }
            for (n3 = n4 + 1; n3 < this.N[n]; ++n3) {
                if (this.grABIC[n][n3] != n2 || nArray2[n4][n3] >= 9999) continue;
                int n15 = n;
                this.Lsum[n15] = this.Lsum[n15] + nArray2[n4][n3];
                int[] nArray4 = this.D[n];
                int n16 = n4;
                nArray4[n16] = nArray4[n16] + nArray2[n4][n3];
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void update(Graphics graphics) {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    public void start() {
        this.setVisible(true);
    }

    public void run() {
    }

    @Override
    public void stop() {
    }

    class RanPanel
    extends JPanel
    implements ActionListener {
        public static final long serialVersionUID = 0L;
        Object[][] zScore;
        Object[] zColNames = new Object[]{"Res", "Chain", "Z Score"};
        int num;
        String[] stitle = new String[]{"ALL", "Phobic", "Philic", "Charged"};

        public RanPanel(int n) {
            this.num = n;
            Border border = BorderFactory.createLineBorder(Color.black);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.stitle[this.num]);
            titledBorder.setTitleJustification(3);
            this.setBorder(titledBorder);
            if (AminoNet.this.M[n] < 1) {
                return;
            }
            AminoNet.this.clus[n].addActionListener(this);
            this.setLayout(new GridLayout(0, 1));
            this.zcalc(AminoNet.this.wAdj[n], this.num);
        }

        public void zcalc(int[][] nArray, int n) {
            int n2;
            int n3 = Integer.valueOf(AminoNet.this.clus[this.num].getSelectedItem().toString());
            int n4 = AminoNet.this.Clu[n][n3];
            if (n4 > AminoNet.this.maxZSize) {
                return;
            }
            this.zScore = new Object[n4][3];
            double d = 0.0;
            double[] dArray = new double[AminoNet.this.N[n]];
            int n5 = 0;
            for (int i = 0; i < AminoNet.this.N[n]; ++i) {
                int n6;
                int n7;
                if (AminoNet.this.grABIC[n][i] != n3) continue;
                int[][] nArray2 = new int[AminoNet.this.N[n]][AminoNet.this.N[n]];
                for (n7 = 0; n7 < AminoNet.this.N[n]; ++n7) {
                    if (AminoNet.this.grABIC[n][n7] != n3) continue;
                    for (n6 = 0; n6 < AminoNet.this.N[n]; ++n6) {
                        if (AminoNet.this.grABIC[n][n6] != n3) continue;
                        nArray2[n7][n6] = nArray[n7][n6];
                        if (nArray[n7][n6] > 0) {
                            nArray2[n7][n6] = 1;
                            continue;
                        }
                        if (n7 == n6) continue;
                        nArray2[n7][n6] = 9999;
                    }
                }
                for (n7 = 0; n7 < AminoNet.this.N[n]; ++n7) {
                    if (AminoNet.this.grABIC[n][n7] != n3 || i == n7) continue;
                    for (n6 = 0; n6 < AminoNet.this.N[n]; ++n6) {
                        if (AminoNet.this.grABIC[n][n6] != n3 || i == n6) continue;
                        for (n2 = 0; n2 < AminoNet.this.N[n]; ++n2) {
                            if (AminoNet.this.grABIC[n][n2] != n3 || i == n2 || nArray2[n6][n2] <= nArray2[n6][n7] + nArray2[n7][n2]) continue;
                            nArray2[n6][n2] = nArray2[n6][n7] + nArray2[n7][n2];
                        }
                    }
                }
                for (n7 = 0; n7 < AminoNet.this.N[n]; ++n7) {
                    if (AminoNet.this.grABIC[n][n7] != n3 || i == n7) continue;
                    for (n6 = 0; n6 < n7; ++n6) {
                        if (AminoNet.this.grABIC[n][n6] != n3 || i == n6 || nArray2[n7][n6] >= 9999) continue;
                        int n8 = i;
                        dArray[n8] = dArray[n8] + (double)nArray2[n7][n6];
                    }
                    for (n6 = n7 + 1; n6 < AminoNet.this.N[n]; ++n6) {
                        if (AminoNet.this.grABIC[n][n6] != n3 || i == n6 || nArray2[n7][n6] >= 9999) continue;
                        int n9 = i;
                        dArray[n9] = dArray[n9] + (double)nArray2[n7][n6];
                    }
                }
                dArray[i] = Math.abs((double)(AminoNet.this.Lsum[n] / (n4 + 1) * n4) - dArray[i] / (double)n4 / (double)(n4 - 1));
                d += dArray[i];
            }
            double d2 = 0.0;
            double d3 = 0.0;
            d2 = d / (double)n4;
            for (n2 = 0; n2 < AminoNet.this.N[n]; ++n2) {
                if (AminoNet.this.grABIC[n][n2] != n3) continue;
                d3 += (dArray[n2] - d2) * (dArray[n2] - d2);
            }
            d3 /= (double)n4;
            d3 = Math.sqrt(d3);
            for (n2 = 0; n2 < AminoNet.this.N[n]; ++n2) {
                if (AminoNet.this.grABIC[n][n2] != n3) continue;
                dArray[n2] = dArray[n2] - d2;
                int n10 = 0;
                char c = ' ';
                switch (this.num) {
                    case 0: {
                        n10 = Integer.valueOf(AminoNet.this.rowDataA.elementAt(n2).elementAt(0).toString().trim());
                        c = AminoNet.this.rowDataA.elementAt(n2).elementAt(2).toString().charAt(0);
                        break;
                    }
                    case 1: {
                        n10 = Integer.valueOf(AminoNet.this.rowDataB.elementAt(n2).elementAt(0).toString().trim());
                        c = AminoNet.this.rowDataB.elementAt(n2).elementAt(2).toString().charAt(0);
                        break;
                    }
                    case 2: {
                        n10 = Integer.valueOf(AminoNet.this.rowDataI.elementAt(n2).elementAt(0).toString().trim());
                        c = AminoNet.this.rowDataI.elementAt(n2).elementAt(2).toString().charAt(0);
                        break;
                    }
                    case 3: {
                        n10 = Integer.valueOf(AminoNet.this.rowDataC.elementAt(n2).elementAt(0).toString().trim());
                        c = AminoNet.this.rowDataC.elementAt(n2).elementAt(2).toString().charAt(0);
                    }
                }
                this.zScore[n5][0] = n10;
                this.zScore[n5][1] = Character.valueOf(c);
                this.zScore[n5][2] = dArray[n2];
                ++n5;
            }
            System.out.println("ZLavg " + d2);
            DefaultTableModel defaultTableModel = new DefaultTableModel(this.zScore, this.zColNames){

                public Class getColumnClass(int n) {
                    Class clazz = n >= 0 && n < this.getColumnCount() ? this.getValueAt(0, n).getClass() : Object.class;
                    return clazz;
                }
            };
            JTable jTable = new JTable(defaultTableModel);
            TableRowSorter<1> tableRowSorter = new TableRowSorter<1>(defaultTableModel);
            jTable.setRowSorter(tableRowSorter);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.removeAll();
            this.add(jScrollPane);
        }

        @Override
        public void update(Graphics graphics) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.zcalc(AminoNet.this.wAdj[this.num], this.num);
            boolean bl = AminoNet.this.cb0.isSelected();
            AminoNet.this.cb0.setSelected(!bl);
            AminoNet.this.cb0.setSelected(bl);
            bl = AminoNet.this.cb1.isSelected();
            AminoNet.this.cb1.setSelected(!bl);
            AminoNet.this.cb1.setSelected(bl);
            bl = AminoNet.this.cb2.isSelected();
            AminoNet.this.cb2.setSelected(!bl);
            AminoNet.this.cb2.setSelected(bl);
            bl = AminoNet.this.cb3.isSelected();
            AminoNet.this.cb3.setSelected(!bl);
            AminoNet.this.cb3.setSelected(bl);
            this.repaint();
        }
    }

    class RanksPanel
    extends JPanel
    implements ItemListener {
        public static final long serialVersionUID = 0L;
        JPanel jza;
        JPanel jzb;
        JPanel jzi;
        JPanel jzc;

        public RanksPanel() {
            this.jza = new RanPanel(0);
            this.jzb = new RanPanel(1);
            this.jzi = new RanPanel(2);
            this.jzc = new RanPanel(3);
            this.setLayout(new GridLayout(0, 4));
            this.removeAll();
            this.add(this.jza);
            this.add(this.jzb);
            this.add(this.jzi);
            this.add(this.jzc);
            this.jza.setVisible(true);
            this.jzb.setVisible(false);
            this.jzi.setVisible(false);
            this.jzc.setVisible(false);
            AminoNet.this.cb0.addItemListener(this);
            AminoNet.this.cb1.addItemListener(this);
            AminoNet.this.cb2.addItemListener(this);
            AminoNet.this.cb3.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.jza.setVisible(AminoNet.this.cb0.isSelected());
            this.jzb.setVisible(AminoNet.this.cb1.isSelected());
            this.jzi.setVisible(AminoNet.this.cb2.isSelected());
            this.jzc.setVisible(AminoNet.this.cb3.isSelected());
        }
    }

    class RCirPanel
    extends JPanel
    implements MouseMotionListener,
    MouseListener,
    ActionListener {
        public static final long serialVersionUID = 0L;
        int num;
        String[] stitle = new String[]{"ALL", "Phobic", "Philic", "Charged"};
        int r = 6;
        int ox;
        int oy;
        float scale = 5.0f;
        float shiftx = 0.0f;
        float shifty = 0.0f;
        int w;
        int h;
        int x;
        int y;
        float xmid;
        float ymid;
        float zmid;
        float xmax = -2000.0f;
        float xmin = 200.0f;
        float ymax = -200.0f;
        float ymin = 200.0f;
        float zmax = -200.0f;
        float zmin = 200.0f;

        public RCirPanel(int n) {
            this.num = n;
            Border border = BorderFactory.createLineBorder(Color.black);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.stitle[this.num]);
            titledBorder.setTitleJustification(3);
            titledBorder.setTitlePosition(5);
            this.setBorder(titledBorder);
            this.setLayout(new GridLayout(0, 1));
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            AminoNet.this.jrrb.addActionListener(this);
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            super.paint(graphics);
            this.w = this.getWidth();
            this.h = this.getHeight();
            this.x = this.w / 2;
            this.y = this.h / 2;
            for (n = 0; n < AminoNet.this.N[0]; ++n) {
                switch (this.num) {
                    case 0: {
                        graphics.setColor(Color.black);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.blue);
                        break;
                    }
                    case 2: {
                        graphics.setColor(new Color(41, 104, 41));
                        break;
                    }
                    case 3: {
                        graphics.setColor(Color.red);
                    }
                }
                double d = 42.0 * Math.cos(6.28 / (double)AminoNet.this.N[0] * (double)n);
                double d2 = 42.0 * Math.sin(6.28 / (double)AminoNet.this.N[0] * (double)n);
                graphics.fillArc((int)(d * (double)this.scale + (double)this.shiftx + (double)this.x), (int)(d2 * (double)this.scale + (double)this.shifty + (double)this.y), this.r, this.r, 0, 360);
                if (!AminoNet.this.jrclb.isSelected() || n % 30 != 0) continue;
                graphics.drawString(AminoNet.this.rowDataA.elementAt(n).elementAt(0).toString(), (int)(d * (double)this.scale + (double)this.shiftx + (double)this.x), (int)(d2 * (double)this.scale + (double)this.shifty + (double)this.y) + 7);
            }
            n = 0;
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < AminoNet.this.N[this.num]; ++i) {
                int n3;
                switch (this.num) {
                    case 0: {
                        graphics.setColor(Color.gray);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.orange);
                        break;
                    }
                    case 2: {
                        graphics.setColor(Color.pink);
                        break;
                    }
                    case 3: {
                        graphics.setColor(Color.magenta);
                    }
                }
                switch (this.num) {
                    case 1: {
                        n = Integer.valueOf(AminoNet.this.rowDataB.elementAt(i).elementAt(0).toString().trim());
                        break;
                    }
                    case 2: {
                        n = Integer.valueOf(AminoNet.this.rowDataI.elementAt(i).elementAt(0).toString().trim());
                        break;
                    }
                    case 3: {
                        n = Integer.valueOf(AminoNet.this.rowDataC.elementAt(i).elementAt(0).toString().trim());
                        break;
                    }
                    case 0: {
                        n = Integer.valueOf(AminoNet.this.rowDataA.elementAt(i).elementAt(0).toString().trim());
                    }
                }
                for (n3 = n2; n3 < AminoNet.this.N[0] && n != Integer.valueOf(AminoNet.this.rowDataA.elementAt(n3).elementAt(0).toString().trim()); ++n3) {
                }
                n2 = n3;
                double d = 42.0 * Math.cos(6.28 / (double)AminoNet.this.N[0] * (double)n3);
                double d3 = 42.0 * Math.sin(6.28 / (double)AminoNet.this.N[0] * (double)n3);
                int n4 = 0;
                for (int j = i + 1; j < AminoNet.this.N[this.num]; ++j) {
                    int n5;
                    if (AminoNet.this.wAdj[this.num][i][j] <= 0) continue;
                    switch (this.num) {
                        case 1: {
                            n4 = Integer.valueOf(AminoNet.this.rowDataB.elementAt(j).elementAt(0).toString().trim());
                            break;
                        }
                        case 2: {
                            n4 = Integer.valueOf(AminoNet.this.rowDataI.elementAt(j).elementAt(0).toString().trim());
                            break;
                        }
                        case 3: {
                            n4 = Integer.valueOf(AminoNet.this.rowDataC.elementAt(j).elementAt(0).toString().trim());
                            break;
                        }
                        case 0: {
                            n4 = Integer.valueOf(AminoNet.this.rowDataA.elementAt(j).elementAt(0).toString().trim());
                        }
                    }
                    for (n5 = n2 + 1; n5 < AminoNet.this.N[0] && n4 != Integer.valueOf(AminoNet.this.rowDataA.elementAt(n5).elementAt(0).toString().trim()); ++n5) {
                    }
                    double d4 = 42.0 * Math.cos(6.28 / (double)AminoNet.this.N[0] * (double)n5);
                    double d5 = 42.0 * Math.sin(6.28 / (double)AminoNet.this.N[0] * (double)n5);
                    graphics.drawLine((int)(d * (double)this.scale + (double)this.shiftx + (double)this.x), (int)(d3 * (double)this.scale + (double)this.shifty + (double)this.y), (int)(d4 * (double)this.scale + (double)this.shiftx + (double)this.x), (int)(d5 * (double)this.scale + (double)this.shifty + (double)this.y));
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.isMetaDown()) {
                if (n2 > this.oy) {
                    if (this.r < 10) {
                        ++this.r;
                    }
                    this.scale = (float)((double)this.scale + 0.2);
                }
                if (n2 < this.oy) {
                    if (this.r > 2) {
                        --this.r;
                    }
                    if (this.scale > 0.0f) {
                        this.scale = (float)((double)this.scale - 0.2);
                    }
                }
                this.ox = n;
                this.oy = n2;
            } else if (mouseEvent.isShiftDown()) {
                if (n2 > this.oy) {
                    this.shifty += 1.0f;
                }
                if (n2 < this.oy) {
                    this.shifty -= 1.0f;
                }
                if (n > this.ox) {
                    this.shiftx += 1.0f;
                }
                if (n < this.ox) {
                    this.shiftx -= 1.0f;
                }
                this.ox = n;
                this.oy = n2;
            }
            this.ox = n;
            this.oy = n2;
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.shifty = 0.0f;
            this.shiftx = 0.0f;
            this.r = 5;
            this.scale = 5.0f;
            AminoNet.this.jrclb.setSelected(false);
            this.repaint();
        }
    }

    class RTextPanel
    extends JPanel {
        public static final long serialVersionUID = 0L;

        public RTextPanel() {
            AminoNet.this.jrp = new JComboBox();
            AminoNet.this.jrp.addItem("All");
            AminoNet.this.jrp.addItem("Hydrophobic");
            AminoNet.this.jrp.addItem("Hydrophilic");
            AminoNet.this.jrp.addItem("Charged");
            this.setLayout(new GridLayout(15, 1, 0, 10));
            this.add(AminoNet.this.jrp);
            this.add(AminoNet.this.jrclb);
            this.add(AminoNet.this.jrrb);
        }
    }

    class TwoDViewsPanel
    extends JPanel
    implements ItemListener {
        public static final long serialVersionUID = 0L;
        JPanel nutp;
        JPanel jpa;
        JPanel jpb;
        JPanel jpi;
        JPanel jpc;
        JPanel nuvp;

        public TwoDViewsPanel() {
            this.nutp = new RTextPanel();
            this.jpa = new RCirPanel(0);
            this.jpb = new RCirPanel(1);
            this.jpi = new RCirPanel(2);
            this.jpc = new RCirPanel(3);
            this.nuvp = this.jpa;
            this.setLayout(new BorderLayout());
            this.add((Component)this.nutp, "East");
            this.add((Component)this.nuvp, "Center");
            AminoNet.this.jrp.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.remove(this.nuvp);
            if (AminoNet.this.jrp.getSelectedItem().equals("All")) {
                this.nuvp = this.jpa;
            }
            if (AminoNet.this.jrp.getSelectedItem().equals("Hydrophobic")) {
                this.nuvp = this.jpb;
            }
            if (AminoNet.this.jrp.getSelectedItem().equals("Hydrophilic")) {
                this.nuvp = this.jpi;
            }
            if (AminoNet.this.jrp.getSelectedItem().equals("Charged")) {
                this.nuvp = this.jpc;
            }
            this.add((Component)this.nuvp, "Center");
            this.nuvp.setVisible(false);
            this.nuvp.repaint();
            this.nuvp.setVisible(true);
            super.repaint();
            this.repaint();
        }
    }

    class UValPanel
    extends JPanel
    implements ActionListener {
        public static final long serialVersionUID = 0L;
        int num;
        JLabel jlbClu = new JLabel("Cluster");
        JLabel jlbCno = new JLabel("0");
        JLabel jlbSel = new JLabel("");
        JLabel jlbCav = new JLabel("");
        JLabel jlbCwav = new JLabel("");
        JLabel jlbKav = new JLabel("");
        JLabel jlbSav = new JLabel("");
        JLabel jlbLres = new JLabel("");
        JLabel jlbCres = new JLabel("");
        JLabel jlbWijav = new JLabel("");
        JLabel jlbiso = new JLabel("");
        JLabel res_name = new JLabel("####");
        JCheckBox jcbSel = new JCheckBox("Show all");
        JCheckBox jcbCav = new JCheckBox("C");
        JCheckBox jcbCwav = new JCheckBox("Cw");
        JCheckBox jcbKav = new JCheckBox("K");
        JCheckBox jcbSav = new JCheckBox("S");
        JCheckBox jcbLres = new JCheckBox("Lres");
        JCheckBox jcbCres = new JCheckBox("Cres");
        JCheckBox jcbWijav = new JCheckBox("<Wij>");
        DecimalFormat df = new DecimalFormat("#######.###");
        int p = 0;
        String[] stitle = new String[]{"ALL", "Phobic", "Philic", "Charged"};
        String mychain = new String();

        public UValPanel(int n) {
            this.num = n;
            AminoNet.this.found[this.num] = false;
            Border border = BorderFactory.createLineBorder(Color.black);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.stitle[this.num]);
            titledBorder.setTitleJustification(3);
            this.setBorder(titledBorder);
            if (AminoNet.this.M[n] < 1) {
                return;
            }
            this.add(this.jlbClu);
            this.add(this.jlbCno);
            this.jlbCno.setText(AminoNet.this.clus[n].getSelectedItem().toString());
            AminoNet.this.clus[n].addActionListener(this);
            this.setLayout(new GridLayout(0, 2));
            this.add(this.jcbSel);
            this.add(this.jlbSel);
            this.add(this.jcbCav);
            this.add(this.jlbCav);
            this.add(this.jcbCwav);
            this.add(this.jlbCwav);
            this.add(this.jcbKav);
            this.add(this.jlbKav);
            this.add(this.jcbSav);
            this.add(this.jlbSav);
            this.add(this.jcbLres);
            this.add(this.jlbLres);
            this.add(this.jcbCres);
            this.add(this.jlbCres);
            this.add(this.jcbWijav);
            this.add(this.jlbWijav);
            this.add(this.res_name);
            this.add(this.jlbiso);
            AminoNet.this.tfr.addActionListener(this);
            AminoNet.this.tfr.setActionCommand("tfr");
            AminoNet.this.tfc.addActionListener(this);
            this.recalc(this.num);
            this.jcbSel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    UValPanel.this.jcbCav.setSelected(jCheckBox.isSelected());
                    UValPanel.this.jcbCwav.setSelected(jCheckBox.isSelected());
                    UValPanel.this.jcbKav.setSelected(jCheckBox.isSelected());
                    UValPanel.this.jcbSav.setSelected(jCheckBox.isSelected());
                    UValPanel.this.jcbLres.setSelected(jCheckBox.isSelected());
                    UValPanel.this.jcbCres.setSelected(jCheckBox.isSelected());
                    UValPanel.this.jcbWijav.setSelected(jCheckBox.isSelected());
                }
            });
            this.jcbKav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected() && AminoNet.this.found[UValPanel.this.num].booleanValue()) {
                        UValPanel.this.jlbKav.setText(UValPanel.this.df.format(AminoNet.this.K[UValPanel.this.num][UValPanel.this.p]));
                    } else {
                        UValPanel.this.jlbKav.setText("");
                    }
                }
            });
            this.jcbSav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected() && AminoNet.this.found[UValPanel.this.num].booleanValue()) {
                        UValPanel.this.jlbSav.setText(UValPanel.this.df.format(AminoNet.this.S[UValPanel.this.num][UValPanel.this.p]));
                    } else {
                        UValPanel.this.jlbSav.setText("");
                    }
                }
            });
            this.jcbCav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected() && AminoNet.this.found[UValPanel.this.num].booleanValue()) {
                        UValPanel.this.jlbCav.setText(UValPanel.this.df.format(AminoNet.this.C[UValPanel.this.num][UValPanel.this.p]));
                    } else {
                        UValPanel.this.jlbCav.setText("");
                    }
                }
            });
            this.jcbCwav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected() && AminoNet.this.found[UValPanel.this.num].booleanValue()) {
                        UValPanel.this.jlbCwav.setText(UValPanel.this.df.format(AminoNet.this.Cw[UValPanel.this.num][UValPanel.this.p]));
                    } else {
                        UValPanel.this.jlbCwav.setText("");
                    }
                }
            });
            this.jcbWijav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected() && AminoNet.this.found[UValPanel.this.num].booleanValue()) {
                        if (AminoNet.this.K[UValPanel.this.num][UValPanel.this.p] > 0) {
                            UValPanel.this.jlbWijav.setText(UValPanel.this.df.format((double)AminoNet.this.S[UValPanel.this.num][UValPanel.this.p] * 1.0 / (double)AminoNet.this.K[UValPanel.this.num][UValPanel.this.p]));
                        } else {
                            UValPanel.this.jlbWijav.setText("0");
                        }
                    } else {
                        UValPanel.this.jlbWijav.setText("");
                    }
                }
            });
            this.jcbLres.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int n = Integer.valueOf(AminoNet.this.clus[UValPanel.this.num].getSelectedItem().toString());
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected() && AminoNet.this.found[UValPanel.this.num].booleanValue()) {
                        UValPanel.this.jlbLres.setText(UValPanel.this.df.format((double)AminoNet.this.D[UValPanel.this.num][UValPanel.this.p] * 1.0 / (double)(AminoNet.this.Clu[UValPanel.this.num][n] - 1)));
                    } else {
                        UValPanel.this.jlbLres.setText("");
                    }
                }
            });
            this.jcbCres.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int n = Integer.valueOf(AminoNet.this.clus[UValPanel.this.num].getSelectedItem().toString());
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected() && AminoNet.this.found[UValPanel.this.num].booleanValue()) {
                        UValPanel.this.jlbCres.setText(UValPanel.this.df.format((double)(AminoNet.this.Clu[UValPanel.this.num][n] - 1) * 1.0 / (double)AminoNet.this.D[UValPanel.this.num][UValPanel.this.p]));
                    } else {
                        UValPanel.this.jlbCres.setText("");
                    }
                }
            });
        }

        public void recalc(int n) {
            int n2;
            int n3;
            try {
                n3 = Integer.parseInt(AminoNet.this.tfr.getText());
            }
            catch (Exception exception) {
                try {
                    for (n2 = 0; n2 < AminoNet.this.N[n]; ++n2) {
                        if (AminoNet.this.grABIC[n][n2] != Integer.valueOf(this.jlbCno.getText())) continue;
                        switch (n) {
                            case 0: {
                                AminoNet.this.tfr.setText(AminoNet.this.dataA.elementAt(n2).elementAt(0).elementAt(0).trim());
                                break;
                            }
                            case 1: {
                                AminoNet.this.tfr.setText(AminoNet.this.dataB.elementAt(n2).elementAt(0).elementAt(0).trim());
                                break;
                            }
                            case 2: {
                                AminoNet.this.tfr.setText(AminoNet.this.dataI.elementAt(n2).elementAt(0).elementAt(0).trim());
                                break;
                            }
                            case 3: {
                                AminoNet.this.tfr.setText(AminoNet.this.dataC.elementAt(n2).elementAt(0).elementAt(0).trim());
                            }
                        }
                        break;
                    }
                    System.out.println("#" + AminoNet.this.tfr.getText() + "#");
                    n3 = Integer.parseInt(AminoNet.this.tfr.getText());
                }
                catch (Exception exception2) {
                    System.out.println("Aabar " + exception2);
                    n3 = 0;
                }
            }
            try {
                this.mychain = AminoNet.this.tfc.getSelectedItem().toString();
            }
            catch (Exception exception) {
                System.out.println("Chain koi " + exception);
            }
            System.out.println("*" + this.mychain + "*");
            AminoNet.this.found[n] = false;
            for (int i = 0; i < AminoNet.this.N[n]; ++i) {
                n2 = 0;
                String string = "";
                try {
                    switch (n) {
                        case 0: {
                            n2 = Integer.parseInt(AminoNet.this.dataA.elementAt(i).elementAt(0).elementAt(0).trim());
                            string = AminoNet.this.dataA.elementAt(i).elementAt(0).elementAt(4).trim();
                            break;
                        }
                        case 1: {
                            n2 = Integer.parseInt(AminoNet.this.dataB.elementAt(i).elementAt(0).elementAt(0).trim());
                            string = AminoNet.this.dataB.elementAt(i).elementAt(0).elementAt(4).trim();
                            break;
                        }
                        case 2: {
                            n2 = Integer.parseInt(AminoNet.this.dataI.elementAt(i).elementAt(0).elementAt(0).trim());
                            string = AminoNet.this.dataI.elementAt(i).elementAt(0).elementAt(4).trim();
                            break;
                        }
                        case 3: {
                            n2 = Integer.parseInt(AminoNet.this.dataC.elementAt(i).elementAt(0).elementAt(0).trim());
                            string = AminoNet.this.dataC.elementAt(i).elementAt(0).elementAt(4).trim();
                        }
                    }
                    if (n3 != n2 || !string.equals(this.mychain.trim()) || Integer.valueOf(this.jlbCno.getText()) != AminoNet.this.grABIC[n][i]) continue;
                    switch (n) {
                        case 0: {
                            this.res_name.setText(AminoNet.this.rowDataA.elementAt(i).elementAt(1).toString());
                            break;
                        }
                        case 1: {
                            this.res_name.setText(AminoNet.this.rowDataB.elementAt(i).elementAt(1).toString());
                            break;
                        }
                        case 2: {
                            this.res_name.setText(AminoNet.this.rowDataI.elementAt(i).elementAt(1).toString());
                            break;
                        }
                        case 3: {
                            this.res_name.setText(AminoNet.this.rowDataC.elementAt(i).elementAt(1).toString());
                        }
                    }
                    AminoNet.this.found[n] = true;
                    System.out.println("r name " + i);
                    System.out.println("true " + n);
                    this.p = i;
                    break;
                }
                catch (Exception exception) {
                    AminoNet.this.found[n] = false;
                    System.out.println("Ekhane " + exception);
                }
            }
            this.repaint();
        }

        @Override
        public void update(Graphics graphics) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.jlbCno.setText(AminoNet.this.clus[this.num].getSelectedItem().toString());
            this.recalc(this.num);
            boolean bl = AminoNet.this.cb0.isSelected();
            AminoNet.this.cb0.setSelected(!bl);
            AminoNet.this.cb0.setSelected(bl);
            bl = AminoNet.this.cb1.isSelected();
            AminoNet.this.cb1.setSelected(!bl);
            AminoNet.this.cb1.setSelected(bl);
            bl = AminoNet.this.cb2.isSelected();
            AminoNet.this.cb2.setSelected(!bl);
            AminoNet.this.cb2.setSelected(bl);
            bl = AminoNet.this.cb3.isSelected();
            AminoNet.this.cb3.setSelected(!bl);
            AminoNet.this.cb3.setSelected(bl);
            if (("tfr".equals(actionEvent.getActionCommand()) || "comboBoxChanged".equals(actionEvent.getActionCommand())) && AminoNet.this.found[this.num].booleanValue()) {
                System.out.println("HOOOOO" + actionEvent.getActionCommand() + this.num);
                this.jcbCav.setSelected(!this.jcbCav.isSelected());
                this.jcbCav.setSelected(!this.jcbCav.isSelected());
                this.jcbCwav.setSelected(!this.jcbCwav.isSelected());
                this.jcbCwav.setSelected(!this.jcbCwav.isSelected());
                this.jcbKav.setSelected(!this.jcbKav.isSelected());
                this.jcbKav.setSelected(!this.jcbKav.isSelected());
                this.jcbSav.setSelected(!this.jcbSav.isSelected());
                this.jcbSav.setSelected(!this.jcbSav.isSelected());
                this.jcbLres.setSelected(!this.jcbLres.isSelected());
                this.jcbLres.setSelected(!this.jcbLres.isSelected());
                this.jcbCres.setSelected(!this.jcbCres.isSelected());
                this.jcbCres.setSelected(!this.jcbCres.isSelected());
                this.jcbWijav.setSelected(!this.jcbWijav.isSelected());
                this.jcbWijav.setSelected(!this.jcbWijav.isSelected());
                if (Integer.valueOf(AminoNet.this.K[this.num][this.p]) == 0) {
                    this.jlbiso.setText("isolated node");
                } else {
                    this.jlbiso.setText("");
                }
            }
            this.jcbSel.setSelected(!this.jcbSel.isSelected());
            this.jcbSel.setSelected(!this.jcbSel.isSelected());
            this.repaint();
        }
    }

    class UserValPanel
    extends JPanel
    implements ItemListener {
        public static final long serialVersionUID = 0L;
        JPanel jpa;
        JPanel jpb;
        JPanel jpi;
        JPanel jpc;

        public UserValPanel() {
            this.jpa = new UValPanel(0);
            this.jpb = new UValPanel(1);
            this.jpi = new UValPanel(2);
            this.jpc = new UValPanel(3);
            this.setLayout(new GridLayout(0, 4));
            this.add(this.jpa);
            this.add(this.jpb);
            this.add(this.jpi);
            this.add(this.jpc);
            this.jpa.setVisible(true);
            this.jpb.setVisible(false);
            this.jpi.setVisible(false);
            this.jpc.setVisible(false);
            AminoNet.this.cb0.addItemListener(this);
            AminoNet.this.cb1.addItemListener(this);
            AminoNet.this.cb2.addItemListener(this);
            AminoNet.this.cb3.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.jpa.setVisible(AminoNet.this.cb0.isSelected() && AminoNet.this.found[0] != false);
            this.jpb.setVisible(AminoNet.this.cb1.isSelected() && AminoNet.this.found[1] != false);
            this.jpi.setVisible(AminoNet.this.cb2.isSelected() && AminoNet.this.found[2] != false);
            this.jpc.setVisible(AminoNet.this.cb3.isSelected() && AminoNet.this.found[3] != false);
        }
    }

    class UTextPanel
    extends JPanel {
        public static final long serialVersionUID = 0L;
        JLabel jlr = new JLabel("Residue");
        JLabel jlc = new JLabel("Chain");

        public UTextPanel() {
            this.setLayout(new FlowLayout(4));
            AminoNet.this.tfr = new JTextField("", 4);
            AminoNet.this.tfc = new JComboBox();
            AminoNet.this.tfr.setToolTipText("Type a residue no. and press Return");
            AminoNet.this.tfc.setToolTipText("Select the chain");
            this.add(this.jlr);
            this.add(AminoNet.this.tfr);
            this.add(this.jlc);
            this.add(AminoNet.this.tfc);
            try {
                AminoNet.this.tfr.setText(AminoNet.this.dataA.elementAt(0).elementAt(0).elementAt(0).trim());
            }
            catch (Exception exception) {
                System.out.println("phanka " + exception);
            }
            try {
                for (int i = 0; i < AminoNet.this.chain.size(); ++i) {
                    AminoNet.this.tfc.addItem(AminoNet.this.chain.elementAt(i));
                }
            }
            catch (Exception exception) {
                System.out.println("tfc phanka " + exception);
            }
        }
    }

    class UValuesPanel
    extends JPanel {
        public static final long serialVersionUID = 0L;
        JPanel jutp;
        JPanel juvp;

        public UValuesPanel() {
            this.jutp = new UTextPanel();
            this.juvp = new UserValPanel();
            this.setLayout(new BorderLayout());
            this.add((Component)this.jutp, "First");
            this.add((Component)this.juvp, "Center");
        }
    }

    class GraPanel
    extends JPanel
    implements ItemListener {
        public static final long serialVersionUID = 0L;
        String[] stitle = new String[]{"ALL", "Phobic", "Philic", "Charged"};
        int[] sameK;
        int tillNow;
        double[] PK;
        double[] CK;
        double[] CwK;
        double[] SK;
        int n;
        int maxK = 0;
        double maxPK = 0.0;
        double maxSK = 0.0;
        double maxCK = 0.0;
        double maxCwK = 0.0;
        int group;
        int xPt;
        int yPt;

        GraPanel(int n) {
            this.n = n;
            Border border = BorderFactory.createLineBorder(Color.black);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.stitle[n]);
            titledBorder.setTitleJustification(3);
            this.setBorder(titledBorder);
            System.out.println("Value of M[n] " + n + " " + AminoNet.this.M[n]);
            if (AminoNet.this.M[n] < 1) {
                System.out.println("Bari Jao");
                return;
            }
            if (AminoNet.this.M[n] < 1) {
                return;
            }
            AminoNet.this.jgp.addItemListener(this);
            AminoNet.this.vhcb[n].addItemListener(this);
            this.group = Integer.valueOf(AminoNet.this.clus[n].getSelectedItem().toString());
            this.regraph(n, this.group);
        }

        public void regraph(int n, int n2) {
            int n3;
            this.sameK = new int[AminoNet.this.Clu[n][n2]];
            this.PK = new double[AminoNet.this.Clu[n][n2]];
            this.SK = new double[AminoNet.this.Clu[n][n2]];
            this.CK = new double[AminoNet.this.Clu[n][n2]];
            this.CwK = new double[AminoNet.this.Clu[n][n2]];
            int n4 = 0;
            int n5 = 0;
            System.out.println("group= " + n2 + " n= " + n + "Clu[n][group]= " + AminoNet.this.Clu[n][n2]);
            for (n3 = 0; n3 < AminoNet.this.N[n]; ++n3) {
                if (AminoNet.this.grABIC[n][n3] != n2) continue;
                n4 = n3;
                System.out.println("fRes +n: " + n4 + " " + n);
                break;
            }
            this.sameK[0] = AminoNet.this.K[n][n4];
            this.PK[0] = 1.0;
            this.SK[0] = AminoNet.this.S[n][n4];
            this.CK[0] = AminoNet.this.C[n][n4];
            this.CwK[0] = AminoNet.this.Cw[n][n4];
            this.tillNow = 1;
            for (n3 = n4 + 1; n3 < AminoNet.this.N[n]; ++n3) {
                int n6;
                if (AminoNet.this.grABIC[n][n3] != n2) continue;
                for (n6 = 0; n6 < this.tillNow; ++n6) {
                    if (this.sameK[n6] != AminoNet.this.K[n][n3]) continue;
                    int n7 = n6;
                    this.PK[n7] = this.PK[n7] + 1.0;
                    int n8 = n6;
                    this.SK[n8] = this.SK[n8] + (double)AminoNet.this.S[n][n3];
                    int n9 = n6;
                    this.CK[n9] = this.CK[n9] + AminoNet.this.C[n][n3];
                    int n10 = n6;
                    this.CwK[n10] = this.CwK[n10] + AminoNet.this.Cw[n][n3];
                    break;
                }
                if (n6 == this.tillNow) {
                    ++this.tillNow;
                    this.sameK[n6] = AminoNet.this.K[n][n3];
                    this.PK[n6] = 1.0;
                    this.SK[n6] = AminoNet.this.S[n][n3];
                    this.CK[n6] = AminoNet.this.C[n][n3];
                    this.CwK[n6] = AminoNet.this.Cw[n][n3];
                }
                ++n5;
            }
            n3 = 0;
            while (n3 < this.tillNow) {
                if (this.PK[n3] > 0.0) {
                    int n11 = n3;
                    this.SK[n11] = this.SK[n11] / this.PK[n3];
                    int n12 = n3;
                    this.CK[n12] = this.CK[n12] / this.PK[n3];
                    int n13 = n3;
                    this.CwK[n13] = this.CwK[n13] / this.PK[n3];
                }
                int n14 = n3++;
                this.PK[n14] = this.PK[n14] / (double)n5;
            }
            this.maxK = 0;
            this.maxPK = 0.0;
            this.maxSK = 0.0;
            this.maxCK = 0.0;
            this.maxCwK = 0.0;
            for (n3 = 0; n3 < this.tillNow; ++n3) {
                if (this.maxK < this.sameK[n3]) {
                    this.maxK = this.sameK[n3];
                }
                if (this.maxPK < this.PK[n3]) {
                    this.maxPK = this.PK[n3];
                }
                if (this.maxSK < this.SK[n3]) {
                    this.maxSK = this.SK[n3];
                }
                if (this.maxCK < this.CK[n3]) {
                    this.maxCK = this.CK[n3];
                }
                if (!(this.maxCwK < this.CwK[n3])) continue;
                this.maxCwK = this.CwK[n3];
            }
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            double d;
            double d2;
            int n2 = 20;
            if (AminoNet.this.M[this.n] < 1) {
                return;
            }
            super.paint(graphics);
            switch (this.n) {
                case 0: {
                    graphics.setColor(Color.black);
                    break;
                }
                case 1: {
                    graphics.setColor(Color.blue);
                    break;
                }
                case 2: {
                    graphics.setColor(new Color(57, 159, 67));
                    break;
                }
                case 3: {
                    graphics.setColor(Color.red);
                }
            }
            int n3 = 30;
            int n4 = 180;
            if (AminoNet.this.jgp.getSelectedItem().equals("P(k) vs k")) {
                System.out.println(AminoNet.this.jgp.getSelectedItem());
                System.out.println("n maxK  maxPK  " + this.n + " " + this.maxK + " " + this.maxPK);
                d2 = (360.0 - (double)n3) / (double)this.maxK;
                d = ((double)n4 - 10.0) / this.maxPK;
                graphics.drawLine(n3 + n2, 10, n3 + n2, n4);
                graphics.drawString("k", 200, 204);
                graphics.drawLine(n3 + n2, n4, 360 + n2, n4);
                graphics.drawString("P(k)", 5, 100);
                n = 0;
                while (d2 * (double)n <= (double)(360 - n3)) {
                    graphics.drawLine((int)((double)n3 + d2 * (double)n) + n2, n4, (int)((double)n3 + d2 * (double)n) + n2, n4 + 3);
                    graphics.drawString("" + n, (int)((double)n3 + d2 * (double)n - 5.0) + n2, n4 + 18);
                    ++n;
                }
                for (n = 0; n <= 10; ++n) {
                    graphics.drawLine(n3 + n2, (int)(180.0 - 17.0 * d * (double)n), n3 - 3 + n2, (int)(180.0 - 17.0 * d * (double)n));
                    graphics.drawString("." + n, n3 - 14 + n2, (int)(180.0 - (double)(17 * n) * d + 6.0));
                }
                for (n = 0; n < this.tillNow; ++n) {
                    System.out.println(this.sameK[n] + " " + this.PK[n]);
                    graphics.fillArc((int)((double)this.sameK[n] * d2 + (double)n3) + n2, (int)((double)n4 - this.PK[n] * d), 3, 3, 0, 360);
                }
            }
            if (AminoNet.this.jgp.getSelectedItem().equals("s(k) vs k")) {
                System.out.println(AminoNet.this.jgp.getSelectedItem());
                d2 = (360.0 - (double)n3) / (double)this.maxK;
                d = ((double)n4 - 10.0) / this.maxSK;
                graphics.drawLine(n3 + n2, 10, n3 + n2, n4);
                graphics.drawString("k", 200, 190);
                graphics.drawLine(n3 + n2, n4, 360 + n2, n4);
                graphics.drawString("S(k)", 5, 100);
                n = 0;
                while (d2 * (double)n <= (double)(360 - n3)) {
                    graphics.drawLine((int)((double)n3 + d2 * (double)n) + n2, n4, (int)((double)n3 + d2 * (double)n) + n2, n4 + 3);
                    graphics.drawString("" + n, (int)((double)n3 + d2 * (double)n - 5.0) + n2, n4 + 18);
                    ++n;
                }
                n = 0;
                while (d * (double)n <= (double)(n4 - 10)) {
                    graphics.drawLine(n3 + n2, (int)(180.0 - d * (double)n), n3 - 3 + n2, (int)(180.0 - d * (double)n));
                    n += 5;
                }
                for (n = 0; n < this.tillNow; ++n) {
                    graphics.fillArc((int)((double)this.sameK[n] * d2 + (double)n3) + n2, (int)((double)n4 - this.SK[n] * d), 3, 3, 0, 360);
                }
            }
            if (AminoNet.this.jgp.getSelectedItem().equals("C(k) vs k")) {
                System.out.println(AminoNet.this.jgp.getSelectedItem());
                d2 = (360.0 - (double)n3) / (double)this.maxK;
                d = ((double)n4 - 10.0) / this.maxCK;
                graphics.drawLine(n3 + n2, 10, n3 + n2, n4);
                graphics.drawString("k", 200, 190);
                graphics.drawLine(n3 + n2, n4, 360 + n2, n4);
                graphics.drawString("C(k)", 5, 100);
                n = 0;
                while (d2 * (double)n <= (double)(360 - n3)) {
                    graphics.drawLine((int)((double)n3 + d2 * (double)n) + n2, n4, (int)((double)n3 + d2 * (double)n) + n2, n4 + 3);
                    graphics.drawString("" + n, (int)((double)n3 + d2 * (double)n - 5.0) + n2, n4 + 18);
                    ++n;
                }
                for (n = 0; n <= 10; ++n) {
                    graphics.drawLine(n3 + n2, (int)(180.0 - d * (double)n / 10.0), n3 - 3 + n2, (int)(180.0 - d * (double)n / 10.0));
                    graphics.drawString("." + n, n3 - 14 + n2, (int)(180.0 - d * (double)n / 10.0 + 6.0));
                }
                for (n = 0; n < this.tillNow; ++n) {
                    if (!(this.CK[n] > 0.0)) continue;
                    graphics.fillArc((int)((double)this.sameK[n] * d2 + (double)n3) + n2, (int)((double)n4 - this.CK[n] * d), 3, 3, 0, 360);
                }
            }
            if (AminoNet.this.jgp.getSelectedItem().equals("Cw(k) vs k")) {
                System.out.println(AminoNet.this.jgp.getSelectedItem());
                d2 = (360.0 - (double)n3) / (double)this.maxK;
                d = ((double)n4 - 10.0) / this.maxCwK;
                graphics.drawLine(n3 + n2, 10, n3 + n2, n4);
                graphics.drawString("k", 200, 190);
                graphics.drawLine(n3 + n2, n4, 360 + n2, n4);
                graphics.drawString("Cw(k)", 5, 100);
                n = 0;
                while (d2 * (double)n <= (double)(360 - n3)) {
                    graphics.drawLine((int)((double)n3 + d2 * (double)n) + n2, n4, (int)((double)n3 + d2 * (double)n) + n2, n4 + 3);
                    graphics.drawString("" + n, (int)((double)n3 + d2 * (double)n - 5.0) + n2, n4 + 18);
                    ++n;
                }
                for (n = 0; n <= 10; ++n) {
                    graphics.drawLine(n3 + n2, (int)(180.0 - d * (double)n / 10.0), n3 - 3 + n2, (int)(180.0 - d * (double)n / 10.0));
                    graphics.drawString("." + n, n3 - 14 + n2, (int)(180.0 - d * (double)n / 10.0 + 6.0));
                }
                for (n = 0; n < this.tillNow; ++n) {
                    if (!(this.CwK[n] > 0.0)) continue;
                    graphics.fillArc((int)((double)this.sameK[n] * d2 + (double)n3 + (double)n2), (int)((double)n4 - this.CwK[n] * d), 3, 3, 0, 360);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            System.out.println("CCCCLItem ");
            this.group = Integer.valueOf(AminoNet.this.clus[this.n].getSelectedItem().toString());
            this.regraph(this.n, this.group);
            this.repaint();
        }
    }

    class GDisPanel
    extends JPanel
    implements ItemListener {
        public static final long serialVersionUID = 0L;
        JPanel jga;
        JPanel jgb;
        JPanel jgi;
        JPanel jgc;

        public GDisPanel() {
            this.jga = new GraPanel(0);
            this.jgb = new GraPanel(1);
            this.jgi = new GraPanel(2);
            this.jgc = new GraPanel(3);
            this.setLayout(new GridLayout(0, 2));
            this.add(this.jga);
            this.add(this.jgb);
            this.add(this.jgi);
            this.add(this.jgc);
            this.jga.setVisible(true);
            this.jgb.setVisible(false);
            this.jgi.setVisible(false);
            this.jgc.setVisible(false);
            AminoNet.this.cb0.addItemListener(this);
            AminoNet.this.cb1.addItemListener(this);
            AminoNet.this.cb2.addItemListener(this);
            AminoNet.this.cb3.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.jga.setVisible(AminoNet.this.cb0.isSelected());
            this.jgb.setVisible(AminoNet.this.cb1.isSelected());
            this.jgi.setVisible(AminoNet.this.cb2.isSelected());
            this.jgc.setVisible(AminoNet.this.cb3.isSelected());
        }
    }

    class GTextPanel
    extends JPanel {
        public static final long serialVersionUID = 0L;

        public GTextPanel() {
            AminoNet.this.jgp = new JComboBox();
            AminoNet.this.jgp.addItem("P(k) vs k");
            AminoNet.this.jgp.addItem("s(k) vs k");
            AminoNet.this.jgp.addItem("C(k) vs k");
            AminoNet.this.jgp.addItem("Cw(k) vs k");
            this.add(AminoNet.this.jgp);
            AminoNet.this.jgp.setToolTipText("Select Plot Type");
        }
    }

    class GraphsPanel
    extends JPanel {
        public static final long serialVersionUID = 0L;
        JPanel jgtp;
        JPanel jgdp;

        public GraphsPanel() {
            this.jgtp = new GTextPanel();
            this.jgdp = new GDisPanel();
            this.setLayout(new BorderLayout());
            this.add((Component)this.jgtp, "First");
            this.add((Component)this.jgdp, "Center");
        }
    }

    class NetPanel
    extends JPanel
    implements MouseMotionListener,
    MouseListener,
    ActionListener,
    ItemListener {
        public static final long serialVersionUID = 0L;
        int num;
        String[] stitle = new String[]{"ALL", "Phobic", "Philic", "Charged"};
        int r = 6;
        int ox;
        int oy;
        float alpha = 0.0f;
        float beta = 0.0f;
        float scale = 5.0f;
        float shiftx = 0.0f;
        float shifty = 0.0f;
        int w;
        int h;
        int x;
        int y;
        float xmid;
        float ymid;
        float zmid;
        float xmax = -2000.0f;
        float xmin = 200.0f;
        float ymax = -200.0f;
        float ymin = 200.0f;
        float zmax = -200.0f;
        float zmin = 200.0f;

        public NetPanel(int n) {
            this.num = n;
            Border border = BorderFactory.createLineBorder(Color.black);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.stitle[this.num]);
            titledBorder.setTitleJustification(3);
            this.setBorder(titledBorder);
            this.setLayout(new GridLayout(0, 1));
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            AminoNet.this.jclb.addItemListener(this);
            AminoNet.this.jrb.addActionListener(this);
            for (int i = 0; i < AminoNet.this.N[this.num]; ++i) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                switch (this.num) {
                    case 0: {
                        f = Float.parseFloat(AminoNet.this.dataA.elementAt(i).elementAt(0).elementAt(1));
                        f2 = Float.parseFloat(AminoNet.this.dataA.elementAt(i).elementAt(0).elementAt(2));
                        f3 = Float.parseFloat(AminoNet.this.dataA.elementAt(i).elementAt(0).elementAt(3));
                        break;
                    }
                    case 1: {
                        f = Float.parseFloat(AminoNet.this.dataB.elementAt(i).elementAt(0).elementAt(1));
                        f2 = Float.parseFloat(AminoNet.this.dataB.elementAt(i).elementAt(0).elementAt(2));
                        f3 = Float.parseFloat(AminoNet.this.dataB.elementAt(i).elementAt(0).elementAt(3));
                        break;
                    }
                    case 2: {
                        f = Float.parseFloat(AminoNet.this.dataI.elementAt(i).elementAt(0).elementAt(1));
                        f2 = Float.parseFloat(AminoNet.this.dataI.elementAt(i).elementAt(0).elementAt(2));
                        f3 = Float.parseFloat(AminoNet.this.dataI.elementAt(i).elementAt(0).elementAt(3));
                        break;
                    }
                    case 3: {
                        f = Float.parseFloat(AminoNet.this.dataC.elementAt(i).elementAt(0).elementAt(1));
                        f2 = Float.parseFloat(AminoNet.this.dataC.elementAt(i).elementAt(0).elementAt(2));
                        f3 = Float.parseFloat(AminoNet.this.dataC.elementAt(i).elementAt(0).elementAt(3));
                    }
                }
                this.xmax = f > this.xmax ? f : this.xmax;
                this.xmin = f < this.xmin ? f : this.xmin;
                this.ymax = f2 > this.ymax ? f2 : this.ymax;
                this.ymin = f2 < this.ymin ? f2 : this.ymin;
                this.zmax = f3 > this.zmax ? f3 : this.zmax;
                this.zmin = f3 < this.zmin ? f3 : this.zmin;
            }
            this.xmid = (this.xmax + this.xmin) / 2.0f;
            this.ymid = (this.ymax + this.ymin) / 2.0f;
            this.zmid = (this.zmax + this.zmin) / 2.0f;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.w = this.getWidth();
            this.h = this.getHeight();
            this.x = this.w / 2;
            this.y = this.h / 2;
            graphics.drawLine(this.w - 8, this.h - 8, this.w - 30, this.h - 8);
            graphics.drawLine(this.w - 8, this.h - 8, this.w - 8, this.h - 30);
            graphics.drawLine(this.w - 8, this.h - 8, this.w - 30, this.h - 30);
            String string = "";
            for (int i = 0; i < AminoNet.this.N[this.num]; ++i) {
                switch (this.num) {
                    case 0: {
                        graphics.setColor(Color.black);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.blue);
                        break;
                    }
                    case 2: {
                        graphics.setColor(new Color(57, 159, 67));
                        break;
                    }
                    case 3: {
                        graphics.setColor(Color.red);
                    }
                }
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                switch (this.num) {
                    case 0: {
                        if (AminoNet.this.jclb.isSelected()) {
                            string = AminoNet.this.rowDataA.elementAt(i).elementAt(2).toString() + "" + AminoNet.this.rowDataA.elementAt(i).elementAt(0).toString().trim();
                        }
                        f = Float.parseFloat(AminoNet.this.dataA.elementAt(i).elementAt(0).elementAt(1));
                        f2 = Float.parseFloat(AminoNet.this.dataA.elementAt(i).elementAt(0).elementAt(2));
                        f3 = Float.parseFloat(AminoNet.this.dataA.elementAt(i).elementAt(0).elementAt(3));
                        break;
                    }
                    case 1: {
                        if (AminoNet.this.jclb.isSelected()) {
                            string = AminoNet.this.rowDataB.elementAt(i).elementAt(2).toString() + "" + AminoNet.this.rowDataB.elementAt(i).elementAt(0).toString().trim();
                        }
                        f = Float.parseFloat(AminoNet.this.dataB.elementAt(i).elementAt(0).elementAt(1));
                        f2 = Float.parseFloat(AminoNet.this.dataB.elementAt(i).elementAt(0).elementAt(2));
                        f3 = Float.parseFloat(AminoNet.this.dataB.elementAt(i).elementAt(0).elementAt(3));
                        break;
                    }
                    case 2: {
                        if (AminoNet.this.jclb.isSelected()) {
                            string = AminoNet.this.rowDataI.elementAt(i).elementAt(2).toString() + "" + AminoNet.this.rowDataI.elementAt(i).elementAt(0).toString().trim();
                        }
                        f = Float.parseFloat(AminoNet.this.dataI.elementAt(i).elementAt(0).elementAt(1));
                        f2 = Float.parseFloat(AminoNet.this.dataI.elementAt(i).elementAt(0).elementAt(2));
                        f3 = Float.parseFloat(AminoNet.this.dataI.elementAt(i).elementAt(0).elementAt(3));
                        break;
                    }
                    case 3: {
                        if (AminoNet.this.jclb.isSelected()) {
                            string = AminoNet.this.rowDataC.elementAt(i).elementAt(2).toString() + "" + AminoNet.this.rowDataC.elementAt(i).elementAt(0).toString().trim();
                        }
                        f = Float.parseFloat(AminoNet.this.dataC.elementAt(i).elementAt(0).elementAt(1));
                        f2 = Float.parseFloat(AminoNet.this.dataC.elementAt(i).elementAt(0).elementAt(2));
                        f3 = Float.parseFloat(AminoNet.this.dataC.elementAt(i).elementAt(0).elementAt(3));
                    }
                }
                float f4 = f -= this.xmid;
                float f5 = f2 -= this.ymid;
                float f6 = f3 -= this.zmid;
                f4 = f * (float)Math.cos(this.beta) + f3 * (float)Math.sin(this.beta);
                f6 = -f * (float)Math.sin(this.beta) + f3 * (float)Math.cos(this.beta);
                f2 = f5;
                f3 = f6;
                f5 = f2 * (float)Math.cos(this.alpha) - f3 * (float)Math.sin(this.alpha);
                f6 = f2 * (float)Math.sin(this.alpha) + f3 * (float)Math.cos(this.alpha);
                graphics.fillArc((int)(f4 * this.scale + this.shiftx + (float)this.x), (int)(f5 * this.scale + this.shifty + (float)this.y), this.r, this.r, 0, 360);
                graphics.setColor(Color.magenta);
                graphics.drawString(string, (int)(f4 * this.scale + this.shiftx + (float)this.x), (int)(f5 * this.scale + this.shifty + (float)this.y));
                switch (this.num) {
                    case 0: {
                        graphics.setColor(Color.black);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.blue);
                        break;
                    }
                    case 2: {
                        graphics.setColor(new Color(57, 159, 67));
                        break;
                    }
                    case 3: {
                        graphics.setColor(Color.red);
                    }
                }
                for (int j = 0; j < i; ++j) {
                    if (AminoNet.this.wAdj[this.num][i][j] <= 0) continue;
                    float f7 = 0.0f;
                    float f8 = 0.0f;
                    float f9 = 0.0f;
                    switch (this.num) {
                        case 0: {
                            f7 = Float.parseFloat(AminoNet.this.dataA.elementAt(j).elementAt(0).elementAt(1));
                            f8 = Float.parseFloat(AminoNet.this.dataA.elementAt(j).elementAt(0).elementAt(2));
                            f9 = Float.parseFloat(AminoNet.this.dataA.elementAt(j).elementAt(0).elementAt(3));
                            break;
                        }
                        case 1: {
                            f7 = Float.parseFloat(AminoNet.this.dataB.elementAt(j).elementAt(0).elementAt(1));
                            f8 = Float.parseFloat(AminoNet.this.dataB.elementAt(j).elementAt(0).elementAt(2));
                            f9 = Float.parseFloat(AminoNet.this.dataB.elementAt(j).elementAt(0).elementAt(3));
                            break;
                        }
                        case 2: {
                            f7 = Float.parseFloat(AminoNet.this.dataI.elementAt(j).elementAt(0).elementAt(1));
                            f8 = Float.parseFloat(AminoNet.this.dataI.elementAt(j).elementAt(0).elementAt(2));
                            f9 = Float.parseFloat(AminoNet.this.dataI.elementAt(j).elementAt(0).elementAt(3));
                            break;
                        }
                        case 3: {
                            f7 = Float.parseFloat(AminoNet.this.dataC.elementAt(j).elementAt(0).elementAt(1));
                            f8 = Float.parseFloat(AminoNet.this.dataC.elementAt(j).elementAt(0).elementAt(2));
                            f9 = Float.parseFloat(AminoNet.this.dataC.elementAt(j).elementAt(0).elementAt(3));
                        }
                    }
                    float f10 = f7 -= this.xmid;
                    float f11 = f8 -= this.ymid;
                    float f12 = f9 -= this.zmid;
                    f10 = f7 * (float)Math.cos(this.beta) + f9 * (float)Math.sin(this.beta);
                    f12 = -f7 * (float)Math.sin(this.beta) + f9 * (float)Math.cos(this.beta);
                    f8 = f11;
                    f9 = f12;
                    f11 = f8 * (float)Math.cos(this.alpha) - f9 * (float)Math.sin(this.alpha);
                    f12 = f8 * (float)Math.sin(this.alpha) + f9 * (float)Math.cos(this.alpha);
                    graphics.drawLine((int)(f4 * this.scale + this.shiftx + (float)this.x), (int)(f5 * this.scale + this.shifty + (float)this.y), (int)(f10 * this.scale + this.shiftx + (float)this.x), (int)(f11 * this.scale + this.shifty + (float)this.y));
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.isMetaDown()) {
                if (n2 > this.oy) {
                    if (this.r < 10) {
                        ++this.r;
                    }
                    this.scale = (float)((double)this.scale + 0.2);
                }
                if (n2 < this.oy) {
                    if (this.r > 2) {
                        --this.r;
                    }
                    if (this.scale > 0.0f) {
                        this.scale = (float)((double)this.scale - 0.2);
                    }
                }
                this.ox = n;
                this.oy = n2;
            } else if (mouseEvent.isShiftDown()) {
                if (n2 > this.oy) {
                    this.shifty += 1.0f;
                }
                if (n2 < this.oy) {
                    this.shifty -= 1.0f;
                }
                if (n > this.ox) {
                    this.shiftx += 1.0f;
                }
                if (n < this.ox) {
                    this.shiftx -= 1.0f;
                }
                this.ox = n;
                this.oy = n2;
            } else {
                if (n2 > this.oy && this.oy % 5 == 0) {
                    this.alpha = (float)((double)this.alpha + 0.2);
                }
                if (n2 < this.oy && this.oy % 5 == 0) {
                    this.alpha = (float)((double)this.alpha - 0.2);
                }
                if (n > this.ox && this.ox % 5 == 0) {
                    this.beta = (float)((double)this.beta + 0.2);
                }
                if (n < this.ox && this.ox % 5 == 0) {
                    this.beta = (float)((double)this.beta - 0.2);
                }
                this.ox = n;
                this.oy = n2;
            }
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("jrb")) {
                this.alpha = 0.0f;
                this.beta = 0.0f;
                this.shifty = 0.0f;
                this.shiftx = 0.0f;
                this.r = 5;
                this.scale = 5.0f;
                AminoNet.this.jclb.setSelected(false);
                this.repaint();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.repaint();
        }
    }

    class NTextPanel
    extends JPanel {
        public static final long serialVersionUID = 0L;

        public NTextPanel() {
            AminoNet.this.jnp = new JComboBox();
            AminoNet.this.jnp.addItem("All");
            AminoNet.this.jnp.addItem("Hydrophobic");
            AminoNet.this.jnp.addItem("Hydrophilic");
            AminoNet.this.jnp.addItem("Charged");
            this.add(AminoNet.this.jnp);
            this.add(AminoNet.this.jclb);
            this.add(AminoNet.this.jrb);
            AminoNet.this.jrb.setActionCommand("jrb");
        }
    }

    class NetworksPanel
    extends JPanel
    implements ItemListener {
        public static final long serialVersionUID = 0L;
        JPanel nutp;
        JPanel jna;
        JPanel jnb;
        JPanel jni;
        JPanel jnc;
        JPanel nuvp;

        public NetworksPanel() {
            this.nutp = new NTextPanel();
            this.jna = new NetPanel(0);
            this.jnb = new NetPanel(1);
            this.jni = new NetPanel(2);
            this.jnc = new NetPanel(3);
            this.nuvp = this.jna;
            this.setLayout(new BorderLayout());
            this.add((Component)this.nutp, "First");
            this.add((Component)this.nuvp, "Center");
            this.nuvp.setVisible(true);
            AminoNet.this.jnp.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.remove(this.nuvp);
            if (AminoNet.this.jnp.getSelectedItem().equals("All")) {
                this.nuvp = this.jna;
            }
            if (AminoNet.this.jnp.getSelectedItem().equals("Hydrophobic")) {
                this.nuvp = this.jnb;
            }
            if (AminoNet.this.jnp.getSelectedItem().equals("Hydrophilic")) {
                this.nuvp = this.jni;
            }
            if (AminoNet.this.jnp.getSelectedItem().equals("Charged")) {
                this.nuvp = this.jnc;
            }
            this.add((Component)this.nuvp, "Center");
            this.nuvp.setVisible(false);
            this.nuvp.repaint();
            this.nuvp.setVisible(true);
            super.repaint();
            this.repaint();
        }
    }

    class ValPanel
    extends JPanel
    implements ActionListener {
        public static final long serialVersionUID = 0L;
        int group;
        JLabel jlbClu = new JLabel("Cluster no.");
        JLabel jlbSel = new JLabel("");
        JLabel jlbCav = new JLabel("");
        JLabel jlbCwav = new JLabel("");
        JLabel jlbR = new JLabel("");
        JLabel jlbP = new JLabel("");
        JLabel jlbQ = new JLabel("");
        JLabel jlbN = new JLabel("");
        JLabel jlbKav = new JLabel("");
        JLabel jlbSav = new JLabel("");
        JLabel jlbL = new JLabel("");
        JLabel jlbLr = new JLabel("");
        JLabel jlbCr = new JLabel("");
        JLabel jlbWijav = new JLabel("");
        JCheckBox jcbSel = new JCheckBox("Show all");
        JCheckBox jcbCav = new JCheckBox("C");
        JCheckBox jcbCwav = new JCheckBox("Cw");
        JCheckBox jcbR = new JCheckBox("r");
        JCheckBox jcbP = new JCheckBox("p");
        JCheckBox jcbQ = new JCheckBox("q");
        JCheckBox jcbN = new JCheckBox("N");
        JCheckBox jcbKav = new JCheckBox("<K>");
        JCheckBox jcbSav = new JCheckBox("<S>");
        JCheckBox jcbL = new JCheckBox("L");
        JCheckBox jcbLr = new JCheckBox("Lr");
        JCheckBox jcbCr = new JCheckBox("Cr");
        JCheckBox jcbWijav = new JCheckBox("<Wij>");
        DecimalFormat df = new DecimalFormat("#######.###");
        int n;
        String[] stitle = new String[]{"ALL", "Phobic", "Philic", "Charged"};
        String resNums = new String("<html>test</html>");

        public ValPanel(final int n) {
            int n2;
            this.n = n;
            AminoNet.this.vhcb[n] = new JCheckBox("", true);
            AminoNet.this.vhcb[n].setActionCommand("vhcb" + n);
            Border border = BorderFactory.createLineBorder(Color.black);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.stitle[n]);
            titledBorder.setTitleJustification(3);
            this.setBorder(titledBorder);
            AminoNet.this.clus[n] = new JComboBox();
            if (AminoNet.this.M[n] < 1) {
                return;
            }
            this.setLayout(new GridLayout(0, 2));
            this.add(this.jlbClu);
            this.add(AminoNet.this.clus[n]);
            for (n2 = 0; n2 < AminoNet.this.M[n]; ++n2) {
                AminoNet.this.clus[n].addItem(AminoNet.this.clNo[n][n2]);
            }
            this.group = AminoNet.this.clNo[n][0];
            this.resNums = new String("<html>");
            n2 = 0;
            for (int i = 0; i < AminoNet.this.N[n]; ++i) {
                if (AminoNet.this.grABIC[n][i] != this.group) continue;
                ++n2;
                switch (n) {
                    case 0: {
                        this.resNums = this.resNums + AminoNet.this.rowDataA.elementAt(i).elementAt(0).toString() + ",";
                        break;
                    }
                    case 1: {
                        this.resNums = this.resNums + AminoNet.this.rowDataB.elementAt(i).elementAt(0).toString() + ",";
                        break;
                    }
                    case 2: {
                        this.resNums = this.resNums + AminoNet.this.rowDataI.elementAt(i).elementAt(0).toString() + ",";
                        break;
                    }
                    case 3: {
                        this.resNums = this.resNums + AminoNet.this.rowDataC.elementAt(i).elementAt(0).toString() + ",";
                    }
                }
                if (n2 % 30 != 0) continue;
                this.resNums = this.resNums + "<br />";
            }
            this.resNums = this.resNums + "</html>";
            this.jlbClu.setToolTipText(this.resNums);
            AminoNet.this.clus[n].addActionListener(this);
            AminoNet.this.clus[n].setActionCommand("clus" + n);
            System.out.println(this.group);
            this.add(this.jcbSel);
            this.add(this.jlbSel);
            this.add(this.jcbN);
            this.add(this.jlbN);
            this.add(this.jcbKav);
            this.add(this.jlbKav);
            this.add(this.jcbSav);
            this.add(this.jlbSav);
            this.add(this.jcbCav);
            this.add(this.jlbCav);
            this.add(this.jcbCwav);
            this.add(this.jlbCwav);
            this.add(this.jcbR);
            this.add(this.jlbR);
            this.add(this.jcbL);
            this.add(this.jlbL);
            this.add(this.jcbLr);
            this.add(this.jlbLr);
            this.add(this.jcbCr);
            this.add(this.jlbCr);
            this.add(this.jcbP);
            this.add(this.jlbP);
            this.add(this.jcbQ);
            this.add(this.jlbQ);
            this.add(this.jcbWijav);
            this.add(this.jlbWijav);
            this.jcbSel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    ValPanel.this.jcbN.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbKav.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbSav.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbCav.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbCwav.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbR.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbP.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbQ.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbL.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbLr.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbCr.setSelected(jCheckBox.isSelected());
                    ValPanel.this.jcbWijav.setSelected(jCheckBox.isSelected());
                }
            });
            this.jcbN.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbN.setText(AminoNet.this.Clu[n][ValPanel.this.group] + "");
                    } else {
                        ValPanel.this.jlbN.setText("");
                    }
                }
            });
            this.jcbKav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbKav.setText(ValPanel.this.df.format((double)AminoNet.this.Ksum[n] * 1.0 / (double)AminoNet.this.Clu[n][ValPanel.this.group]));
                        System.out.println(AminoNet.this.Ksum[n] + " " + AminoNet.this.Clu[n][AminoNet.this.clNo[n][ValPanel.this.group]] + " " + AminoNet.this.clNo[n][ValPanel.this.group]);
                    } else {
                        ValPanel.this.jlbKav.setText("");
                    }
                }
            });
            this.jcbSav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbSav.setText(ValPanel.this.df.format((double)AminoNet.this.Ssum[n] * 1.0 / (double)AminoNet.this.Clu[n][ValPanel.this.group]));
                    } else {
                        ValPanel.this.jlbSav.setText("");
                    }
                }
            });
            this.jcbCav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbCav.setText(ValPanel.this.df.format(AminoNet.this.Csum[n] * 1.0 / (double)AminoNet.this.ccount[n]));
                    } else {
                        ValPanel.this.jlbCav.setText("");
                    }
                }
            });
            this.jcbCwav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbCwav.setText(ValPanel.this.df.format(AminoNet.this.Cwsum[n] * 1.0 / (double)AminoNet.this.ccount[n]));
                    } else {
                        ValPanel.this.jlbCwav.setText("");
                    }
                }
            });
            this.jcbLr.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbLr.setText(ValPanel.this.df.format(Math.log(AminoNet.this.Clu[n][ValPanel.this.group]) / Math.log((double)AminoNet.this.Ksum[n] * 1.0 / (double)AminoNet.this.Clu[n][ValPanel.this.group])));
                    } else {
                        ValPanel.this.jlbLr.setText("");
                    }
                }
            });
            this.jcbCr.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbCr.setText(ValPanel.this.df.format((double)AminoNet.this.Ksum[n] * 1.0 / (double)AminoNet.this.Clu[n][ValPanel.this.group] / (double)AminoNet.this.Clu[n][ValPanel.this.group]));
                    } else {
                        ValPanel.this.jlbCr.setText("");
                    }
                }
            });
            this.jcbP.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbP.setText(ValPanel.this.df.format(AminoNet.this.Csum[n] * 1.0 / (double)AminoNet.this.ccount[n] / ((double)AminoNet.this.Ksum[n] * 1.0 / (double)AminoNet.this.Clu[n][ValPanel.this.group] / (double)AminoNet.this.Clu[n][ValPanel.this.group])));
                    } else {
                        ValPanel.this.jlbP.setText("");
                    }
                }
            });
            this.jcbQ.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbQ.setText(ValPanel.this.df.format((double)AminoNet.this.Lsum[n] * 2.0 / (double)AminoNet.this.Clu[n][ValPanel.this.group] / (double)(AminoNet.this.Clu[n][ValPanel.this.group] - 1) / Math.log(AminoNet.this.Clu[n][ValPanel.this.group]) / Math.log((double)AminoNet.this.Ksum[n] * 1.0 / (double)AminoNet.this.Clu[n][ValPanel.this.group])));
                    } else {
                        ValPanel.this.jlbQ.setText("");
                    }
                }
            });
            this.jcbWijav.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbWijav.setText(ValPanel.this.df.format((double)AminoNet.this.Ssum[n] * 1.0 / (double)AminoNet.this.Ksum[n]));
                    } else {
                        ValPanel.this.jlbWijav.setText("");
                    }
                }
            });
            this.jcbL.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbL.setText(ValPanel.this.df.format((double)AminoNet.this.Lsum[n] * 2.0 / (double)AminoNet.this.Clu[n][ValPanel.this.group] / (double)(AminoNet.this.Clu[n][ValPanel.this.group] - 1)));
                    } else {
                        ValPanel.this.jlbL.setText("");
                    }
                    System.out.println(AminoNet.this.Lsum[n]);
                }
            });
            this.jcbR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        ValPanel.this.jlbR.setText(ValPanel.this.df.format(AminoNet.this.r[n]));
                    } else {
                        ValPanel.this.jlbR.setText("");
                    }
                }
            });
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("clus" + this.n)) {
                System.out.println("Clus " + AminoNet.this.clus[this.n].getSelectedItem());
                this.group = Integer.valueOf(AminoNet.this.clus[this.n].getSelectedItem().toString());
                this.resNums = new String("<html>");
                int n = 0;
                for (int i = 0; i < AminoNet.this.N[this.n]; ++i) {
                    if (AminoNet.this.grABIC[this.n][i] != this.group) continue;
                    ++n;
                    switch (this.n) {
                        case 0: {
                            this.resNums = this.resNums + AminoNet.this.rowDataA.elementAt(i).elementAt(0).toString() + ",";
                            break;
                        }
                        case 1: {
                            this.resNums = this.resNums + AminoNet.this.rowDataB.elementAt(i).elementAt(0).toString() + ",";
                            break;
                        }
                        case 2: {
                            this.resNums = this.resNums + AminoNet.this.rowDataI.elementAt(i).elementAt(0).toString() + ",";
                            break;
                        }
                        case 3: {
                            this.resNums = this.resNums + AminoNet.this.rowDataC.elementAt(i).elementAt(0).toString() + ",";
                        }
                    }
                    if (n % 30 != 0) continue;
                    this.resNums = this.resNums + "<br />";
                }
                this.resNums = this.resNums + "</html>";
                if (AminoNet.this.M[this.n] > 1) {
                    this.jlbClu.setToolTipText(this.resNums);
                    AminoNet.this.calcValues(AminoNet.this.wAdj[this.n], this.n, this.group);
                    this.jcbSel.setSelected(!this.jcbSel.isSelected());
                    this.jcbSel.setSelected(!this.jcbSel.isSelected());
                    this.repaint();
                    AminoNet.this.vhcb[this.n].setSelected(!AminoNet.this.vhcb[this.n].isSelected());
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    class ValuesPanel
    extends JPanel
    implements ItemListener {
        public static final long serialVersionUID = 0L;
        JPanel jva;
        JPanel jvb;
        JPanel jvi;
        JPanel jvc;

        public ValuesPanel() {
            this.jva = new ValPanel(0);
            this.jvb = new ValPanel(1);
            this.jvi = new ValPanel(2);
            this.jvc = new ValPanel(3);
            this.setLayout(new GridLayout(0, 4));
            this.removeAll();
            this.add(this.jva);
            this.add(this.jvb);
            this.add(this.jvi);
            this.add(this.jvc);
            this.jva.setVisible(true);
            this.jvb.setVisible(false);
            this.jvi.setVisible(false);
            this.jvc.setVisible(false);
            AminoNet.this.cb0.addItemListener(this);
            AminoNet.this.cb1.addItemListener(this);
            AminoNet.this.cb2.addItemListener(this);
            AminoNet.this.cb3.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.jva.setVisible(AminoNet.this.cb0.isSelected());
            this.jvb.setVisible(AminoNet.this.cb1.isSelected());
            this.jvi.setVisible(AminoNet.this.cb2.isSelected());
            this.jvc.setVisible(AminoNet.this.cb3.isSelected());
        }
    }

    class ResiduesPanel
    extends JPanel
    implements ItemListener {
        public static final long serialVersionUID = 0L;
        JTable ta;
        JTable tb;
        JTable ti;
        JTable tc;
        JScrollPane spa;
        JScrollPane spb;
        JScrollPane spi;
        JScrollPane spc;

        public ResiduesPanel() {
            this.ta = new JTable(AminoNet.this.rowDataA, AminoNet.this.column_names);
            this.tb = new JTable(AminoNet.this.rowDataB, AminoNet.this.column_names);
            this.ti = new JTable(AminoNet.this.rowDataI, AminoNet.this.column_names);
            this.tc = new JTable(AminoNet.this.rowDataC, AminoNet.this.column_names);
            this.spa = new JScrollPane(this.ta);
            this.spb = new JScrollPane(this.tb);
            this.spi = new JScrollPane(this.ti);
            this.spc = new JScrollPane(this.tc);
            Border border = BorderFactory.createLineBorder(Color.black);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "ALL");
            this.spa.setBorder(titledBorder);
            titledBorder = BorderFactory.createTitledBorder(border, "Phobic");
            this.spb.setBorder(titledBorder);
            titledBorder = BorderFactory.createTitledBorder(border, "Philic");
            this.spi.setBorder(titledBorder);
            titledBorder = BorderFactory.createTitledBorder(border, "Charged");
            this.spc.setBorder(titledBorder);
            this.setLayout(new GridLayout(0, 4));
            this.removeAll();
            this.validate();
            this.add(this.spa);
            this.add(this.spb);
            this.add(this.spi);
            this.add(this.spc);
            this.spa.setVisible(true);
            this.spb.setVisible(false);
            this.spi.setVisible(false);
            this.spc.setVisible(false);
            AminoNet.this.cb0.addItemListener(this);
            AminoNet.this.cb1.addItemListener(this);
            AminoNet.this.cb2.addItemListener(this);
            AminoNet.this.cb3.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.spa.setVisible(AminoNet.this.cb0.isSelected());
            this.spb.setVisible(AminoNet.this.cb1.isSelected());
            this.spi.setVisible(AminoNet.this.cb2.isSelected());
            this.spc.setVisible(AminoNet.this.cb3.isSelected());
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void destroy() {
            System.out.println("Destroy");
            if (this.getComponents() != null) {
                for (int i = 0; i < this.getComponents().length; ++i) {
                    this.getInputContext().removeNotify(this.getComponents()[i]);
                }
            }
            this.getInputContext().removeNotify(this);
        }
    }

    class SelectionPanel
    extends JPanel {
        public static final long serialVersionUID = 0L;
        JLabel ang = new JLabel("\u212b     ");

        public SelectionPanel() {
            this.setLayout(new FlowLayout(4));
            AminoNet.this.cAlpha = new JCheckBox("Only C\u03b1", false);
            AminoNet.this.lsr = new JComboBox();
            AminoNet.this.cb0.setSelected(true);
            AminoNet.this.cb1.setSelected(false);
            AminoNet.this.cb2.setSelected(false);
            AminoNet.this.cb3.setSelected(false);
            this.add(AminoNet.this.cAlpha);
            this.add(AminoNet.this.lsr);
            this.add(AminoNet.this.jFileN);
            this.add(AminoNet.this.jtdist);
            this.add(this.ang);
            this.add(AminoNet.this.cb0);
            this.add(AminoNet.this.cb1);
            this.add(AminoNet.this.cb2);
            this.add(AminoNet.this.cb3);
            AminoNet.this.lsr.setToolTipText("Select the range");
            AminoNet.this.jFileN.setToolTipText("Enter protein name");
            AminoNet.this.jtdist.setToolTipText("Enter the cutoff value");
            AminoNet.this.jtdist.setText(Double.toString(AminoNet.this.LVCD));
        }
    }
}

