/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commons.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrefetchingIterator<T>
implements Iterator<T> {
    private boolean hasFetchedNext;
    private T nextObject;

    @Override
    public boolean hasNext() {
        if (this.hasFetchedNext) {
            return this.getPrefetchedNextOrNull() != null;
        }
        T nextOrNull = this.fetchNextOrNull();
        this.hasFetchedNext = true;
        if (nextOrNull != null) {
            this.setPrefetchedNext(nextOrNull);
        }
        return nextOrNull != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.getPrefetchedNextOrNull();
        this.setPrefetchedNext(null);
        this.hasFetchedNext = false;
        return result;
    }

    protected abstract T fetchNextOrNull();

    protected void setPrefetchedNext(T nextOrNull) {
        this.nextObject = nextOrNull;
    }

    protected T getPrefetchedNextOrNull() {
        return this.nextObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

