/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.net.httpserver.HttpContext;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.transport.http.server.HttpEndpoint;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServicePermission;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object actualEndpoint;
    private final WSBinding binding;
    private final Object implementor;
    private List<Source> metadata;
    private Executor executor;
    private Map<String, Object> properties = Collections.emptyMap();
    private boolean stopped;

    public EndpointImpl(@NotNull BindingID bindingId, @NotNull Object impl) {
        this.binding = BindingImpl.create(bindingId);
        this.implementor = impl;
    }

    public EndpointImpl(WSEndpoint wse, Object serverContext) {
        this.actualEndpoint = new HttpEndpoint(wse, this.executor);
        ((HttpEndpoint)this.actualEndpoint).publish(serverContext);
        this.binding = wse.getBinding();
        this.implementor = null;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public Object getImplementor() {
        return this.implementor;
    }

    @Override
    public void publish(String address) {
        URL url;
        this.canPublish();
        try {
            url = new URL(address);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Cannot create URL for this address " + address);
        }
        if (!url.getProtocol().equals("http")) {
            throw new IllegalArgumentException(url.getProtocol() + " protocol based address is not supported");
        }
        if (!url.getPath().startsWith("/")) {
            throw new IllegalArgumentException("Incorrect WebService address=" + address + ". The address's path should start with /");
        }
        this.createEndpoint();
        ((HttpEndpoint)this.actualEndpoint).publish(address);
    }

    @Override
    public void publish(Object serverContext) {
        this.canPublish();
        if (!HttpContext.class.isAssignableFrom(serverContext.getClass())) {
            throw new IllegalArgumentException(serverContext.getClass() + " is not a supported context.");
        }
        this.createEndpoint();
        ((HttpEndpoint)this.actualEndpoint).publish(serverContext);
    }

    @Override
    public void stop() {
        if (this.isPublished()) {
            ((HttpEndpoint)this.actualEndpoint).stop();
            this.actualEndpoint = null;
            this.stopped = true;
        }
    }

    @Override
    public boolean isPublished() {
        return this.actualEndpoint != null;
    }

    @Override
    public List<Source> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(List<Source> metadata) {
        if (this.isPublished()) {
            throw new IllegalStateException("Cannot set Metadata. Endpoint is already published");
        }
        this.metadata = metadata;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        this.properties = new HashMap<String, Object>(map);
    }

    private void createEndpoint() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ENDPOINT_PUBLISH_PERMISSION);
        }
        try {
            Class.forName("com.sun.net.httpserver.HttpServer");
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Couldn't load light weight http server", e);
        }
        WSEndpoint<?> wse = WSEndpoint.create(this.implementor.getClass(), true, InstanceResolver.createSingleton(this.implementor).createInvoker(), this.getProperty(QName.class, "javax.xml.ws.wsdl.service"), this.getProperty(QName.class, "javax.xml.ws.wsdl.port"), null, this.binding, this.getPrimaryWsdl(), this.buildDocList(), (EntityResolver)null);
        this.actualEndpoint = new HttpEndpoint(wse, this.executor);
    }

    private <T> T getProperty(Class<T> type, String key) {
        Object o = this.properties.get(key);
        if (o == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return type.cast(o);
        }
        throw new IllegalArgumentException("Property " + key + " has to be of type " + type);
    }

    private List<SDDocumentSource> buildDocList() {
        ArrayList<SDDocumentSource> r = new ArrayList<SDDocumentSource>();
        if (this.metadata != null) {
            Transformer transformer = XmlUtil.newTransformer();
            for (Source source : this.metadata) {
                try {
                    XMLStreamBufferResult xsbr = XmlUtil.identityTransform(source, new XMLStreamBufferResult());
                    String systemId = source.getSystemId();
                    r.add(SDDocumentSource.create(new URL(systemId), (XMLStreamBuffer)xsbr.getXMLStreamBuffer()));
                }
                catch (TransformerException te) {
                    throw new ServerRtException("server.rt.err", new Object[]{te});
                }
                catch (IOException te) {
                    throw new ServerRtException("server.rt.err", new Object[]{te});
                }
                catch (SAXException e) {
                    throw new ServerRtException("server.rt.err", new Object[]{e});
                }
                catch (ParserConfigurationException e) {
                    throw new ServerRtException("server.rt.err", new Object[]{e});
                }
            }
        }
        return r;
    }

    @Nullable
    private SDDocumentSource getPrimaryWsdl() {
        Class<?> implType = this.implementor.getClass();
        EndpointFactory.verifyImplementorClass(implType);
        String wsdlLocation = EndpointFactory.getWsdlLocation(implType);
        if (wsdlLocation != null) {
            ClassLoader cl = implType.getClassLoader();
            URL url = cl.getResource(wsdlLocation);
            if (url != null) {
                return SDDocumentSource.create(url);
            }
            throw new ServerRtException("cannot.load.wsdl", wsdlLocation);
        }
        return null;
    }

    private void canPublish() {
        if (this.isPublished()) {
            throw new IllegalStateException("Cannot publish this endpoint. Endpoint has been already published.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Cannot publish this endpoint. Endpoint has been already stopped.");
        }
    }

    @Override
    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        if (!this.isPublished()) {
            throw new WebServiceException("Endpoint is not published yet");
        }
        return ((HttpEndpoint)this.actualEndpoint).getEndpointReference(clazz, referenceParameters);
    }
}

