/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.iiop;

import FIPA.MTS;
import FIPA.MTSHelper;
import jade.mtp.MTPException;
import jade.mtp.TransportAddress;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

class IIOPAddress
implements TransportAddress {
    public static final byte BIG_ENDIAN = 0;
    public static final byte LITTLE_ENDIAN = 1;
    private static final String FIPA_2000_TYPE_ID = "IDL:FIPA/MTS:1.0";
    private static final String NS_TYPE_ID = "IDL:omg.org/CosNaming/NamingContext";
    private static final int TAG_INTERNET_IOP = 0;
    private static final byte IIOP_MAJOR = 1;
    private static final byte IIOP_MINOR = 0;
    private static final byte ASCII_PERCENT = IIOPAddress.getASCIIByte("%");
    private static final byte ASCII_UPPER_A = IIOPAddress.getASCIIByte("A");
    private static final byte ASCII_UPPER_Z = IIOPAddress.getASCIIByte("Z");
    private static final byte ASCII_LOWER_A = IIOPAddress.getASCIIByte("a");
    private static final byte ASCII_LOWER_Z = IIOPAddress.getASCIIByte("z");
    private static final byte ASCII_ZERO = IIOPAddress.getASCIIByte("0");
    private static final byte ASCII_NINE = IIOPAddress.getASCIIByte("9");
    private static final byte ASCII_MINUS = IIOPAddress.getASCIIByte("-");
    private static final byte ASCII_UNDERSCORE = IIOPAddress.getASCIIByte("_");
    private static final byte ASCII_DOT = IIOPAddress.getASCIIByte(".");
    private static final byte ASCII_BANG = IIOPAddress.getASCIIByte("!");
    private static final byte ASCII_TILDE = IIOPAddress.getASCIIByte("~");
    private static final byte ASCII_STAR = IIOPAddress.getASCIIByte("*");
    private static final byte ASCII_QUOTE = IIOPAddress.getASCIIByte("'");
    private static final byte ASCII_OPEN_BRACKET = IIOPAddress.getASCIIByte("(");
    private static final byte ASCII_CLOSED_BRACKET = IIOPAddress.getASCIIByte("$");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final ORB orb;
    private String ior;
    private String host;
    private short port;
    private String objectKey;
    private String anchor;
    private CDRCodec codecStrategy;

    private static final byte getASCIIByte(String ch) {
        try {
            return ch.getBytes("US-ASCII")[0];
        }
        catch (UnsupportedEncodingException uee) {
            return 0;
        }
    }

    public IIOPAddress(ORB anOrb, MTS objRef) throws MTPException {
        this(anOrb, anOrb.object_to_string((Object)objRef));
    }

    public IIOPAddress(ORB anOrb, String s) throws MTPException {
        this.orb = anOrb;
        if (s.toLowerCase().startsWith("ior:")) {
            this.initFromIOR(s);
        } else if (s.toLowerCase().startsWith("corbaloc:")) {
            this.initFromURL(s, (short)0);
        } else if (s.toLowerCase().startsWith("corbaname:")) {
            this.initFromNS(s);
        } else {
            throw new MTPException("Invalid string prefix");
        }
    }

    void initFromIOR(String s) throws MTPException {
        this.parseIOR(s, FIPA_2000_TYPE_ID);
        this.anchor = "";
    }

    private void initFromURL(String s, short endianness) throws MTPException {
        if ((s = s.substring(9)).toLowerCase().startsWith("iiop:")) {
            s = s.substring(5);
        } else if (s.startsWith(":")) {
            s = s.substring(1);
        } else {
            throw new MTPException("Invalid 'corbaloc' URL: neither 'iiop:' nor ':' was specified.");
        }
        this.buildIOR(s, FIPA_2000_TYPE_ID, endianness);
    }

    private void initFromNS(String s) throws MTPException {
        StringBuffer buf = new StringBuffer(s);
        buf.replace(0, 11, "corbaloc::");
        this.buildIOR(s.substring(11), NS_TYPE_ID, (short)0);
        Object o = this.orb.string_to_object(this.ior);
        NamingContext ctx = NamingContextHelper.narrow((Object)o);
        try {
            StringTokenizer lexer = new StringTokenizer(this.anchor, "/.", true);
            ArrayList<NameComponent> name = new ArrayList<NameComponent>();
            while (lexer.hasMoreTokens()) {
                String tok = lexer.nextToken();
                NameComponent nc = new NameComponent();
                nc.id = tok;
                name.add(nc);
                if (!lexer.hasMoreTokens()) break;
                tok = lexer.nextToken();
                if (tok.equals(".")) {
                    nc.kind = tok = lexer.nextToken();
                    continue;
                }
                if (tok.equals("/")) continue;
                throw new MTPException("Ill-formed path into the Naming Service: Unknown separator.");
            }
            NameComponent[] path = name.toArray(new NameComponent[name.size()]);
            o = ctx.resolve(path);
            String realIOR = this.orb.object_to_string(o);
            this.initFromIOR(realIOR);
        }
        catch (NoSuchElementException nsee) {
            throw new MTPException("Ill-formed path into the Naming Service.", (Throwable)nsee);
        }
        catch (UserException ue) {
            throw new MTPException("CORBA Naming Service user exception.", (Throwable)ue);
        }
        catch (SystemException se) {
            throw new MTPException("CORBA Naming Service system exception.", (Throwable)se);
        }
    }

    private void parseIOR(String s, String typeName) throws MTPException {
        try {
            this.ior = new String(s.toUpperCase());
            String hexString = this.ior.substring(4);
            short endianness = Short.parseShort(hexString.substring(0, 2), 16);
            switch (endianness) {
                case 0: {
                    this.codecStrategy = new BigEndianCodec(hexString);
                    break;
                }
                case 1: {
                    this.codecStrategy = new LittleEndianCodec(hexString);
                    break;
                }
                default: {
                    throw new MTPException("Invalid endianness specifier");
                }
            }
            try {
                String typeID = this.codecStrategy.readString();
                if (!typeID.equalsIgnoreCase(typeName)) {
                    throw new MTPException("Invalid type ID" + typeID);
                }
            }
            catch (Exception e) {
                throw new MTPException("Invalid type ID");
            }
            int seqLen = this.codecStrategy.readLong();
            int i = 0;
            while (i < seqLen) {
                int tag = this.codecStrategy.readLong();
                byte[] profile = this.codecStrategy.readOctetSequence();
                if (tag == 0) {
                    CDRCodec profileBodyCodec;
                    switch (profile[0]) {
                        case 0: {
                            profileBodyCodec = new BigEndianCodec(profile);
                            break;
                        }
                        case 1: {
                            profileBodyCodec = new LittleEndianCodec(profile);
                            break;
                        }
                        default: {
                            throw new MTPException("Invalid endianness specifier");
                        }
                    }
                    byte versionMajor = profileBodyCodec.readOctet();
                    byte versionMinor = profileBodyCodec.readOctet();
                    if (versionMajor != 1) {
                        throw new MTPException("IIOP version not supported");
                    }
                    try {
                        this.host = profileBodyCodec.readString();
                    }
                    catch (Exception e) {
                        throw new MTPException("Invalid host string");
                    }
                    this.port = profileBodyCodec.readShort();
                    byte[] keyBuffer = profileBodyCodec.readOctetSequence();
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    int ii = 0;
                    while (ii < keyBuffer.length) {
                        byte b = keyBuffer[ii];
                        if (this.isUnreservedURIChar(b)) {
                            buf.write(b);
                        } else {
                            buf.write(ASCII_PERCENT);
                            buf.write(HEX[(b & 0xF0) >> 4]);
                            buf.write(HEX[b & 0xF]);
                        }
                        ++ii;
                    }
                    this.objectKey = buf.toString("US-ASCII");
                    this.codecStrategy = null;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new MTPException(e.getMessage());
        }
    }

    private void buildIOR(String s, String typeName, short endianness) throws MTPException {
        CDRCodec profileBodyCodec;
        int colonPos = s.indexOf(58);
        int slashPos = s.indexOf(47);
        int poundPos = s.indexOf(35);
        if (colonPos == -1 || slashPos == -1) {
            throw new MTPException("Invalid URL string");
        }
        this.host = new String(s.substring(0, colonPos));
        this.port = Short.parseShort(s.substring(colonPos + 1, slashPos));
        if (poundPos == -1) {
            this.objectKey = new String(s.substring(slashPos + 1, s.length()));
            this.anchor = "";
        } else {
            this.objectKey = new String(s.substring(slashPos + 1, poundPos));
            this.anchor = new String(s.substring(poundPos + 1, s.length()));
        }
        switch (endianness) {
            case 0: {
                this.codecStrategy = new BigEndianCodec(new byte[0]);
                break;
            }
            case 1: {
                this.codecStrategy = new LittleEndianCodec(new byte[0]);
                break;
            }
            default: {
                throw new MTPException("Invalid endianness specifier");
            }
        }
        this.codecStrategy.writeString(typeName);
        this.codecStrategy.writeLong(1);
        this.codecStrategy.writeLong(0);
        switch (endianness) {
            case 0: {
                profileBodyCodec = new BigEndianCodec(new byte[0]);
                break;
            }
            case 1: {
                profileBodyCodec = new LittleEndianCodec(new byte[0]);
                break;
            }
            default: {
                throw new MTPException("Invalid endianness specifier");
            }
        }
        profileBodyCodec.writeOctet((byte)1);
        profileBodyCodec.writeOctet((byte)0);
        profileBodyCodec.writeString(this.host);
        profileBodyCodec.writeShort(this.port);
        try {
            byte[] objKey = this.objectKey.getBytes("US-ASCII");
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            int i = 0;
            while (i < objKey.length) {
                byte b = objKey[i];
                if (b != ASCII_PERCENT) {
                    buf.write(b);
                } else {
                    try {
                        String hexPair = new String(objKey, i + 1, 2, "US-ASCII");
                        short sh = Short.parseShort(hexPair, 16);
                        b = sh > 127 ? (byte)(sh + -256) : (byte)sh;
                    }
                    catch (UnsupportedEncodingException uee) {
                        b = 0;
                    }
                    buf.write(b);
                    i += 2;
                }
                ++i;
            }
            profileBodyCodec.writeOctetSequence(buf.toByteArray());
            byte[] encapsulatedProfile = profileBodyCodec.writtenBytes();
            this.codecStrategy.writeOctetSequence(encapsulatedProfile);
            String hexString = this.codecStrategy.writtenString();
            this.ior = "IOR:" + hexString;
            this.codecStrategy = null;
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
    }

    private boolean isUnreservedURIChar(byte b) {
        if (ASCII_UPPER_A <= b && ASCII_UPPER_Z >= b) {
            return true;
        }
        if (ASCII_LOWER_A <= b && ASCII_LOWER_Z >= b) {
            return true;
        }
        if (ASCII_ZERO <= b && ASCII_NINE >= b) {
            return true;
        }
        return b == ASCII_MINUS || b == ASCII_UNDERSCORE || b == ASCII_DOT || b == ASCII_BANG || b == ASCII_TILDE || b == ASCII_STAR || b == ASCII_QUOTE || b == ASCII_OPEN_BRACKET || b == ASCII_CLOSED_BRACKET;
    }

    public String getURL() {
        int portNum = this.port;
        if (portNum < 0) {
            portNum += 65536;
        }
        return "corbaloc::" + this.host + ":" + portNum + "/" + this.objectKey;
    }

    public String getIOR() {
        return this.ior;
    }

    public MTS getObject() {
        return MTSHelper.narrow(this.orb.string_to_object(this.ior));
    }

    public String getProto() {
        return "iiop";
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return Short.toString(this.port);
    }

    public String getFile() {
        return this.objectKey;
    }

    public String getAnchor() {
        return this.anchor;
    }

    private static class LittleEndianCodec
    extends CDRCodec {
        public LittleEndianCodec(String ior) {
            super(ior);
            this.writeOctet((byte)1);
        }

        public LittleEndianCodec(byte[] hexDigits) {
            super(hexDigits);
            this.writeOctet((byte)1);
        }

        public short readShort() {
            this.setReadAlignment(2);
            short result = (short)(this.readBuffer[this.readIndex++] + (this.readBuffer[this.readIndex++] << 8));
            return result;
        }

        public int readLong() {
            this.setReadAlignment(4);
            int result = this.readBuffer[this.readIndex++] + (this.readBuffer[this.readIndex++] << 8) + (this.readBuffer[this.readIndex++] << 16) + (this.readBuffer[this.readIndex++] << 24);
            return result;
        }

        public long readLongLong() {
            this.setReadAlignment(8);
            long result = this.readBuffer[this.readIndex++] + (this.readBuffer[this.readIndex++] << 8);
            result += (long)((this.readBuffer[this.readIndex++] << 16) + (this.readBuffer[this.readIndex++] << 24));
            result += (long)((this.readBuffer[this.readIndex++] << 32) + (this.readBuffer[this.readIndex++] << 40));
            return result += (long)((this.readBuffer[this.readIndex++] << 48) + (this.readBuffer[this.readIndex++] << 56));
        }

        public void writeShort(short s) {
            this.setWriteAlignment(2);
            this.writeOctet((byte)(s & 0xFF));
            this.writeOctet((byte)((s & 0xFF00) >> 8));
        }

        public void writeLong(int i) {
            this.setWriteAlignment(4);
            this.writeOctet((byte)(i & 0xFF));
            this.writeOctet((byte)((i & 0xFF00) >> 8));
            this.writeOctet((byte)((i & 0xFF0000) >> 16));
            this.writeOctet((byte)((i & 0xFF000000) >> 24));
        }

        public void writeLongLong(long l) {
            this.setWriteAlignment(8);
            this.writeOctet((byte)(l & 0xFFL));
            this.writeOctet((byte)((l & 0xFF00L) >> 8));
            this.writeOctet((byte)((l & 0xFF0000L) >> 16));
            this.writeOctet((byte)((l & 0xFF000000L) >> 24));
            this.writeOctet((byte)((l & 0xFF00000000L) >> 32));
            this.writeOctet((byte)((l & 0xFF0000000000L) >> 40));
            this.writeOctet((byte)((l & 0xFF000000000000L) >> 48));
            this.writeOctet((byte)((l & 0xFF00000000000000L) >> 56));
        }
    }

    private static class BigEndianCodec
    extends CDRCodec {
        public BigEndianCodec(String ior) {
            super(ior);
            this.writeOctet((byte)0);
        }

        public BigEndianCodec(byte[] hexDigits) {
            super(hexDigits);
            this.writeOctet((byte)0);
        }

        public short readShort() {
            this.setReadAlignment(2);
            short result = (short)((this.readBuffer[this.readIndex++] << 8) + this.readBuffer[this.readIndex++]);
            return result;
        }

        public int readLong() {
            this.setReadAlignment(4);
            int result = (this.readBuffer[this.readIndex++] << 24) + (this.readBuffer[this.readIndex++] << 16);
            return result += (this.readBuffer[this.readIndex++] << 8) + this.readBuffer[this.readIndex++];
        }

        public long readLongLong() {
            this.setReadAlignment(8);
            long result = (this.readBuffer[this.readIndex++] << 56) + (this.readBuffer[this.readIndex++] << 48);
            result += (long)((this.readBuffer[this.readIndex++] << 40) + (this.readBuffer[this.readIndex++] << 32));
            result += (long)((this.readBuffer[this.readIndex++] << 24) + (this.readBuffer[this.readIndex++] << 16));
            return result += (long)((this.readBuffer[this.readIndex++] << 8) + this.readBuffer[this.readIndex++]);
        }

        public void writeShort(short s) {
            this.setWriteAlignment(2);
            this.writeOctet((byte)((s & 0xFF00) >> 8));
            this.writeOctet((byte)(s & 0xFF));
        }

        public void writeLong(int i) {
            this.setWriteAlignment(4);
            this.writeOctet((byte)((i & 0xFF000000) >> 24));
            this.writeOctet((byte)((i & 0xFF0000) >> 16));
            this.writeOctet((byte)((i & 0xFF00) >> 8));
            this.writeOctet((byte)(i & 0xFF));
        }

        public void writeLongLong(long l) {
            this.setWriteAlignment(8);
            this.writeOctet((byte)((l & 0xFF00000000000000L) >> 56));
            this.writeOctet((byte)((l & 0xFF000000000000L) >> 48));
            this.writeOctet((byte)((l & 0xFF0000000000L) >> 40));
            this.writeOctet((byte)((l & 0xFF00000000L) >> 32));
            this.writeOctet((byte)((l & 0xFF000000L) >> 24));
            this.writeOctet((byte)((l & 0xFF0000L) >> 16));
            this.writeOctet((byte)((l & 0xFF00L) >> 8));
            this.writeOctet((byte)(l & 0xFFL));
        }
    }

    private static abstract class CDRCodec {
        protected byte[] readBuffer;
        protected StringBuffer writeBuffer;
        protected int readIndex = 0;
        protected int writeIndex = 0;

        protected CDRCodec(String hexString) {
            this.readBuffer = this.bytesFromHexString(hexString);
            this.readIndex = 1;
            this.writeBuffer = new StringBuffer(255);
        }

        protected CDRCodec(byte[] hexDigits) {
            this.readBuffer = new byte[hexDigits.length];
            System.arraycopy(hexDigits, 0, this.readBuffer, 0, this.readBuffer.length);
            this.readIndex = 1;
            this.writeBuffer = new StringBuffer(255);
        }

        public String writtenString() {
            return new String(this.writeBuffer);
        }

        public byte[] writtenBytes() {
            return this.bytesFromHexString(new String(this.writeBuffer));
        }

        public byte readOctet() {
            return this.readBuffer[this.readIndex++];
        }

        public byte[] readOctetSequence() {
            int seqLen = this.readLong();
            byte[] result = new byte[seqLen];
            System.arraycopy(this.readBuffer, this.readIndex, result, 0, seqLen);
            this.readIndex += seqLen;
            return result;
        }

        public String readString() {
            int strLen = this.readLong();
            String result = new String(this.readBuffer, this.readIndex, strLen - 1);
            this.readIndex += strLen;
            return result;
        }

        public abstract short readShort();

        public abstract int readLong();

        public abstract long readLongLong();

        public void writeOctet(byte b) {
            char[] digits = new char[]{HEX[(b & 0xF0) >> 4], HEX[b & 0xF]};
            this.writeBuffer.append(digits);
            ++this.writeIndex;
        }

        public void writeOctetSequence(byte[] seq) {
            int seqLen = seq.length;
            this.writeLong(seqLen);
            int i = 0;
            while (i < seqLen) {
                this.writeOctet(seq[i]);
                ++i;
            }
        }

        public void writeString(String s) {
            int strLen = s.length() + 1;
            this.writeLong(strLen);
            byte[] bytes = s.getBytes();
            int i = 0;
            while (i < s.length()) {
                this.writeOctet(bytes[i]);
                ++i;
            }
            this.writeOctet((byte)0);
        }

        public abstract void writeShort(short var1);

        public abstract void writeLong(int var1);

        public abstract void writeLongLong(long var1);

        protected void setReadAlignment(int align) {
            while (this.readIndex % align != 0) {
                ++this.readIndex;
            }
        }

        protected void setWriteAlignment(int align) {
            while (this.writeIndex % align != 0) {
                this.writeOctet((byte)0);
            }
        }

        private byte[] bytesFromHexString(String hexString) {
            int hexLen = hexString.length() / 2;
            byte[] result = new byte[hexLen];
            int i = 0;
            while (i < hexLen) {
                String currentDigit = hexString.substring(2 * i, 2 * (i + 1));
                Short s = Short.valueOf(currentDigit, 16);
                result[i] = s.byteValue();
                ++i;
            }
            return result;
        }
    }
}

