/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.remote.BasicClientConfigurator;
import org.neo4j.remote.BasicGraphDatabaseServer;
import org.neo4j.remote.BasicServerTransaction;
import org.neo4j.remote.ClientConfigurator;
import org.neo4j.remote.Configuration;
import org.neo4j.remote.IterableSpecification;
import org.neo4j.remote.NodeSpecification;
import org.neo4j.remote.RelationshipSpecification;
import org.neo4j.remote.RemoteConnection;
import org.neo4j.remote.RemoteResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BasicConnection
implements RemoteConnection {
    private final AtomicInteger txIdPool = new AtomicInteger();
    private final BasicGraphDatabaseServer server;
    final GraphDatabaseService neo;
    private final Map<Integer, BasicServerTransaction> transactions = new ConcurrentHashMap<Integer, BasicServerTransaction>();
    private transient boolean open = true;

    BasicConnection(BasicGraphDatabaseServer server, GraphDatabaseService neo) {
        this.server = server;
        this.neo = neo;
    }

    int allocateTransactionId() {
        return this.txIdPool.incrementAndGet();
    }

    private void checkOpen() {
        if (!this.open) {
            throw new RuntimeException("TODO: better exception. Connection is not open.");
        }
    }

    private BasicServerTransaction transaction(int transactionId) {
        this.checkOpen();
        BasicServerTransaction tx = this.transactions.get(transactionId);
        if (tx == null) {
            throw new RuntimeException("TODO: better exception. No such transaction.");
        }
        return tx;
    }

    RemoteResponse.ResponseBuilder response() {
        RemoteResponse.ResponseBuilder builder = new RemoteResponse.ResponseBuilder();
        this.server.buildResponse(this.neo, builder);
        return builder;
    }

    @Override
    public ClientConfigurator configure(Configuration config) {
        return new BasicClientConfigurator(config);
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            for (BasicServerTransaction tx : this.transactions.values()) {
                this.transactions.remove(tx.id);
                tx.rollback();
            }
        }
    }

    @Override
    public int beginTransaction() {
        this.checkOpen();
        BasicServerTransaction tx = this.server.beginTransaction(this);
        this.transactions.put(tx.id, tx);
        return tx.id;
    }

    @Override
    public void commit(int transactionId) {
        BasicServerTransaction tx = this.transaction(transactionId);
        this.transactions.remove(tx.id);
        tx.commit();
    }

    @Override
    public void rollback(int transactionId) {
        BasicServerTransaction tx = this.transaction(transactionId);
        this.transactions.remove(tx.id);
        tx.rollback();
    }

    @Override
    public RemoteResponse<NodeSpecification> createNode(int transactionId) {
        return this.transaction(transactionId).createNode();
    }

    @Override
    public RemoteResponse<Boolean> hasNodeWithId(int transactionId, long nodeId) {
        return this.transaction(transactionId).hasNodeWithId(nodeId);
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getAllNodes(int transactionId) {
        return this.transaction(transactionId).getAllNodes();
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getMoreNodes(int transactionId, int requestToken) {
        return this.transaction(transactionId).getMoreNodes(requestToken);
    }

    @Override
    public RemoteResponse<Void> closeNodeIterator(int transactionId, int requestToken) {
        return this.transaction(transactionId).closeNodeIterator(requestToken);
    }

    @Override
    public RemoteResponse<RelationshipSpecification> createRelationship(int transactionId, String relationshipTypeName, long startNodeId, long endNodeId) {
        return this.transaction(transactionId).createRelationship(relationshipTypeName, startNodeId, endNodeId);
    }

    @Override
    public RemoteResponse<RelationshipSpecification> getRelationshipById(int transactionId, long relationshipId) {
        return this.transaction(transactionId).getRelationshipById(relationshipId);
    }

    @Override
    public RemoteResponse<Void> deleteNode(int transactionId, long nodeId) {
        return this.transaction(transactionId).deleteNode(nodeId);
    }

    @Override
    public RemoteResponse<Void> deleteRelationship(int transactionId, long relationshipId) {
        return this.transaction(transactionId).deleteRelationship(relationshipId);
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getAllRelationships(int transactionId, long nodeId, Direction direction) {
        return this.transaction(transactionId).getAllRelationships(nodeId, direction);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getMorePropertyKeys(int transactionId, int requestToken) {
        return this.transaction(transactionId).getMorePropertyKeys(requestToken);
    }

    @Override
    public RemoteResponse<Void> closePropertyKeyIterator(int transactionId, int requestToken) {
        return this.transaction(transactionId).closePropertyKeyIterator(requestToken);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getMoreRelationshipTypes(int transactionId, int requestToken) {
        return this.transaction(transactionId).getMoreRelationshipTypes(requestToken);
    }

    @Override
    public RemoteResponse<Void> closeRelationshipTypeIterator(int transactionId, int requestToken) {
        return this.transaction(transactionId).closeRelationshipTypeIterator(requestToken);
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getMoreRelationships(int transactionId, int requestToken) {
        return this.transaction(transactionId).getMoreRelationships(requestToken);
    }

    @Override
    public RemoteResponse<Void> closeRelationshipIterator(int transactionId, int requestToken) {
        return this.transaction(transactionId).closeRelationshipIterator(requestToken);
    }

    @Override
    public RemoteResponse<Object> getNodeProperty(int transactionId, long nodeId, String key) {
        return this.transaction(transactionId).getNodeProperty(nodeId, key);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getNodePropertyKeys(int transactionId, long nodeId) {
        return this.transaction(transactionId).getNodePropertyKeys(nodeId);
    }

    @Override
    public RemoteResponse<NodeSpecification> getReferenceNode(int transactionId) {
        return this.transaction(transactionId).getReferenceNode();
    }

    @Override
    public RemoteResponse<Object> getRelationshipProperty(int transactionId, long relationshipId, String key) {
        return this.transaction(transactionId).getRelationshipProperty(relationshipId, key);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getRelationshipPropertyKeys(int transactionId, long relationshipId) {
        return this.transaction(transactionId).getRelationshipPropertyKeys(relationshipId);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getRelationshipTypes(int transactionId) {
        return this.transaction(transactionId).getRelationshipTypes();
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getRelationships(int transactionId, long nodeId, Direction direction, String[] relationshipTypeNames) {
        return this.transaction(transactionId).getRelationships(nodeId, direction, relationshipTypeNames);
    }

    @Override
    public RemoteResponse<Boolean> hasNodeProperty(int transactionId, long nodeId, String key) {
        return this.transaction(transactionId).hasNodeProperty(nodeId, key);
    }

    @Override
    public RemoteResponse<Boolean> hasRelationshipProperty(int transactionId, long relationshiId, String key) {
        return this.transaction(transactionId).hasRelationshipProperty(relationshiId, key);
    }

    @Override
    public RemoteResponse<Object> removeNodeProperty(int transactionId, long nodeId, String key) {
        return this.transaction(transactionId).removeNodeProperty(nodeId, key);
    }

    @Override
    public RemoteResponse<Object> removeRelationshipProperty(int transactionId, long relationshipId, String key) {
        return this.transaction(transactionId).removeRelationshipProperty(relationshipId, key);
    }

    @Override
    public RemoteResponse<Object> setNodeProperty(int transactionId, long nodeId, String key, Object value) {
        return this.transaction(transactionId).setNodeProperty(nodeId, key, value);
    }

    @Override
    public RemoteResponse<Object> setRelationshipProperty(int transactionId, long relationshipId, String key, Object value) {
        return this.transaction(transactionId).setRelationshipProperty(relationshipId, key, value);
    }

    @Override
    public RemoteResponse<Integer> getIndexServiceId(String indexName) {
        int id;
        try {
            id = this.server.getIndexId(indexName);
        }
        catch (Exception ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildIntegerResponse(id);
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getIndexNodes(int transactionId, int indexId, String key, Object value) {
        return this.transaction(transactionId).getIndexNodes(indexId, key, value);
    }

    @Override
    public RemoteResponse<Void> indexNode(int transactionId, int indexId, long nodeId, String key, Object value) {
        return this.transaction(transactionId).indexNode(indexId, nodeId, key, value);
    }

    @Override
    public RemoteResponse<Void> removeIndexNode(int transactionId, int indexId, long nodeId, String key, Object value) {
        return this.transaction(transactionId).removeIndexNode(indexId, nodeId, key, value);
    }
}

