/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.index.IndexHits;
import org.neo4j.index.IndexService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.remote.BasicConnection;
import org.neo4j.remote.BasicServerTransaction;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.NodeSpecification;
import org.neo4j.remote.RelType;
import org.neo4j.remote.RelationshipSpecification;
import org.neo4j.remote.RemoteConnection;
import org.neo4j.remote.RemoteResponse;
import org.neo4j.remote.ResponseVisitor;
import org.neo4j.remote.SimpleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicGraphDatabaseServer
implements ConnectionTarget {
    private static final int DEFAULT_BATCH_SIZE = 10;
    private final TransactionManager txManager;
    private IndexSpec[] indexes = new IndexSpec[0];

    protected BasicGraphDatabaseServer(TransactionManager txManager) {
        if (txManager == null) {
            throw new NullPointerException("No transaction manager was supplied.");
        }
        this.txManager = txManager;
    }

    protected abstract GraphDatabaseService connectGraphDatabase();

    protected abstract GraphDatabaseService connectGraphDatabase(String var1, String var2);

    protected int getNodesBatchSize(int returned) {
        return 10;
    }

    int nodesBatchSize(int returned) {
        int result;
        try {
            result = this.getNodesBatchSize(returned);
        }
        catch (Exception ex) {
            result = 10;
        }
        return result < 1 ? 1 : result;
    }

    protected int getTypesBatchSize(int returned) {
        return 10;
    }

    final int typesBatchSize(int returned) {
        int result;
        try {
            result = this.getTypesBatchSize(returned);
        }
        catch (Exception ex) {
            result = 10;
        }
        return result < 1 ? 1 : result;
    }

    protected int getRelationshipsBatchSize(int returned) {
        return 10;
    }

    final int relationshipsBatchSize(int returned) {
        int result;
        try {
            result = this.getRelationshipsBatchSize(returned);
        }
        catch (Exception ex) {
            result = 10;
        }
        return result < 1 ? 1 : result;
    }

    protected int getKeysBatchSize(int returned) {
        return 10;
    }

    final int keysBatchSize(int returned) {
        int result;
        try {
            result = this.getKeysBatchSize(returned);
        }
        catch (Exception ex) {
            result = 10;
        }
        return result < 1 ? 1 : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndexService(String name, IndexService index) {
        BasicGraphDatabaseServer basicGraphDatabaseServer = this;
        synchronized (basicGraphDatabaseServer) {
            IndexSpec[] new_indexes = new IndexSpec[this.indexes.length + 1];
            for (int i = 0; i < this.indexes.length; ++i) {
                if (this.indexes[i].name.equals(name)) {
                    throw new IllegalArgumentException("IndexService \"" + name + "\" is already registered.");
                }
                new_indexes[i] = this.indexes[i];
            }
            new_indexes[this.indexes.length] = new IndexSpec(name, index);
            this.indexes = new_indexes;
        }
    }

    void buildResponse(GraphDatabaseService neo, RemoteResponse.ResponseBuilder builder) {
    }

    void buildResponse(GraphDatabaseService neo, Object transactionId, ResponseVisitor responseState) {
    }

    @Override
    public final RemoteConnection connect() {
        return new BasicConnection(this, this.connectGraphDatabase());
    }

    @Override
    public RemoteConnection connect(String username, String password) {
        return new BasicConnection(this, this.connectGraphDatabase(username, password));
    }

    private void suspendTransaction() {
        try {
            if (this.txManager.getTransaction() != null) {
                this.txManager.suspend();
            }
        }
        catch (SystemException ex) {
            throw new RuntimeException("TODO: better exception. SystemException in tx suspend.", ex);
        }
    }

    void resumeTransaction(Transaction transaction) {
        this.suspendTransaction();
        try {
            this.txManager.resume(transaction);
        }
        catch (InvalidTransactionException ex) {
            throw new RuntimeException("TODO: better exception. InvalidTransactionException in tx resume.", ex);
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException("TODO: better exception. IllegalStateException in tx resume.", ex);
        }
        catch (SystemException ex) {
            throw new RuntimeException("TODO: better exception. SystemException in tx resume.", ex);
        }
    }

    BasicServerTransaction beginTransaction(BasicConnection connection) {
        Transaction tx;
        this.suspendTransaction();
        try {
            this.txManager.begin();
            tx = this.txManager.getTransaction();
        }
        catch (SystemException ex) {
            throw new RuntimeException("TODO: better exception. SystemException in tx begin.", ex);
        }
        catch (NotSupportedException ex) {
            throw new RuntimeException("TODO: better exceptio. txManager.begin() not supported.", ex);
        }
        return new BasicServerTransaction(this, connection, tx);
    }

    SimpleIterator<String> getRelationshipTypes(GraphDatabaseService neo) {
        if (!(neo instanceof EmbeddedGraphDatabase)) {
            throw new UnsupportedOperationException("Cannot get the relationship types from this graph database server.");
        }
        final Iterator types = ((EmbeddedGraphDatabase)neo).getRelationshipTypes().iterator();
        return new SimpleIterator<String>(){

            @Override
            boolean hasNext() {
                return types.hasNext();
            }

            @Override
            String getNext() {
                return ((RelationshipType)types.next()).name();
            }
        };
    }

    long createNode(GraphDatabaseService neo) {
        return neo.createNode().getId();
    }

    long getReferenceNode(GraphDatabaseService neo) {
        return neo.getReferenceNode().getId();
    }

    SimpleIterator<NodeSpecification> getAllNodes(GraphDatabaseService neo) {
        final Iterator nodes = neo.getAllNodes().iterator();
        return new SimpleIterator<NodeSpecification>(){

            @Override
            boolean hasNext() {
                return nodes.hasNext();
            }

            @Override
            NodeSpecification getNext() {
                return new NodeSpecification(((Node)nodes.next()).getId());
            }
        };
    }

    boolean hasNodeWithId(GraphDatabaseService neo, long nodeId) {
        Node node = null;
        try {
            node = neo.getNodeById(nodeId);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return node != null;
    }

    void deleteNode(GraphDatabaseService neo, long nodeId) {
        neo.getNodeById(nodeId).delete();
    }

    long createRelationship(GraphDatabaseService neo, String relationshipTypeName, long startNodeId, long endNodeId) {
        return neo.getNodeById(startNodeId).createRelationshipTo(neo.getNodeById(endNodeId), (RelationshipType)new RelType(relationshipTypeName)).getId();
    }

    RelationshipSpecification getRelationshipById(GraphDatabaseService neo, long relationshipId) {
        return new RelationshipSpecification(neo.getRelationshipById(relationshipId));
    }

    SimpleIterator<RelationshipSpecification> getAllRelationships(GraphDatabaseService neo, long nodeId, Direction direction) {
        final Iterator relationships = neo.getNodeById(nodeId).getRelationships(direction).iterator();
        return new SimpleIterator<RelationshipSpecification>(){

            @Override
            boolean hasNext() {
                return relationships.hasNext();
            }

            @Override
            RelationshipSpecification getNext() {
                return new RelationshipSpecification((Relationship)relationships.next());
            }
        };
    }

    SimpleIterator<RelationshipSpecification> getRelationships(GraphDatabaseService neo, final long nodeId, final Direction direction, String[] relationshipTypeNames) {
        RelationshipType[] types = new RelationshipType[relationshipTypeNames.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = new RelType(relationshipTypeNames[i]);
        }
        final Iterator relationships = neo.getNodeById(nodeId).getRelationships(types).iterator();
        return new SimpleIterator<RelationshipSpecification>(){
            Relationship next = null;

            @Override
            boolean hasNext() {
                block5: while (this.next == null && relationships.hasNext()) {
                    Relationship candidate = (Relationship)relationships.next();
                    switch (direction) {
                        case OUTGOING: {
                            if (candidate.getStartNode().getId() != nodeId) continue block5;
                            this.next = candidate;
                            return true;
                        }
                        case INCOMING: {
                            if (candidate.getEndNode().getId() != nodeId) continue block5;
                            this.next = candidate;
                            return true;
                        }
                        case BOTH: {
                            this.next = candidate;
                            return true;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            RelationshipSpecification getNext() {
                try {
                    RelationshipSpecification relationshipSpecification = new RelationshipSpecification(this.next);
                    return relationshipSpecification;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }

    void deleteRelationship(GraphDatabaseService neo, long relationshipId) {
        neo.getRelationshipById(relationshipId).delete();
    }

    Object getNodeProperty(GraphDatabaseService neo, long nodeId, String key) {
        return neo.getNodeById(nodeId).getProperty(key, null);
    }

    Object getRelationshipProperty(GraphDatabaseService neo, long relationshipId, String key) {
        return neo.getRelationshipById(relationshipId).getProperty(key, null);
    }

    Object setNodeProperty(GraphDatabaseService neo, long nodeId, String key, Object value) {
        neo.getNodeById(nodeId).setProperty(key, value);
        return null;
    }

    Object setRelationshipProperty(GraphDatabaseService neo, long relationshipId, String key, Object value) {
        neo.getRelationshipById(relationshipId).setProperty(key, value);
        return null;
    }

    SimpleIterator<String> getNodePropertyKeys(GraphDatabaseService neo, long nodeId) {
        final Iterator keys = neo.getNodeById(nodeId).getPropertyKeys().iterator();
        return new SimpleIterator<String>(){

            @Override
            boolean hasNext() {
                return keys.hasNext();
            }

            @Override
            String getNext() {
                return (String)keys.next();
            }
        };
    }

    SimpleIterator<String> getRelationshipPropertyKeys(GraphDatabaseService neo, long relationshipId) {
        final Iterator keys = neo.getRelationshipById(relationshipId).getPropertyKeys().iterator();
        return new SimpleIterator<String>(){

            @Override
            boolean hasNext() {
                return keys.hasNext();
            }

            @Override
            String getNext() {
                return (String)keys.next();
            }
        };
    }

    boolean hasNodeProperty(GraphDatabaseService neo, long nodeId, String key) {
        return neo.getNodeById(nodeId).hasProperty(key);
    }

    boolean hasRelationshipProperty(GraphDatabaseService neo, long relationshiId, String key) {
        return neo.getRelationshipById(relationshiId).hasProperty(key);
    }

    Object removeNodeProperty(GraphDatabaseService neo, long nodeId, String key) {
        return neo.getNodeById(nodeId).removeProperty(key);
    }

    Object removeRelationshipProperty(GraphDatabaseService neo, long relationshipId, String key) {
        return neo.getRelationshipById(relationshipId).removeProperty(key);
    }

    int getIndexId(String indexName) {
        IndexSpec[] indexes = this.indexes;
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexes[i].name.equals(indexName)) continue;
            return i;
        }
        throw new NoSuchElementException("No index with the name \"" + indexName + "\" registered.");
    }

    SimpleIterator<NodeSpecification> getIndexNodes(GraphDatabaseService neo, int indexId, String key, Object value) {
        final IndexHits nodes = this.indexes[indexId].index.getNodes(key, value);
        return new SimpleIterator<NodeSpecification>(nodes.size()){
            Iterator<Node> iter;
            {
                super(x0);
                this.iter = nodes.iterator();
            }

            @Override
            NodeSpecification getNext() {
                return new NodeSpecification(this.iter.next().getId());
            }

            @Override
            boolean hasNext() {
                return this.iter.hasNext();
            }
        };
    }

    void indexNode(GraphDatabaseService neo, int indexId, long nodeId, String key, Object value) {
        this.indexes[indexId].index.index(neo.getNodeById(nodeId), key, value);
    }

    void removeIndexNode(GraphDatabaseService neo, int indexId, long nodeId, String key, Object value) {
        this.indexes[indexId].index.removeIndex(neo.getNodeById(nodeId), key, value);
    }

    public long getTotalNumberOfNodes(GraphDatabaseService neo) {
        if (neo instanceof EmbeddedGraphDatabase) {
            EmbeddedGraphDatabase embedded = (EmbeddedGraphDatabase)neo;
            return embedded.getConfig().getNeoModule().getNodeManager().getNumberOfIdsInUse(Node.class);
        }
        return -1L;
    }

    private static class IndexSpec {
        final String name;
        final IndexService index;

        IndexSpec(String name, IndexService index) {
            this.name = name;
            this.index = index;
        }
    }
}

