/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.graphdb.Direction;
import org.neo4j.remote.BasicConnection;
import org.neo4j.remote.BasicGraphDatabaseServer;
import org.neo4j.remote.IterableSpecification;
import org.neo4j.remote.NodeSpecification;
import org.neo4j.remote.RelationshipSpecification;
import org.neo4j.remote.RemoteResponse;
import org.neo4j.remote.SimpleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BasicServerTransaction {
    private final BasicGraphDatabaseServer server;
    private final Transaction transaction;
    private final BasicConnection connection;
    final Integer id;
    private int nodTokenPool = 0;
    private int relTokenPool = 0;
    private int strTokenPool = 0;
    private final Map<Integer, SimpleIterator<RelationshipSpecification>> relIter = new HashMap<Integer, SimpleIterator<RelationshipSpecification>>();
    private final Map<Integer, SimpleIterator<NodeSpecification>> nodIter = new HashMap<Integer, SimpleIterator<NodeSpecification>>();
    private final Map<Integer, SimpleIterator<String>> strIter = new HashMap<Integer, SimpleIterator<String>>();

    BasicServerTransaction(BasicGraphDatabaseServer server, BasicConnection connection, Transaction transaction) {
        this.server = server;
        this.connection = connection;
        this.transaction = transaction;
        this.id = connection.allocateTransactionId();
    }

    private void resume() {
        this.server.resumeTransaction(this.transaction);
    }

    void commit() {
        this.resume();
        try {
            this.transaction.commit();
        }
        catch (IllegalStateException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (RollbackException ex) {
        }
        catch (HeuristicMixedException ex) {
        }
        catch (HeuristicRollbackException ex) {
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    void rollback() {
        this.resume();
        try {
            this.transaction.rollback();
        }
        catch (IllegalStateException ex) {
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    private RemoteResponse.ResponseBuilder response() {
        RemoteResponse.ResponseBuilder builder = this.connection.response();
        this.server.buildResponse(this.connection.neo, this.id, builder);
        return builder;
    }

    private SimpleIterator<NodeSpecification> getNodes(int token) {
        return this.nodIter.remove(token);
    }

    private RemoteResponse<IterableSpecification<NodeSpecification>> nodes(int token, long size, SimpleIterator<NodeSpecification> iterator) {
        NodeSpecification[] result = BasicServerTransaction.consume(token, this.nodIter, iterator, this.server.nodesBatchSize(iterator.count())).toArray(new NodeSpecification[0]);
        if (iterator.hasNext()) {
            return this.response().buildPartialNodeResponse(token, size, result);
        }
        return this.response().buildFinalNodeResponse(size, result);
    }

    private SimpleIterator<RelationshipSpecification> getRelationships(int token) {
        return this.relIter.remove(token);
    }

    private RemoteResponse<IterableSpecification<RelationshipSpecification>> relationships(int token, SimpleIterator<RelationshipSpecification> iterator) {
        RelationshipSpecification[] result = BasicServerTransaction.consume(token, this.relIter, iterator, this.server.relationshipsBatchSize(iterator.count())).toArray(new RelationshipSpecification[0]);
        if (iterator.hasNext()) {
            return this.response().buildPartialRelationshipResponse(token, result);
        }
        return this.response().buildFinalRelationshipResponse(result);
    }

    private SimpleIterator<String> getStrings(int token) {
        return this.strIter.remove(token);
    }

    private RemoteResponse<IterableSpecification<String>> strings(int token, SimpleIterator<String> iterator, int batchSize) {
        String[] result = BasicServerTransaction.consume(token, this.strIter, iterator, batchSize).toArray(new String[0]);
        if (iterator.hasNext()) {
            return this.response().buildPartialStringResponse(token, result);
        }
        return this.response().buildFinalStringResponse(result);
    }

    private RemoteResponse<IterableSpecification<String>> types(int token, SimpleIterator<String> iterator) {
        return this.strings(token, iterator, this.server.typesBatchSize(iterator.count()));
    }

    private RemoteResponse<IterableSpecification<String>> keys(int token, SimpleIterator<String> iterator) {
        return this.strings(token, iterator, this.server.keysBatchSize(iterator.count()));
    }

    private static <E> List<E> consume(int token, Map<Integer, SimpleIterator<E>> map, SimpleIterator<E> iterator, int batchSize) {
        ArrayList<E> result = new ArrayList<E>(batchSize);
        for (int size = 0; iterator.hasNext() && size < batchSize; ++size) {
            result.add(iterator.next());
        }
        if (iterator.hasNext()) {
            map.put(token, iterator);
        }
        return result;
    }

    RemoteResponse<NodeSpecification> createNode() {
        long id;
        this.resume();
        try {
            id = this.server.createNode(this.connection.neo);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildNodeResponse(id);
    }

    RemoteResponse<Boolean> hasNodeWithId(long nodeId) {
        boolean value;
        this.resume();
        try {
            value = this.server.hasNodeWithId(this.connection.neo, nodeId);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildBooleanResponse(value);
    }

    RemoteResponse<RelationshipSpecification> createRelationship(String relationshipTypeName, long startNodeId, long endNodeId) {
        long id;
        this.resume();
        try {
            id = this.server.createRelationship(this.connection.neo, relationshipTypeName, startNodeId, endNodeId);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildRelationshipResponse(id, relationshipTypeName, startNodeId, endNodeId);
    }

    RemoteResponse<RelationshipSpecification> getRelationshipById(long relationshipId) {
        RelationshipSpecification spec;
        this.resume();
        try {
            spec = this.server.getRelationshipById(this.connection.neo, relationshipId);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildRelationshipResponse(spec.relationshipId, spec.name, spec.startNodeId, spec.endNodeId);
    }

    RemoteResponse<Void> deleteNode(long nodeId) {
        this.resume();
        try {
            this.server.deleteNode(this.connection.neo, nodeId);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildVoidResponse();
    }

    RemoteResponse<IterableSpecification<NodeSpecification>> getAllNodes() {
        SimpleIterator<NodeSpecification> iterator;
        long size;
        this.resume();
        try {
            size = this.server.getTotalNumberOfNodes(this.connection.neo);
            iterator = this.server.getAllNodes(this.connection.neo);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.nodes(this.nodTokenPool++, size, iterator);
    }

    RemoteResponse<Void> deleteRelationship(long relationshipId) {
        this.resume();
        try {
            this.server.deleteRelationship(this.connection.neo, relationshipId);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildVoidResponse();
    }

    RemoteResponse<IterableSpecification<RelationshipSpecification>> getAllRelationships(long nodeId, Direction direction) {
        SimpleIterator<RelationshipSpecification> iterator;
        this.resume();
        try {
            iterator = this.server.getAllRelationships(this.connection.neo, nodeId, direction);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.relationships(this.relTokenPool++, iterator);
    }

    RemoteResponse<IterableSpecification<RelationshipSpecification>> getMoreRelationships(int requestToken) {
        SimpleIterator<RelationshipSpecification> relationships;
        this.resume();
        try {
            relationships = this.getRelationships(requestToken);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.relationships(requestToken, relationships);
    }

    RemoteResponse<Void> closeRelationshipIterator(int requestToken) {
        try {
            this.getRelationships(requestToken);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildVoidResponse();
    }

    RemoteResponse<IterableSpecification<NodeSpecification>> getMoreNodes(int requestToken) {
        SimpleIterator<NodeSpecification> nodes;
        this.resume();
        try {
            nodes = this.getNodes(requestToken);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.nodes(requestToken, -1L, nodes);
    }

    RemoteResponse<Void> closeNodeIterator(int requestToken) {
        try {
            this.getNodes(requestToken);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildVoidResponse();
    }

    RemoteResponse<IterableSpecification<String>> getMorePropertyKeys(int requestToken) {
        SimpleIterator<String> strings;
        this.resume();
        try {
            strings = this.getStrings(requestToken);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.keys(requestToken, strings);
    }

    RemoteResponse<Void> closePropertyKeyIterator(int requestToken) {
        try {
            this.getStrings(requestToken);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildVoidResponse();
    }

    RemoteResponse<IterableSpecification<String>> getMoreRelationshipTypes(int requestToken) {
        SimpleIterator<String> strings;
        this.resume();
        try {
            strings = this.getStrings(requestToken);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.types(requestToken, strings);
    }

    RemoteResponse<Void> closeRelationshipTypeIterator(int requestToken) {
        try {
            this.getStrings(requestToken);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildVoidResponse();
    }

    RemoteResponse<Object> getNodeProperty(long nodeId, String key) {
        Object value;
        this.resume();
        try {
            value = this.server.getNodeProperty(this.connection.neo, nodeId, key);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildPropertyResponse(value);
    }

    RemoteResponse<IterableSpecification<String>> getNodePropertyKeys(long nodeId) {
        SimpleIterator<String> strings;
        this.resume();
        try {
            strings = this.server.getNodePropertyKeys(this.connection.neo, nodeId);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.keys(this.strTokenPool++, strings);
    }

    RemoteResponse<NodeSpecification> getReferenceNode() {
        long id;
        this.resume();
        try {
            id = this.server.getReferenceNode(this.connection.neo);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildNodeResponse(id);
    }

    RemoteResponse<Object> getRelationshipProperty(long relationshipId, String key) {
        Object value;
        this.resume();
        try {
            value = this.server.getRelationshipProperty(this.connection.neo, relationshipId, key);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildPropertyResponse(value);
    }

    RemoteResponse<IterableSpecification<String>> getRelationshipPropertyKeys(long relationshipId) {
        SimpleIterator<String> strings;
        this.resume();
        try {
            strings = this.server.getRelationshipPropertyKeys(this.connection.neo, relationshipId);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.keys(this.strTokenPool++, strings);
    }

    RemoteResponse<IterableSpecification<String>> getRelationshipTypes() {
        SimpleIterator<String> strings;
        this.resume();
        try {
            strings = this.server.getRelationshipTypes(this.connection.neo);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.types(this.strTokenPool++, strings);
    }

    RemoteResponse<IterableSpecification<RelationshipSpecification>> getRelationships(long nodeId, Direction direction, String[] relationshipTypeNames) {
        SimpleIterator<RelationshipSpecification> relationships;
        this.resume();
        try {
            relationships = this.server.getRelationships(this.connection.neo, nodeId, direction, relationshipTypeNames);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.relationships(this.relTokenPool++, relationships);
    }

    RemoteResponse<Boolean> hasNodeProperty(long nodeId, String key) {
        boolean value;
        this.resume();
        try {
            value = this.server.hasNodeProperty(this.connection.neo, nodeId, key);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildBooleanResponse(value);
    }

    RemoteResponse<Boolean> hasRelationshipProperty(long relationshiId, String key) {
        boolean value;
        this.resume();
        try {
            value = this.server.hasRelationshipProperty(this.connection.neo, relationshiId, key);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildBooleanResponse(value);
    }

    RemoteResponse<Object> removeNodeProperty(long nodeId, String key) {
        Object value;
        this.resume();
        try {
            value = this.server.removeNodeProperty(this.connection.neo, nodeId, key);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildPropertyResponse(value);
    }

    RemoteResponse<Object> removeRelationshipProperty(long relationshipId, String key) {
        Object value;
        this.resume();
        try {
            value = this.server.removeRelationshipProperty(this.connection.neo, relationshipId, key);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildPropertyResponse(value);
    }

    RemoteResponse<Object> setNodeProperty(long nodeId, String key, Object value) {
        Object old;
        this.resume();
        try {
            old = this.server.setNodeProperty(this.connection.neo, nodeId, key, value);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildPropertyResponse(old);
    }

    RemoteResponse<Object> setRelationshipProperty(long relationshipId, String key, Object value) {
        Object old;
        this.resume();
        try {
            old = this.server.setRelationshipProperty(this.connection.neo, relationshipId, key, value);
        }
        catch (RuntimeException ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildPropertyResponse(old);
    }

    RemoteResponse<IterableSpecification<NodeSpecification>> getIndexNodes(int indexId, String key, Object value) {
        SimpleIterator<NodeSpecification> nodes;
        this.resume();
        try {
            nodes = this.server.getIndexNodes(this.connection.neo, indexId, key, value);
        }
        catch (Exception ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.nodes(this.nodTokenPool++, nodes.size(), nodes);
    }

    RemoteResponse<Void> indexNode(int indexId, long nodeId, String key, Object value) {
        this.resume();
        try {
            this.server.indexNode(this.connection.neo, indexId, nodeId, key, value);
        }
        catch (Exception ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildVoidResponse();
    }

    RemoteResponse<Void> removeIndexNode(int indexId, long nodeId, String key, Object value) {
        this.resume();
        try {
            this.server.removeIndexNode(this.connection.neo, indexId, nodeId, key, value);
        }
        catch (Exception ex) {
            return this.response().buildErrorResponse(ex);
        }
        return this.response().buildVoidResponse();
    }
}

