/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.remote.RemoteConnection;

public final class CustomGraphDatabaseServer {
    private final GraphDatabaseService neo;
    private final ServerSocketChannel channel;
    private final ExecutorService exec;

    public CustomGraphDatabaseServer(GraphDatabaseService neo, SocketAddress endpoint, boolean useSSL) throws IOException {
        if (neo == null) {
            throw new NullPointerException("The graph database implementation may not be null.");
        }
        if (useSSL) {
            throw new UnsupportedOperationException("SSL support has not been implemented for the server.");
        }
        this.neo = neo;
        this.channel = ServerSocketChannel.open();
        this.channel.socket().bind(endpoint);
        this.exec = Executors.newCachedThreadPool();
        this.exec.execute(new Runnable(){

            public void run() {
                CustomGraphDatabaseServer.this.accept();
            }
        });
        this.exec.execute(new Runnable(){

            public void run() {
                CustomGraphDatabaseServer.this.select();
            }
        });
    }

    public void shutdown() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static RemoteConnection connect(SocketAddress remote, boolean useSSL) {
        return null;
    }

    public static RemoteConnection connect(SocketAddress remote, boolean useSSL, String username, String password) {
        return null;
    }

    private void accept() {
    }

    private void select() {
    }
}

