/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.remote.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalTraversalService {
    LocalTraversalService() {
    }

    public Iterable<TraversalPosition> performExternalEvaluatorTraversal(Node startNode, Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType[] types, Direction[] directions) {
        switch (order) {
            case BREADTH_FIRST: {
                return new BredthFirstTraversal(new Position(0, 0, null, startNode), stopEvaluator, returnableEvaluator, types, directions);
            }
            case DEPTH_FIRST: {
                return new DepthFirstTraversal(new Position(0, 0, null, startNode), stopEvaluator, returnableEvaluator, types, directions);
            }
        }
        throw new IllegalArgumentException("Unsupported traversal order: " + order);
    }

    private static class Expansion {
        private final Position from;
        private final Iterator<Iterator<Relationship>> relations;
        private Iterator<Relationship> current = null;

        Expansion(Position from, RelationshipType[] types, Direction[] directions) {
            this.from = from;
            LinkedList relations = new LinkedList();
            for (int i = 0; i < types.length; ++i) {
                Iterator iter = from.currentNode().getRelationships(types[i], directions[i]).iterator();
                if (!iter.hasNext()) continue;
                relations.add(iter);
            }
            this.relations = relations.iterator();
            if (this.relations.hasNext()) {
                this.current = this.relations.next();
            }
        }

        Node otherNode(Relationship relationship) {
            return relationship.getOtherNode(this.from.currentNode());
        }

        Position position(int returned, Relationship rel) {
            return new Position(this.from.depth() + 1, returned, rel, this.otherNode(rel));
        }

        boolean hasNext() {
            if (this.current == null) {
                return false;
            }
            if (this.current.hasNext()) {
                return true;
            }
            if (this.relations.hasNext()) {
                this.current = this.relations.next();
                return true;
            }
            this.current = null;
            return false;
        }

        Relationship next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Traversal<S>
    implements Iterable<TraversalPosition> {
        private final Position start;
        private final StopEvaluator stopEvaluator;
        private final ReturnableEvaluator returnableEvaluator;
        private final RelationshipType[] types;
        private final Direction[] directions;

        Traversal(Position position, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType[] types, Direction[] directions) {
            this.start = position;
            this.stopEvaluator = stopEvaluator;
            this.returnableEvaluator = returnableEvaluator;
            this.types = types;
            this.directions = directions;
        }

        boolean shouldReturn(Position currentPos) {
            return this.returnableEvaluator.isReturnableNode((TraversalPosition)currentPos);
        }

        boolean shouldExpand(Position currentPos) {
            return !this.stopEvaluator.isStopNode((TraversalPosition)currentPos);
        }

        @Override
        public Iterator<TraversalPosition> iterator() {
            return new Iterator<TraversalPosition>(){
                final Set<Node> visited = new HashSet<Node>();
                int returned = 0;
                Position current;
                Position last = Traversal.access$000(Traversal.this);
                S store = Traversal.this.initStore();
                {
                    this.visited.add(Traversal.this.start.currentNode());
                    if (Traversal.this.shouldReturn(Traversal.this.start)) {
                        this.current = Traversal.this.start;
                    }
                    if (Traversal.this.shouldExpand(this.last)) {
                        Traversal.this.extendStore(this.store, new Expansion(Traversal.this.start, Traversal.this.types, Traversal.this.directions));
                    }
                }

                @Override
                public boolean hasNext() {
                    if (this.current != null) {
                        return true;
                    }
                    if (this.last == null) {
                        return false;
                    }
                    Position next = this.expand(this.last);
                    if (next != null) {
                        this.current = next;
                        return true;
                    }
                    this.last = null;
                    return false;
                }

                @Override
                public TraversalPosition next() {
                    if (this.hasNext()) {
                        this.last = this.current;
                        this.current = null;
                        ++this.returned;
                        return this.last;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private Position expand(Position position) {
                    Expansion expansion = Traversal.this.current(this.store);
                    while (expansion != null) {
                        if (!expansion.hasNext()) {
                            Traversal.this.removeCurrent(this.store);
                            expansion = Traversal.this.current(this.store);
                            continue;
                        }
                        Relationship relation = expansion.next();
                        if (!this.visited.add(expansion.otherNode(relation))) continue;
                        Position candidate = expansion.position(this.returned, relation);
                        if (Traversal.this.shouldExpand(candidate)) {
                            Traversal.this.extendStore(this.store, new Expansion(candidate, Traversal.this.types, Traversal.this.directions));
                        }
                        if (!Traversal.this.shouldReturn(candidate)) continue;
                        return candidate;
                    }
                    return null;
                }
            };
        }

        abstract S initStore();

        abstract void extendStore(S var1, Expansion var2);

        abstract Expansion current(S var1);

        abstract void removeCurrent(S var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DepthFirstTraversal
    extends Traversal<Stack<Expansion>> {
        DepthFirstTraversal(Position position, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType[] types, Direction[] directions) {
            super(position, stopEvaluator, returnableEvaluator, types, directions);
        }

        @Override
        Expansion current(Stack<Expansion> store) {
            if (store.isEmpty()) {
                return null;
            }
            return store.peek();
        }

        @Override
        void extendStore(Stack<Expansion> store, Expansion expand) {
            store.push(expand);
        }

        @Override
        Stack<Expansion> initStore() {
            return new Stack<Expansion>();
        }

        @Override
        void removeCurrent(Stack<Expansion> store) {
            if (!store.isEmpty()) {
                store.pop();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BredthFirstTraversal
    extends Traversal<Queue<Expansion>> {
        BredthFirstTraversal(Position position, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType[] types, Direction[] directions) {
            super(position, stopEvaluator, returnableEvaluator, types, directions);
        }

        @Override
        Expansion current(Queue<Expansion> store) {
            return store.peek();
        }

        @Override
        void extendStore(Queue<Expansion> store, Expansion expand) {
            store.add(expand);
        }

        @Override
        Queue<Expansion> initStore() {
            return new LinkedList<Expansion>();
        }

        @Override
        void removeCurrent(Queue<Expansion> store) {
            store.poll();
        }
    }
}

