/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.Transport;

final class ProtocolService {
    private final Map<String, Set<Transport>> implementations = new HashMap<String, Set<Transport>>();
    private final Iterable<Transport> factories;

    ConnectionTarget get(URI resourceUri) {
        return this.getSiteFactory(resourceUri).create(resourceUri);
    }

    synchronized void register(Transport factory) {
        if (factory == null) {
            throw new IllegalArgumentException("the RemoteSiteFactory may not be null.");
        }
        for (String protocol : factory.protocols) {
            Set<Transport> factories = this.implementations.get(protocol);
            if (factories == null) {
                factories = new HashSet<Transport>();
                this.implementations.put(protocol, factories);
            }
            factories.add(factory);
        }
    }

    ProtocolService() {
        Iterable<Transport> result;
        try {
            Class<?> serviceLoaderClass = Class.forName("java.util.ServiceLoader");
            Method loadMethod = serviceLoaderClass.getMethod("load", Class.class);
            final Iterable iter = (Iterable)loadMethod.invoke(null, Transport.class);
            result = new CheckingIterable(){

                @Override
                Iterator<?> provideIterator() {
                    return iter.iterator();
                }
            };
        }
        catch (Exception ex) {
            List<Transport> empty = Arrays.asList(new Transport[0]);
            try {
                Class<?> serviceClass = Class.forName("sun.misc.Service");
                final Method providersMethod = serviceClass.getMethod("providers", Class.class);
                result = new CheckingIterable(){

                    @Override
                    Iterator<?> provideIterator() throws Exception {
                        return (Iterator)providersMethod.invoke(null, Transport.class);
                    }
                };
            }
            catch (Exception e) {
                result = empty;
            }
        }
        this.factories = result;
    }

    private synchronized Transport getSiteFactory(URI resourceUri) {
        Transport result = this.loadSiteFactory(resourceUri);
        if (result == null) {
            for (Transport factory : this.factories) {
                this.register(factory);
            }
            result = this.loadSiteFactory(resourceUri);
        }
        if (result != null) {
            return result;
        }
        throw new RuntimeException("No implementation available to handle resource URI: " + resourceUri + "\nSupported protocolls are: " + this.allProtocols());
    }

    private Transport loadSiteFactory(URI resourceUri) {
        String protocol = resourceUri.getScheme();
        Iterable factories = this.implementations.get(protocol);
        if (factories == null) {
            return null;
        }
        for (Transport factory : factories) {
            try {
                if (!factory.handlesUri(resourceUri)) continue;
                return factory;
            }
            catch (Exception ex) {
            }
        }
        return null;
    }

    private String allProtocols() {
        boolean comma = false;
        StringBuilder result = new StringBuilder();
        for (Set<Transport> factories : this.implementations.values()) {
            for (Transport factory : factories) {
                for (String protocol : factory.protocols) {
                    if (comma) {
                        result.append(", ");
                    }
                    result.append(protocol);
                    comma = true;
                }
            }
        }
        if (comma) {
            return result.toString();
        }
        return "None!";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CheckingIterable
    implements Iterable<Transport> {
        private CheckingIterable() {
        }

        @Override
        public Iterator<Transport> iterator() {
            try {
                final Iterator<?> iterator = this.provideIterator();
                return new Iterator<Transport>(){
                    Transport cached = null;

                    @Override
                    public boolean hasNext() {
                        if (this.cached != null) {
                            return true;
                        }
                        while (iterator.hasNext()) {
                            try {
                                this.cached = (Transport)iterator.next();
                                return true;
                            }
                            catch (Throwable ex) {
                                this.cached = null;
                            }
                        }
                        return false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Transport next() {
                        if (this.hasNext()) {
                            try {
                                Transport transport = this.cached;
                                return transport;
                            }
                            finally {
                                this.cached = null;
                            }
                        }
                        throw new IllegalStateException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            catch (Exception ex) {
                return Arrays.asList(new Transport[0]).iterator();
            }
        }

        abstract Iterator<?> provideIterator() throws Exception;
    }
}

