/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.remote.ConfigurationModule;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.ProtocolService;
import org.neo4j.remote.RemoteConnection;
import org.neo4j.remote.RemoteGraphDbEngine;
import org.neo4j.remote.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteGraphDatabase
implements GraphDatabaseService {
    private static final ProtocolService protocol = new ProtocolService();
    private final RemoteGraphDbEngine engine;

    public RemoteGraphDatabase(ConnectionTarget site) {
        this(null, site);
    }

    public RemoteGraphDatabase(ConfigurationModule config, ConnectionTarget site) {
        this(site.connect(), config);
    }

    public RemoteGraphDatabase(ConnectionTarget site, String username, String password) {
        this(null, site, username, password);
    }

    public RemoteGraphDatabase(ConfigurationModule config, ConnectionTarget site, String username, String password) {
        this(site.connect(username, password), config);
    }

    public RemoteGraphDatabase(String resourceUri) throws URISyntaxException {
        this(null, resourceUri);
    }

    public RemoteGraphDatabase(ConfigurationModule config, String resourceUri) throws URISyntaxException {
        this(config, protocol.get(new URI(resourceUri)));
    }

    public RemoteGraphDatabase(String resourceUri, String username, String password) throws URISyntaxException {
        this(null, resourceUri, username, password);
    }

    public RemoteGraphDatabase(ConfigurationModule config, String resourceUri, String username, String password) throws URISyntaxException {
        this(config, protocol.get(new URI(resourceUri)), username, password);
    }

    private RemoteGraphDatabase(RemoteConnection connection, ConfigurationModule config) {
        this.engine = new RemoteGraphDbEngine(connection, config);
    }

    public static void registerProtocol(Transport factory) {
        protocol.register(factory);
    }

    public Transaction beginTx() {
        return this.engine.beginTx();
    }

    public Node createNode() {
        return this.engine.current().createNode();
    }

    public Node getNodeById(long id) {
        return this.engine.current().getNodeById(id);
    }

    public Relationship getRelationshipById(long id) {
        return this.engine.current().getRelationshipById(id);
    }

    public Node getReferenceNode() {
        return this.engine.current(true).getReferenceNode();
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.engine.current(true).getRelationshipTypes();
    }

    public Iterable<Node> getAllNodes() {
        return this.engine.current(true).getAllNodes();
    }

    public void shutdown() {
        this.engine.shutdown();
    }

    RemoteGraphDbEngine getEngine() {
        return this.engine;
    }

    public boolean enableRemoteShell() {
        return false;
    }

    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return false;
    }
}

