/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.remote.CloseableIterator;
import org.neo4j.remote.Configuration;
import org.neo4j.remote.ConfigurationFactory;
import org.neo4j.remote.ConfigurationModule;
import org.neo4j.remote.IterableSpecification;
import org.neo4j.remote.LocalTraversalService;
import org.neo4j.remote.NodeSpecification;
import org.neo4j.remote.RelType;
import org.neo4j.remote.RelationshipSpecification;
import org.neo4j.remote.RemoteConnection;
import org.neo4j.remote.RemoteNode;
import org.neo4j.remote.RemoteResponse;
import org.neo4j.remote.RemoteTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteGraphDbEngine {
    private final ThreadLocal<RemoteTransaction> current = new ThreadLocal();
    private final RemoteConnection connection;
    private final ConfigurationFactory factory;
    private final Map<String, RelationshipType> typesCache = null;
    private final LocalTraversalService traversal = new LocalTraversalService();

    RemoteGraphDbEngine(RemoteConnection connection, ConfigurationModule module) {
        this.connection = connection;
        this.factory = new ConfigurationFactory(module, connection.configure(Configuration.of(module)));
    }

    RemoteTransaction beginTx() {
        RemoteTransaction transaction = this.current.get();
        transaction = transaction != null ? this.factory.createNestedTransaction(transaction) : new RemoteTransaction(this, this.connection.beginTransaction());
        this.current.set(transaction);
        return transaction;
    }

    void endTx(RemoteTransaction previous) {
        this.current.set(previous);
    }

    RemoteTransaction current() {
        return this.current(false);
    }

    RemoteTransaction current(boolean read_only) {
        RemoteTransaction transaction = this.current.get();
        if (transaction == null) {
            throw new NotInTransactionException();
        }
        return transaction;
    }

    void shutdown() {
        this.connection.close();
    }

    private <T> T receive(RemoteResponse<T> response) {
        return response.value();
    }

    void commit(int txId) {
        this.connection.commit(txId);
    }

    void rollback(int txId) {
        this.connection.rollback(txId);
    }

    RelationshipType type(String name) {
        RelationshipType type = null;
        if (this.typesCache != null) {
            type = this.typesCache.get(name);
        }
        if (type == null) {
            type = new RelType(name);
            if (this.typesCache != null) {
                this.typesCache.put(name, type);
            }
        }
        return type;
    }

    Iterable<String> getRelationshipTypes(final int txId) {
        return new BatchIterable<String>(){

            @Override
            IterableSpecification<String> init() {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getRelationshipTypes(txId));
            }

            @Override
            IterableSpecification<String> more(int requestToken) {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getMoreRelationshipTypes(txId, requestToken));
            }

            @Override
            void done(int requestToken) {
                RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.closeRelationshipTypeIterator(txId, requestToken));
            }
        };
    }

    Iterable<NodeSpecification> getAllNodes(final int txId) {
        return new BatchIterable<NodeSpecification>(){

            @Override
            IterableSpecification<NodeSpecification> init() {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getAllNodes(txId));
            }

            @Override
            IterableSpecification<NodeSpecification> more(int requestToken) {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getMoreNodes(txId, requestToken));
            }

            @Override
            void done(int requestToken) {
                RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.closeNodeIterator(txId, requestToken));
            }
        };
    }

    long createNode(int txId) {
        return this.receive(this.connection.createNode((int)txId)).id;
    }

    long getReferenceNode(int txId) {
        return this.receive(this.connection.getReferenceNode((int)txId)).id;
    }

    boolean hasNodeWithId(int txId, long nodeId) {
        return this.receive(this.connection.hasNodeWithId(txId, nodeId));
    }

    void deleteNode(int txId, long nodeId) {
        this.receive(this.connection.deleteNode(txId, nodeId));
    }

    RelationshipSpecification createRelationship(int txId, String typeName, long startId, long endId) {
        return this.receive(this.connection.createRelationship(txId, typeName, startId, endId));
    }

    RelationshipSpecification getRelationshipById(int txId, long relationshipId) {
        return this.receive(this.connection.getRelationshipById(txId, relationshipId));
    }

    Iterable<RelationshipSpecification> getAllRelationships(final int txId, final long nodeId, final Direction dir) {
        return new BatchIterable<RelationshipSpecification>(){

            @Override
            IterableSpecification<RelationshipSpecification> init() {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getAllRelationships(txId, nodeId, dir));
            }

            @Override
            IterableSpecification<RelationshipSpecification> more(int requestToken) {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getMoreRelationships(txId, requestToken));
            }

            @Override
            void done(int requestToken) {
                RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.closeRelationshipIterator(txId, requestToken));
            }
        };
    }

    Iterable<RelationshipSpecification> getRelationships(final int txId, final long nodeId, final Direction dir, final String[] typeNames) {
        return new BatchIterable<RelationshipSpecification>(){

            @Override
            IterableSpecification<RelationshipSpecification> init() {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getRelationships(txId, nodeId, dir, typeNames));
            }

            @Override
            IterableSpecification<RelationshipSpecification> more(int requestToken) {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getMoreRelationships(txId, requestToken));
            }

            @Override
            void done(int requestToken) {
                RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.closeRelationshipIterator(txId, requestToken));
            }
        };
    }

    void deleteRelationship(int txId, long relationshipId) {
        this.receive(this.connection.deleteRelationship(txId, relationshipId));
    }

    Iterable<TraversalPosition> traverse(int txId, RemoteNode startNode, Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType[] relationshipTypes, Direction[] directions) {
        return this.traversal.performExternalEvaluatorTraversal(startNode, order, stopEvaluator, returnableEvaluator, relationshipTypes, directions);
    }

    Object getNodeProperty(int txId, long nodeId, String key) {
        return this.receive(this.connection.getNodeProperty(txId, nodeId, key));
    }

    Object getRelationshipProperty(int txId, long relationshipId, String key) {
        return this.receive(this.connection.getRelationshipProperty(txId, relationshipId, key));
    }

    void setNodeProperty(int txId, long nodeId, String key, Object value) {
        this.receive(this.connection.setNodeProperty(txId, nodeId, key, value));
    }

    void setRelationshipProperty(int txId, long relationshipId, String key, Object value) {
        this.receive(this.connection.setRelationshipProperty(txId, relationshipId, key, value));
    }

    Iterable<String> getNodePropertyKeys(final int txId, final long nodeId) {
        return new BatchIterable<String>(){

            @Override
            IterableSpecification<String> init() {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getNodePropertyKeys(txId, nodeId));
            }

            @Override
            IterableSpecification<String> more(int requestToken) {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getMorePropertyKeys(txId, requestToken));
            }

            @Override
            void done(int requestToken) {
                RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.closePropertyKeyIterator(txId, requestToken));
            }
        };
    }

    Iterable<String> getRelationshipPropertyKeys(final int txId, final long relationshipId) {
        return new BatchIterable<String>(){

            @Override
            IterableSpecification<String> init() {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getRelationshipPropertyKeys(txId, relationshipId));
            }

            @Override
            IterableSpecification<String> more(int requestToken) {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getMorePropertyKeys(txId, requestToken));
            }

            @Override
            void done(int requestToken) {
                RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.closePropertyKeyIterator(txId, requestToken));
            }
        };
    }

    boolean hasNodeProperty(int txId, long nodeId, String key) {
        return this.receive(this.connection.hasNodeProperty(txId, nodeId, key));
    }

    boolean hasRelationshipProperty(int txId, long relationshiId, String key) {
        return this.receive(this.connection.hasRelationshipProperty(txId, relationshiId, key));
    }

    Object removeNodeProperty(int txId, long nodeId, String key) {
        return this.receive(this.connection.removeNodeProperty(txId, nodeId, key));
    }

    Object removeRelationshipProperty(int txId, long relationshipId, String key) {
        return this.receive(this.connection.removeRelationshipProperty(txId, relationshipId, key));
    }

    BatchIterable<NodeSpecification> getIndexNodes(final int txId, final int indexId, final String key, final Object value) {
        return new BatchIterable<NodeSpecification>(){

            @Override
            IterableSpecification<NodeSpecification> init() {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getIndexNodes(txId, indexId, key, value));
            }

            @Override
            IterableSpecification<NodeSpecification> more(int requestToken) {
                return (IterableSpecification)RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.getMoreNodes(txId, requestToken));
            }

            @Override
            void done(int requestToken) {
                RemoteGraphDbEngine.this.receive(RemoteGraphDbEngine.this.connection.closeNodeIterator(txId, requestToken));
            }
        };
    }

    void indexNode(int txId, int indexId, long nodeId, String key, Object value) {
        this.receive(this.connection.indexNode(txId, indexId, nodeId, key, value));
    }

    void removeIndexNode(int txId, int indexId, long nodeId, String key, Object value) {
        this.receive(this.connection.removeIndexNode(txId, indexId, nodeId, key, value));
    }

    int getIndexId(String name) {
        return this.receive(this.connection.getIndexServiceId(name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BatchIterable<T>
    implements Iterable<T> {
        BatchIterable() {
        }

        @Override
        public final CloseableIteratorWithSize<T> iterator() {
            final IterableSpecification<T> spec = this.init();
            return new CloseableIteratorWithSize<T>(){
                int index = 0;
                T[] content;
                int token;
                boolean hasMore;
                long size;
                {
                    this.content = spec.content;
                    this.token = spec.token;
                    this.hasMore = spec.hasMore;
                    this.size = spec.size;
                }

                @Override
                public boolean hasNext() {
                    return this.content != null && (this.index < this.content.length || this.hasMore);
                }

                @Override
                public T next() {
                    if (this.content != null && this.index < this.content.length) {
                        return this.content[this.index++];
                    }
                    if (this.hasMore) {
                        this.index = 0;
                        IterableSpecification spec2 = BatchIterable.this.more(this.token);
                        this.content = spec2.content;
                        this.token = spec2.token;
                        this.hasMore = spec2.hasMore;
                        return this.content[this.index++];
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public long size() {
                    if (this.size < 0L) {
                        throw new UnsupportedOperationException("This iterator has no size.");
                    }
                    return this.size;
                }

                @Override
                public void close() {
                    if (this.content != null) {
                        BatchIterable.this.done(this.token);
                        this.hasMore = false;
                        this.content = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                protected void finalize() {
                    this.close();
                }
            };
        }

        abstract IterableSpecification<T> init();

        abstract IterableSpecification<T> more(int var1);

        abstract void done(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface CloseableIteratorWithSize<T>
    extends CloseableIterator<T> {
        public long size();
    }
}

