/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.Iterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.index.IndexHits;
import org.neo4j.index.IndexService;
import org.neo4j.index.Isolation;
import org.neo4j.remote.RemoteGraphDatabase;
import org.neo4j.remote.RemoteGraphDbEngine;
import org.neo4j.remote.RemoteNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteIndexService
implements IndexService {
    private RemoteGraphDbEngine engine;
    private final int id;

    public RemoteIndexService(GraphDatabaseService neo, String name) {
        this.engine = ((RemoteGraphDatabase)neo).getEngine();
        this.id = this.engine().getIndexId(name);
    }

    private RemoteGraphDbEngine engine() {
        if (this.engine == null) {
            throw new IllegalStateException("Index has been shut down.");
        }
        return this.engine;
    }

    public void shutdown() {
        this.engine = null;
    }

    public IndexHits<Node> getNodes(String key, Object value) {
        return this.engine().current().getIndexNodes(this.id, key, value);
    }

    public Node getSingleNode(String key, Object value) {
        Iterator nodes = this.getNodes(key, value).iterator();
        Node node = null;
        if (nodes.hasNext()) {
            node = (Node)nodes.next();
            if (nodes.hasNext()) {
                throw new RuntimeException("Multiple values found.");
            }
        }
        return node;
    }

    public void index(Node node, String key, Object value) {
        if (node instanceof RemoteNode) {
            RemoteNode remote = (RemoteNode)node;
            if (remote.engine.equals(this.engine())) {
                this.engine().current().indexNode(this.id, remote, key, value);
                return;
            }
        }
        throw new IllegalArgumentException("Node not in same node space.");
    }

    public void removeIndex(Node node, String key, Object value) {
        if (node instanceof RemoteNode) {
            RemoteNode remote = (RemoteNode)node;
            if (remote.engine.equals(this.engine())) {
                this.engine().current().removeIndexNode(this.id, remote, key, value);
                return;
            }
        }
        throw new IllegalArgumentException("Node not in same node space.");
    }

    public void setIsolation(Isolation level) {
        throw new UnsupportedOperationException("Configuring the isolation not supported by remote client.");
    }
}

