/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.remote.RemoteGraphDbEngine;
import org.neo4j.remote.RemotePropertyContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteNode
extends RemotePropertyContainer
implements Node {
    RemoteNode(RemoteGraphDbEngine txService, long id) {
        super(txService, id);
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteNode) {
            RemoteNode node = (RemoteNode)obj;
            return node.id == this.id && node.engine.equals(this.engine);
        }
        return false;
    }

    public String toString() {
        return "Node[" + this.id + "]";
    }

    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        if (otherNode instanceof RemoteNode) {
            RemoteNode other = (RemoteNode)otherNode;
            if (other.engine.equals(this.engine)) {
                return this.engine.current().createRelationship(type, this, other);
            }
        }
        throw new IllegalArgumentException("Other node not in same node space.");
    }

    public void delete() {
        this.engine.current().deleteNode(this);
    }

    public long getId() {
        return this.id;
    }

    public Iterable<Relationship> getRelationships() {
        return this.engine.current().getRelationships(this, Direction.BOTH, null);
    }

    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.engine.current().getRelationships(this, Direction.BOTH, types == null ? types : new RelationshipType[]{});
    }

    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.engine.current().getRelationships(this, dir, null);
    }

    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        RelationshipType[] types = new RelationshipType[]{type};
        return this.engine.current().getRelationships(this, dir, types);
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        Iterator<Relationship> relations = this.getRelationships(type, dir).iterator();
        if (!relations.hasNext()) {
            return null;
        }
        Relationship relation = relations.next();
        if (relations.hasNext()) {
            throw new NotFoundException("More then one relationship[" + type + "] found");
        }
        return relation;
    }

    public boolean hasRelationship() {
        return this.getRelationships().iterator().hasNext();
    }

    public boolean hasRelationship(RelationshipType ... types) {
        return this.getRelationships(types).iterator().hasNext();
    }

    public boolean hasRelationship(Direction dir) {
        return this.getRelationships(dir).iterator().hasNext();
    }

    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.getRelationships(type, dir).iterator().hasNext();
    }

    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return this.traversal(traversalOrder, stopEvaluator, returnableEvaluator, new RelationshipType[]{relationshipType}, new Direction[]{direction});
    }

    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return this.traversal(traversalOrder, stopEvaluator, returnableEvaluator, new RelationshipType[]{firstRelationshipType, secondRelationshipType}, new Direction[]{firstDirection, secondDirection});
    }

    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        if (relationshipTypesAndDirections.length % 2 != 0) {
            throw new IllegalArgumentException("Not as many directions as relationship types.");
        }
        RelationshipType[] relationshipTypes = new RelationshipType[relationshipTypesAndDirections.length / 2];
        Direction[] directions = new Direction[relationshipTypesAndDirections.length / 2];
        int i = 0;
        for (int j = 0; j < directions.length; ++j) {
            try {
                relationshipTypes[j] = (RelationshipType)relationshipTypesAndDirections[i];
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Not a RelationshipType: " + relationshipTypesAndDirections[i]);
            }
            try {
                directions[j] = (Direction)relationshipTypesAndDirections[i + 1];
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Not a Direction: " + relationshipTypesAndDirections[i + 1]);
            }
            i += 2;
        }
        return this.traversal(traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypes, directions);
    }

    @Override
    Object getContainerProperty(String key) {
        return this.engine.current().getProperty(this, key);
    }

    public Iterable<String> getPropertyKeys() {
        return this.engine.current().getPropertyKeys(this);
    }

    public boolean hasProperty(String key) {
        return this.engine.current().hasProperty(this, key);
    }

    public Object removeProperty(String key) {
        return this.engine.current().removeProperty(this, key);
    }

    public void setProperty(String key, Object value) {
        this.engine.current().setProperty(this, key, value);
    }

    private Traverser traversal(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType[] relationshipTypes, Direction[] directions) {
        final Iterable<TraversalPosition> positions = this.engine.current().traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypes, directions);
        return new Traverser(){
            Iterator<TraversalPosition> iter;
            TraversalPosition last;
            TraversalPosition current;
            {
                this.iter = positions.iterator();
                this.last = null;
                this.current = null;
            }

            public TraversalPosition currentPosition() {
                return this.last;
            }

            public Collection<Node> getAllNodes() {
                LinkedList<Node> result = new LinkedList<Node>();
                Iterator<Node> i$ = this.iterator();
                while (i$.hasNext()) {
                    Node node = i$.next();
                    result.add(node);
                }
                return result;
            }

            public Iterator<Node> iterator() {
                return new Iterator<Node>(){

                    @Override
                    public boolean hasNext() {
                        if (current != null) {
                            return true;
                        }
                        if (iter.hasNext()) {
                            current = iter.next();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Node next() {
                        if (this.hasNext()) {
                            last = current;
                            current = null;
                            return last.currentNode();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

