/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.Iterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.remote.RemoteGraphDbEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RemotePropertyContainer
implements PropertyContainer {
    final RemoteGraphDbEngine engine;
    final long id;

    RemotePropertyContainer(RemoteGraphDbEngine engine, long id) {
        this.engine = engine;
        this.id = id;
    }

    public final Object getProperty(String key) {
        Object result = this.getContainerProperty(key);
        if (result == null) {
            throw new NotFoundException(this + " has no property \"" + key + "\".");
        }
        return result;
    }

    public final Object getProperty(String key, Object defaultValue) {
        Object result = this.getContainerProperty(key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    abstract Object getContainerProperty(String var1);

    public final Iterable<Object> getPropertyValues() {
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    final Iterator<String> keys;
                    {
                        this.keys = RemotePropertyContainer.this.getPropertyKeys().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keys.hasNext();
                    }

                    @Override
                    public Object next() {
                        return RemotePropertyContainer.this.getProperty(this.keys.next());
                    }

                    @Override
                    public void remove() {
                        this.keys.remove();
                    }
                };
            }
        };
    }
}

