/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.remote.RemoteGraphDbEngine;
import org.neo4j.remote.RemoteNode;
import org.neo4j.remote.RemotePropertyContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteRelationship
extends RemotePropertyContainer
implements Relationship {
    private final RelationshipType type;
    private final RemoteNode startNode;
    private final RemoteNode endNode;

    RemoteRelationship(RemoteGraphDbEngine txService, long id, RelationshipType type, RemoteNode start, RemoteNode end) {
        super(txService, id);
        this.type = type;
        this.startNode = start;
        this.endNode = end;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteRelationship) {
            RemoteRelationship relationship = (RemoteRelationship)obj;
            return relationship.id == this.id && relationship.engine.equals(this.engine);
        }
        return false;
    }

    public String toString() {
        return "Relationship[" + this.id + "]";
    }

    public long getId() {
        return this.id;
    }

    public void delete() {
        this.engine.current().deleteRelationship(this);
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public Node[] getNodes() {
        return new Node[]{this.startNode, this.endNode};
    }

    public Node getOtherNode(Node node) {
        if (node.equals(this.startNode)) {
            return this.endNode;
        }
        if (node.equals(this.endNode)) {
            return this.startNode;
        }
        throw new RuntimeException("Node[" + node.getId() + "] not connected to Relationship[" + this.getId() + "]");
    }

    public RelationshipType getType() {
        return this.type;
    }

    public boolean isType(RelationshipType type) {
        return this.type.name().equals(type.name());
    }

    @Override
    Object getContainerProperty(String key) {
        return this.engine.current().getProperty(this, key);
    }

    public Iterable<String> getPropertyKeys() {
        return this.engine.current().getPropertyKeys(this);
    }

    public boolean hasProperty(String key) {
        return this.engine.current().hasProperty(this, key);
    }

    public Object removeProperty(String key) {
        return this.engine.current().removeProperty(this, key);
    }

    public void setProperty(String key, Object value) {
        this.engine.current().setProperty(this, key, value);
    }
}

