/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.io.Serializable;
import org.neo4j.remote.IterableSpecification;
import org.neo4j.remote.NodeSpecification;
import org.neo4j.remote.RelationshipSpecification;
import org.neo4j.remote.ResponseVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    abstract T value();

    private RemoteResponse(ResponseBuilder builder) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorResponse<T>
    extends RemoteResponse<T> {
        private static final long serialVersionUID = 1L;
        private final Exception exception;

        private ErrorResponse(ResponseBuilder builder, Exception ex) {
            super(builder);
            this.exception = ex;
        }

        @Override
        T value() {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException("Unexpected server exception.", this.exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VoidResponse
    extends RemoteResponse<Void> {
        private static final long serialVersionUID = 1L;

        private VoidResponse(ResponseBuilder builder) {
            super(builder);
        }

        @Override
        Void value() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerResponse
    extends RemoteResponse<Integer> {
        private static final long serialVersionUID = 1L;
        private final int value;

        private IntegerResponse(ResponseBuilder builder, int value) {
            super(builder);
            this.value = value;
        }

        @Override
        Integer value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanResponse
    extends RemoteResponse<Boolean> {
        private static final long serialVersionUID = 1L;
        private final boolean value;

        private BooleanResponse(ResponseBuilder builder, boolean value) {
            super(builder);
            this.value = value;
        }

        @Override
        Boolean value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectResponse
    extends RemoteResponse<Object> {
        private static final long serialVersionUID = 1L;
        private final Object value;

        private ObjectResponse(ResponseBuilder builder, Object value) {
            super(builder);
            this.value = value;
        }

        @Override
        Object value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IterableResponse<T>
    extends RemoteResponse<IterableSpecification<T>> {
        private static final long serialVersionUID = 1L;
        private final boolean hasMore;
        private final int moreToken;
        private final long size;
        private final T[] content;

        private IterableResponse(ResponseBuilder builder, boolean hasMore, int moreToken, long size, T[] content) {
            super(builder);
            this.hasMore = hasMore;
            this.moreToken = moreToken;
            this.size = size;
            this.content = content;
        }

        @Override
        IterableSpecification<T> value() {
            return new IterableSpecification<T>(this.hasMore, this.moreToken, this.size, this.content);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelationshipResponse
    extends RemoteResponse<RelationshipSpecification> {
        private static final long serialVersionUID = 1L;
        private final long id;
        private final String typeName;
        private final long startNode;
        private final long endNode;

        private RelationshipResponse(ResponseBuilder builder, long id, String typeName, long startNode, long endNode) {
            super(builder);
            this.id = id;
            this.typeName = typeName;
            this.startNode = startNode;
            this.endNode = endNode;
        }

        @Override
        RelationshipSpecification value() {
            return new RelationshipSpecification(this.id, this.typeName, this.startNode, this.endNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeResponse
    extends RemoteResponse<NodeSpecification> {
        private static final long serialVersionUID = 1L;
        private final long id;

        private NodeResponse(ResponseBuilder builder, long id) {
            super(builder);
            this.id = id;
        }

        @Override
        NodeSpecification value() {
            return new NodeSpecification(this.id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ResponseBuilder
    implements ResponseVisitor {
        public RemoteResponse<NodeSpecification> buildNodeResponse(long id) {
            return new NodeResponse(this, id);
        }

        public RemoteResponse<RelationshipSpecification> buildRelationshipResponse(long id, String typeName, long startNode, long endNode) {
            return new RelationshipResponse(this, id, typeName, startNode, endNode);
        }

        public RemoteResponse<Object> buildPropertyResponse(Object value) {
            return new ObjectResponse(this, value);
        }

        public RemoteResponse<Boolean> buildBooleanResponse(boolean value) {
            return new BooleanResponse(this, value);
        }

        public RemoteResponse<Integer> buildIntegerResponse(int value) {
            return new IntegerResponse(this, value);
        }

        public RemoteResponse<IterableSpecification<String>> buildPartialStringResponse(int moreToken, String ... strings) {
            return new IterableResponse<String>(this, true, moreToken, -1L, strings);
        }

        public RemoteResponse<IterableSpecification<String>> buildFinalStringResponse(String ... strings) {
            return new IterableResponse<String>(this, false, 0, -1L, strings);
        }

        public RemoteResponse<IterableSpecification<NodeSpecification>> buildPartialNodeResponse(int moreToken, long size, NodeSpecification ... nodes) {
            return new IterableResponse<NodeSpecification>(this, true, moreToken, size, nodes);
        }

        public RemoteResponse<IterableSpecification<NodeSpecification>> buildFinalNodeResponse(long size, NodeSpecification ... nodes) {
            return new IterableResponse<NodeSpecification>(this, false, 0, size, nodes);
        }

        public RemoteResponse<IterableSpecification<RelationshipSpecification>> buildPartialRelationshipResponse(int moreToken, RelationshipSpecification ... relationships) {
            return new IterableResponse<RelationshipSpecification>(this, true, moreToken, -1L, relationships);
        }

        public RemoteResponse<IterableSpecification<RelationshipSpecification>> buildFinalRelationshipResponse(RelationshipSpecification ... relationships) {
            return new IterableResponse<RelationshipSpecification>(this, false, 0, -1L, relationships);
        }

        public RemoteResponse<Void> buildVoidResponse() {
            return new VoidResponse(this);
        }

        public <T> RemoteResponse<T> buildErrorResponse(Exception ex) {
            return new ErrorResponse(this, ex);
        }
    }
}

