/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote;

import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.index.IndexHits;
import org.neo4j.remote.CloseableIterator;
import org.neo4j.remote.NodeSpecification;
import org.neo4j.remote.RelationshipSpecification;
import org.neo4j.remote.RemoteGraphDbEngine;
import org.neo4j.remote.RemoteNode;
import org.neo4j.remote.RemoteRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteTransaction
implements Transaction {
    private State state = State.UNDEFINED;
    private final RemoteGraphDbEngine engine;
    final int id;
    private final Map<Long, RemoteNode> nodeCache = null;
    private final Map<Long, RemoteRelationship> relationshipCache = null;

    public void failure() {
        State.FAILURE.update(this);
    }

    public void success() {
        State.SUCCESS.update(this);
    }

    public void finish() {
        this.state.finish(this);
        this.engine.endTx(null);
    }

    public String toString() {
        return "RemoteTransaction[" + this.engine + ", id=" + this.id + "]";
    }

    RemoteTransaction(RemoteGraphDbEngine txService, int id) {
        this.engine = txService;
        this.id = id;
    }

    RemoteTransaction createPlaceboTransaction() {
        final RemoteTransaction previous = this;
        return new RemoteTransaction(this.engine, this.id){

            public void failure() {
                State.FAILURE.update(previous);
            }

            public void success() {
                State.SUCCESS.update(previous);
            }

            public void finish() {
            }

            RemoteTransaction createPlaceboTransaction() {
                return previous.createPlaceboTransaction();
            }

            public String toString() {
                return "Placebo" + super.toString();
            }
        };
    }

    private void commit() {
        this.engine.commit(this.id);
    }

    private void rollback() {
        this.engine.rollback(this.id);
    }

    private RemoteNode newNode(long nodeId) {
        RemoteNode node = new RemoteNode(this.engine, nodeId);
        if (this.nodeCache != null) {
            this.nodeCache.put(nodeId, node);
        }
        return node;
    }

    private RemoteNode getNode(long nodeId, boolean verified) {
        RemoteNode node = null;
        if (this.nodeCache != null) {
            node = this.nodeCache.get(nodeId);
        }
        if (node == null) {
            if (verified || this.engine.hasNodeWithId(this.id, nodeId)) {
                node = this.newNode(nodeId);
            } else {
                throw new NotFoundException("TODO: exception message. No node with id=" + nodeId);
            }
        }
        return node;
    }

    RemoteNode createNode() {
        return this.newNode(this.engine.createNode(this.id));
    }

    RemoteNode getNodeById(long id) {
        return this.getNode(id, false);
    }

    RemoteNode getReferenceNode() {
        return this.getNode(this.engine.getReferenceNode(this.id), true);
    }

    void deleteNode(RemoteNode node) {
        this.engine.deleteNode(this.id, node.id);
    }

    Iterable<Node> getAllNodes() {
        return new ConversionIterable<NodeSpecification, Node>(this.engine.getAllNodes(this.id)){

            @Override
            Node convert(NodeSpecification source) {
                return RemoteTransaction.this.getNode(source.id, true);
            }
        };
    }

    Iterable<RelationshipType> getRelationshipTypes() {
        return new ConversionIterable<String, RelationshipType>(this.engine.getRelationshipTypes(this.id)){

            @Override
            RelationshipType convert(String source) {
                return RemoteTransaction.this.engine.type(source);
            }
        };
    }

    private RemoteRelationship newRelationship(RelationshipSpecification spec) {
        RemoteRelationship relationship = new RemoteRelationship(this.engine, spec.relationshipId, this.engine.type(spec.name), this.getNode(spec.startNodeId, true), this.getNode(spec.endNodeId, true));
        if (this.relationshipCache != null) {
            this.relationshipCache.put(spec.relationshipId, relationship);
        }
        return relationship;
    }

    private RemoteRelationship getRelationship(long relationshipId, RelationshipSpecification spec) {
        RemoteRelationship relationship = null;
        if (this.relationshipCache != null) {
            relationship = this.relationshipCache.get(relationshipId);
        }
        if (relationship == null) {
            if (spec == null) {
                spec = this.engine.getRelationshipById(this.id, relationshipId);
            }
            relationship = this.newRelationship(spec);
        }
        return relationship;
    }

    RemoteRelationship createRelationship(RelationshipType type, RemoteNode startNode, RemoteNode endNode) {
        return this.newRelationship(this.engine.createRelationship(this.id, type.name(), startNode.id, endNode.id));
    }

    RemoteRelationship getRelationshipById(long id) {
        return this.getRelationship(id, null);
    }

    Iterable<Relationship> getRelationships(RemoteNode node, Direction dir, RelationshipType ... types) {
        Iterable<RelationshipSpecification> spec;
        if (types == null) {
            spec = this.engine.getAllRelationships(this.id, node.id, dir);
        } else {
            String[] typeNames = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                typeNames[i] = types[i].name();
            }
            spec = this.engine.getRelationships(this.id, node.id, dir, typeNames);
        }
        return new ConversionIterable<RelationshipSpecification, Relationship>(spec){

            @Override
            Relationship convert(RelationshipSpecification source) {
                return RemoteTransaction.this.getRelationship(source.relationshipId, source);
            }
        };
    }

    void deleteRelationship(RemoteRelationship relationship) {
        this.engine.deleteRelationship(this.id, relationship.id);
    }

    Iterable<TraversalPosition> traverse(RemoteNode startNode, Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType[] relationshipTypes, Direction[] directions) {
        return this.engine.traverse(this.id, startNode, order, stopEvaluator, returnableEvaluator, relationshipTypes, directions);
    }

    Object getProperty(RemoteNode owner, String key) {
        return this.engine.getNodeProperty(this.id, owner.id, key);
    }

    Object getProperty(RemoteRelationship owner, String key) {
        return this.engine.getRelationshipProperty(this.id, owner.id, key);
    }

    void setProperty(RemoteNode owner, String key, Object value) {
        this.engine.setNodeProperty(this.id, owner.id, key, value);
    }

    void setProperty(RemoteRelationship owner, String key, Object value) {
        this.engine.setRelationshipProperty(this.id, owner.id, key, value);
    }

    Iterable<String> getPropertyKeys(RemoteNode owner) {
        return this.engine.getNodePropertyKeys(this.id, owner.id);
    }

    Iterable<String> getPropertyKeys(RemoteRelationship owner) {
        return this.engine.getRelationshipPropertyKeys(this.id, owner.id);
    }

    boolean hasProperty(RemoteNode owner, String key) {
        return this.engine.hasNodeProperty(this.id, owner.id, key);
    }

    boolean hasProperty(RemoteRelationship owner, String key) {
        return this.engine.hasRelationshipProperty(this.id, owner.id, key);
    }

    Object removeProperty(RemoteNode owner, String key) {
        return this.engine.removeNodeProperty(this.id, owner.id, key);
    }

    Object removeProperty(RemoteRelationship owner, String key) {
        return this.engine.removeRelationshipProperty(this.id, owner.id, key);
    }

    IndexHits<Node> getIndexNodes(int indexId, String key, Object value) {
        RemoteGraphDbEngine.BatchIterable<NodeSpecification> iter = this.engine.getIndexNodes(this.id, indexId, key, value);
        return new IndexHitsImpl(iter){

            Node convert(NodeSpecification source) {
                return RemoteTransaction.this.getNode(source.id, true);
            }
        };
    }

    void indexNode(int indexId, RemoteNode node, String key, Object value) {
        this.engine.indexNode(this.id, indexId, node.id, key, value);
    }

    void removeIndexNode(int indexId, RemoteNode node, String key, Object value) {
        this.engine.removeIndexNode(this.id, indexId, node.id, key, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IndexHitsImpl
    implements IndexHits<Node>,
    CloseableIterator<Node> {
        private final RemoteGraphDbEngine.CloseableIteratorWithSize<NodeSpecification> nodes;

        IndexHitsImpl(RemoteGraphDbEngine.BatchIterable<NodeSpecification> nodes) {
            this.nodes = nodes.iterator();
        }

        abstract Node convert(NodeSpecification var1);

        public final Iterator<Node> iterator() {
            return this;
        }

        @Override
        public final void close() {
            if (this.nodes instanceof CloseableIterator) {
                this.nodes.close();
            }
        }

        public final int size() {
            return (int)this.nodes.size();
        }

        @Override
        public final boolean hasNext() {
            return this.nodes.hasNext();
        }

        @Override
        public final Node next() {
            return this.convert((NodeSpecification)this.nodes.next());
        }

        @Override
        public final void remove() {
            this.nodes.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ConversionIterable<F, T>
    implements Iterable<T> {
        private final Iterable<F> source;

        ConversionIterable(Iterable<F> source) {
            this.source = source;
        }

        abstract T convert(F var1);

        @Override
        public Iterator<T> iterator() {
            return new CloseableIterator<T>(){
                Iterator<F> iter;
                {
                    this.iter = ConversionIterable.this.source.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public T next() {
                    return ConversionIterable.this.convert(this.iter.next());
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }

                @Override
                public void close() {
                    if (ConversionIterable.this.source instanceof CloseableIterator) {
                        ((CloseableIterator)((Object)ConversionIterable.this.source)).close();
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNDEFINED(false){

            void update(RemoteTransaction tx) {
            }
        }
        ,
        SUCCESS(false){

            void update(RemoteTransaction tx) {
                if (!tx.state.terminal) {
                    tx.state = this;
                } else {
                    tx.state.update(tx);
                }
            }

            void finish(RemoteTransaction tx) {
                tx.state = 2.COMPLETED;
                tx.commit();
            }
        }
        ,
        FAILURE(true){

            void update(RemoteTransaction tx) {
                tx.state = this;
            }
        }
        ,
        COMPLETED(true){

            void update(RemoteTransaction tx) {
                this.finish(tx);
            }

            void finish(RemoteTransaction tx) {
                throw new IllegalStateException("The transaction " + tx + " is completed.");
            }
        };

        private final boolean terminal;

        private State(boolean terminal) {
            this.terminal = terminal;
        }

        abstract void update(RemoteTransaction var1);

        void finish(RemoteTransaction tx) {
            tx.state = State.COMPLETED;
            tx.rollback();
        }
    }
}

