/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.inspect;

import java.io.PrintStream;
import org.neo4j.graphdb.Direction;
import org.neo4j.remote.RemoteResponse;
import org.neo4j.remote.inspect.CallBack;
import org.neo4j.remote.inspect.Inspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InspectionAdapter
implements Inspector {
    protected abstract <T> CallBack<T> call(Event var1, Class<T> var2, Object ... var3);

    public static final Inspector trace(final PrintStream stream) {
        return new InspectionAdapter(){

            @Override
            protected <T> CallBack<T> call(final Event call, final Class<T> type, final Object ... args) {
                if (call == Event.COMMIT) {
                    StringBuffer buffer = new StringBuffer("PREPARE_COMMIT(");
                    InspectionAdapter.appendArgs(buffer, args, Event.COMMIT.argNames);
                    buffer.append("):");
                    stream.println(buffer.toString());
                }
                return new CallBack<T>(){

                    @Override
                    public void failure(Throwable ex) {
                        call.traceFailure(stream, args, ex);
                    }

                    @Override
                    public void success(T result) {
                        if (call == Event.COMMIT) {
                            stream.println("    sucessfull.");
                        } else if (type.equals(RemoteResponse.class) || type.equals(Void.class)) {
                            call.traceSuccess(stream, args);
                        } else {
                            call.traceSuccess(stream, args, result);
                        }
                    }
                };
            }
        };
    }

    private static void appendArgs(StringBuffer buffer, Object[] args, String[] argNames) {
        boolean addComma = false;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (addComma) {
                buffer.append(", ");
            }
            if (argNames != null && i < argNames.length) {
                buffer.append(argNames[i]);
                buffer.append("=");
            }
            if (arg.getClass().isArray()) {
                buffer.append("[");
                InspectionAdapter.appendArgs(buffer, (Object[])arg, null);
                buffer.append("]");
            } else if (arg instanceof String) {
                String string = (String)arg;
                buffer.append('\"');
                buffer.append(string);
                buffer.append('\"');
            } else {
                buffer.append(arg.toString());
            }
            addComma = true;
        }
    }

    @Override
    public CallBack<Void> open() {
        return this.call(Event.OPEN, Void.class, new Object[0]);
    }

    @Override
    public CallBack<Void> close() {
        return this.call(Event.CLOSE, Void.class, new Object[0]);
    }

    @Override
    public CallBack<Integer> beginTransaction() {
        return this.call(Event.BEGIN_TRANSACTION, Integer.class, new Object[0]);
    }

    @Override
    public CallBack<RemoteResponse> createNode(int transactionId) {
        return this.call(Event.CREATE_NODE, RemoteResponse.class, transactionId);
    }

    @Override
    public CallBack<RemoteResponse> createRelationship(int transactionId, long startNodeId, long endNodeId, String relationshipTypeName) {
        return this.call(Event.CREATE_RELATIONSHIP, RemoteResponse.class, transactionId, startNodeId, endNodeId, relationshipTypeName);
    }

    @Override
    public CallBack<RemoteResponse> fetchRelationship(int transactionId, long relationshipId) {
        return this.call(Event.FETCH_RELATIONSHIP, RemoteResponse.class, transactionId, relationshipId);
    }

    @Override
    public CallBack<RemoteResponse> fetchNodeProperties(int transactionId, long nodeId) {
        return this.call(Event.FETCH_NODE_PROPERTIES, RemoteResponse.class, transactionId, nodeId);
    }

    @Override
    public CallBack<RemoteResponse> fetchRelationshipProperties(int transactionId, long relationshipId) {
        return this.call(Event.FETCH_RELATIONSHIP_PROPERTIES, RemoteResponse.class, transactionId, relationshipId);
    }

    @Override
    public CallBack<RemoteResponse> fetchRelationships(int transactionId, long rootNodeId, Direction direction, String[] typeNames) {
        return this.call(Event.FETCH_RELATIONSHIPS, RemoteResponse.class, transactionId, rootNodeId, direction, typeNames);
    }

    @Override
    public CallBack<Void> commit(int transactionId) {
        return this.call(Event.COMMIT, Void.class, transactionId);
    }

    @Override
    public CallBack<Void> rollback(int transactionId) {
        return this.call(Event.ROLLBACK, Void.class, transactionId);
    }

    @Override
    public CallBack<Void> setNodeProperty(long id, String key, Object value) {
        return this.call(Event.SET_NODE_PROPERTY, Void.class, id, key, value);
    }

    @Override
    public CallBack<Void> setRelationshipProperty(long id, String key, Object value) {
        return this.call(Event.SET_RELATIONSHIP_PROPERTY, Void.class, id, key, value);
    }

    @Override
    public CallBack<Void> deleteNode(long nodeId) {
        return this.call(Event.DELETE_NODE, Void.class, nodeId);
    }

    @Override
    public CallBack<Void> deleteRelationship(long relationshipId) {
        return this.call(Event.DELETE_RELATIONSHIP, Void.class, relationshipId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        OPEN(new String[0]),
        CLOSE(new String[0]),
        BEGIN_TRANSACTION(new String[0]),
        CREATE_NODE("tx", "id"),
        CREATE_RELATIONSHIP("tx", "start", "end", "type"),
        FETCH_RELATIONSHIP("tx", "id"),
        FETCH_NODE_PROPERTIES("tx", "id"),
        FETCH_RELATIONSHIP_PROPERTIES("tx", "id"),
        FETCH_RELATIONSHIPS("tx", "node", "direction", "types"),
        COMMIT("tx"),
        ROLLBACK("tx"),
        DELETE_NODE(true, "id"),
        DELETE_RELATIONSHIP(true, "id"),
        SET_NODE_PROPERTY(true, "id", "key", "value"),
        SET_RELATIONSHIP_PROPERTY(true, "id", "key", "value");

        private final String indentation;
        private final String[] argNames;

        private Event(String ... argNames) {
            this(false, argNames);
        }

        private Event(boolean indent, String ... argNames) {
            this.indentation = indent ? "    " : "";
            this.argNames = argNames;
        }

        private void print(PrintStream stream, String message) {
            stream.println(this.indentation + message);
        }

        private String call(Object[] args) {
            StringBuffer buffer = new StringBuffer(this.name());
            buffer.append("(");
            InspectionAdapter.appendArgs(buffer, args, this.argNames);
            buffer.append(")");
            return buffer.toString();
        }

        void traceFailure(PrintStream stream, Object[] args, Throwable ex) {
            this.print(stream, this.call(args) + " failed with exception:");
            ex.printStackTrace(stream);
        }

        void traceSuccess(PrintStream stream, Object[] args) {
            this.print(stream, this.call(args) + " sucessfull.");
        }

        void traceSuccess(PrintStream stream, Object[] args, Object result) {
            this.print(stream, this.call(args) + " sucessfully returned " + result + ".");
        }
    }
}

