/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.inspect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.RemoteConnection;
import org.neo4j.remote.inspect.CallBack;
import org.neo4j.remote.inspect.Inspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InspectionSite
implements ConnectionTarget {
    private final ConnectionTarget site;
    private final Inspector inspector;
    private static final Map<Method, Method> inspectorMethods;

    public InspectionSite(ConnectionTarget site, Inspector inspector) {
        this.site = site;
        this.inspector = inspector;
    }

    @Override
    public RemoteConnection connect() {
        return this.debugConnect(this.site.connect());
    }

    @Override
    public RemoteConnection connect(String username, String password) {
        return this.debugConnect(this.site.connect(username, password));
    }

    private RemoteConnection debugConnect(final RemoteConnection connection) {
        return (RemoteConnection)Proxy.newProxyInstance(RemoteConnection.class.getClassLoader(), new Class[]{RemoteConnection.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                DynamicCallback<?> call = InspectionSite.this.callback(method, method.getReturnType(), args);
                try {
                    Object result = method.invoke((Object)connection, args);
                    call.success(result);
                    return result;
                }
                catch (Throwable ex) {
                    call.failure(ex);
                    throw ex;
                }
            }
        });
    }

    protected <T> DynamicCallback<T> callback(Method method, Class<T> type, Object[] arguments) {
        return new DynamicCallback<T>(method, type, arguments);
    }

    private <T> CallBack<T> invoke(Method method, Class<T> returnType, Object[] arguments) {
        Method target = inspectorMethods.get(method);
        try {
            return (CallBack)target.invoke((Object)this.inspector, arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        HashMap<Method, Method> methods = new HashMap<Method, Method>();
        for (Method method : RemoteConnection.class.getMethods()) {
            try {
                methods.put(method, Inspector.class.getMethod(method.getName(), method.getParameterTypes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        inspectorMethods = Collections.unmodifiableMap(methods);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DynamicCallback<T> {
        private CallBack<T> callback;

        DynamicCallback(Method method, Class<T> type, Object[] arguments) {
            this.callback = InspectionSite.this.invoke(method, type, arguments);
        }

        void success(Object result) {
            if (this.callback != null) {
                try {
                    this.callback.success(result);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        void failure(Throwable ex) {
            if (this.callback != null) {
                try {
                    this.callback.failure(ex);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

