/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.transports;

import java.net.URI;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.Transport;

final class CorbaTransport
extends Transport {
    public CorbaTransport() {
        super("corbaname", "corbaloc");
    }

    protected ConnectionTarget create(URI resourceUri) {
        String scheme = resourceUri.getScheme();
        if ("corbaloc".equals(scheme)) {
            throw new UnsupportedOperationException("CORBA support not implemented.");
        }
        if ("corbaname".equals(scheme)) {
            throw new UnsupportedOperationException("CORBA support not implemented.");
        }
        throw new IllegalArgumentException("The resource URI \"" + resourceUri + "\" is not a CORBA URI.");
    }

    protected boolean handlesUri(URI resourceUri) {
        String scheme = resourceUri.getScheme();
        if ("corbaloc".equals(scheme)) {
            return this.isValidCorbalocUri(resourceUri);
        }
        if ("corbaname".equals(scheme)) {
            return this.isValidCorbanameUri(resourceUri);
        }
        return false;
    }

    private boolean isValidCorbalocUri(URI resourceUri) {
        return true;
    }

    private boolean isValidCorbanameUri(URI resourceUri) {
        return true;
    }
}

