/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.transports;

import java.io.File;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.index.IndexService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.remote.BasicGraphDatabaseServer;
import org.neo4j.remote.transports.GraphDbContainer;
import org.neo4j.remote.transports.LocalTransport;

public final class LocalGraphDatabase
extends BasicGraphDatabaseServer {
    final GraphDbContainer neo;

    public LocalGraphDatabase(GraphDatabaseService neo) {
        this(new GraphDbContainer(neo));
    }

    public LocalGraphDatabase(String path) {
        this(LocalTransport.getGraphDbService(new File(path)));
    }

    LocalGraphDatabase(GraphDbContainer neo) {
        super(LocalGraphDatabase.getTransactionManagerFor(neo.service));
        this.neo = neo;
    }

    protected GraphDatabaseService connectGraphDatabase() {
        return this.neo.service;
    }

    protected GraphDatabaseService connectGraphDatabase(String username, String password) {
        return this.neo.service;
    }

    public void registerIndexService(String name, IndexService index) {
        super.registerIndexService(name, index);
        this.neo.addIndexService(index);
    }

    private static TransactionManager getTransactionManagerFor(GraphDatabaseService neo) {
        if (neo instanceof EmbeddedGraphDatabase) {
            return ((EmbeddedGraphDatabase)neo).getConfig().getTxModule().getTxManager();
        }
        throw new IllegalArgumentException("Cannot get transaction manager from neo instance of class=" + neo.getClass());
    }
}

