/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.transports;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.Transport;
import org.neo4j.remote.transports.GraphDbContainer;
import org.neo4j.remote.transports.LocalGraphDatabase;

public final class LocalTransport
extends Transport {
    private static Map<String, GraphDbContainer> instances = new HashMap<String, GraphDbContainer>();

    public LocalTransport() {
        super("file");
    }

    protected ConnectionTarget create(URI resourceUri) {
        return new LocalGraphDatabase(LocalTransport.getGraphDbService(new File(resourceUri.getSchemeSpecificPart())));
    }

    protected boolean handlesUri(URI resourceUri) {
        return "file".equals(resourceUri.getScheme());
    }

    static synchronized GraphDbContainer getGraphDbService(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException ex) {
            path = file.getAbsolutePath();
        }
        GraphDbContainer neo = instances.get(path);
        if (neo == null) {
            neo = new GraphDbContainer((GraphDatabaseService)new EmbeddedGraphDatabase(path));
            Runtime.getRuntime().addShutdownHook(new Thread(neo));
            instances.put(path, neo);
        }
        return neo;
    }
}

