/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.transports;

import java.rmi.RemoteException;
import org.neo4j.graphdb.Direction;
import org.neo4j.remote.ClientConfigurator;
import org.neo4j.remote.Configuration;
import org.neo4j.remote.IterableSpecification;
import org.neo4j.remote.NodeSpecification;
import org.neo4j.remote.RelationshipSpecification;
import org.neo4j.remote.RemoteConnection;
import org.neo4j.remote.RemoteResponse;
import org.neo4j.remote.transports.RmiConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RmiConnectionAdapter
implements RemoteConnection {
    private RmiConnection rmi;

    RmiConnectionAdapter(RmiConnection rmi) {
        this.rmi = rmi;
    }

    private RmiConnection rmi() {
        if (this.rmi != null) {
            return this.rmi;
        }
        throw new IllegalStateException("Connection has been closed!");
    }

    private RuntimeException remoteException(RemoteException ex) {
        return new RuntimeException("TODO: better exception type. RMI Connection failed.", ex);
    }

    @Override
    public synchronized void close() {
        if (this.rmi != null) {
            try {
                this.rmi.close();
                this.rmi = null;
            }
            catch (RemoteException ex) {
                throw this.remoteException(ex);
            }
        }
    }

    @Override
    public ClientConfigurator configure(Configuration config) {
        try {
            return this.rmi().configure(config);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public int beginTransaction() {
        try {
            return this.rmi().beginTransaction();
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public void commit(int transactionId) {
        try {
            this.rmi().commit(transactionId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public void rollback(int transactionId) {
        try {
            this.rmi().rollback(transactionId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getRelationshipTypes(int transactionId) {
        try {
            return this.rmi().getRelationshipTypes(transactionId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getMoreRelationshipTypes(int transactionId, int requestToken) {
        try {
            return this.rmi().getMoreRelationshipTypes(transactionId, requestToken);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Void> closeRelationshipTypeIterator(int transactionId, int requestToken) {
        try {
            return this.rmi().closeRelationshipTypeIterator(transactionId, requestToken);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getAllNodes(int transactionId) {
        try {
            return this.rmi().getAllNodes(transactionId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<NodeSpecification> createNode(int transactionId) {
        try {
            return this.rmi().createNode(transactionId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<NodeSpecification> getReferenceNode(int transactionId) {
        try {
            return this.rmi().getReferenceNode(transactionId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Boolean> hasNodeWithId(int transactionId, long nodeId) {
        try {
            return this.rmi().hasNodeWithId(transactionId, nodeId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Void> deleteNode(int transactionId, long nodeId) {
        try {
            return this.rmi().deleteNode(transactionId, nodeId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getMoreNodes(int transactionId, int requestToken) {
        try {
            return this.rmi().getMoreNodes(transactionId, requestToken);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Void> closeNodeIterator(int transactionId, int requestToken) {
        try {
            return this.rmi().closeNodeIterator(transactionId, requestToken);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<RelationshipSpecification> createRelationship(int transactionId, String relationshipTypeName, long startNodeId, long endNodeId) {
        try {
            return this.rmi().createRelationship(transactionId, relationshipTypeName, startNodeId, endNodeId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<RelationshipSpecification> getRelationshipById(int transactionId, long relationshipId) {
        try {
            return this.rmi().getRelationshipById(transactionId, relationshipId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getAllRelationships(int transactionId, long nodeId, Direction direction) {
        try {
            return this.rmi().getAllRelationships(transactionId, nodeId, direction);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getRelationships(int transactionId, long nodeId, Direction direction, String[] relationshipTypeNames) {
        try {
            return this.rmi().getRelationships(transactionId, nodeId, direction, relationshipTypeNames);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getMoreRelationships(int transactionId, int requestToken) {
        try {
            return this.rmi().getMoreRelationships(transactionId, requestToken);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Void> closeRelationshipIterator(int transactionId, int requestToken) {
        try {
            return this.rmi().closeRelationshipIterator(transactionId, requestToken);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Void> deleteRelationship(int transactionId, long relationshipId) {
        try {
            return this.rmi().deleteRelationship(transactionId, relationshipId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Object> getNodeProperty(int transactionId, long nodeId, String key) {
        try {
            return this.rmi().getNodeProperty(transactionId, nodeId, key);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Object> getRelationshipProperty(int transactionId, long relationshipId, String key) {
        try {
            return this.rmi().getRelationshipProperty(transactionId, relationshipId, key);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Object> setNodeProperty(int transactionId, long nodeId, String key, Object value) {
        try {
            return this.rmi().setNodeProperty(transactionId, nodeId, key, value);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Object> setRelationshipProperty(int transactionId, long relationshipId, String key, Object value) {
        try {
            return this.rmi().setRelationshipProperty(transactionId, relationshipId, key, value);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getNodePropertyKeys(int transactionId, long nodeId) {
        try {
            return this.rmi().getNodePropertyKeys(transactionId, nodeId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getRelationshipPropertyKeys(int transactionId, long relationshipId) {
        try {
            return this.rmi().getRelationshipPropertyKeys(transactionId, relationshipId);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getMorePropertyKeys(int transactionId, int requestToken) {
        try {
            return this.rmi().getMorePropertyKeys(transactionId, requestToken);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Void> closePropertyKeyIterator(int transactionId, int requestToken) {
        try {
            return this.rmi().closePropertyKeyIterator(transactionId, requestToken);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Boolean> hasNodeProperty(int transactionId, long nodeId, String key) {
        try {
            return this.rmi().hasNodeProperty(transactionId, nodeId, key);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Boolean> hasRelationshipProperty(int transactionId, long relationshiId, String key) {
        try {
            return this.rmi().hasRelationshipProperty(transactionId, relationshiId, key);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Object> removeNodeProperty(int transactionId, long nodeId, String key) {
        try {
            return this.rmi().removeNodeProperty(transactionId, nodeId, key);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Object> removeRelationshipProperty(int transactionId, long relationshipId, String key) {
        try {
            return this.rmi().removeRelationshipProperty(transactionId, relationshipId, key);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Integer> getIndexServiceId(String indexName) {
        try {
            return this.rmi().getIndexId(indexName);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getIndexNodes(int transactionId, int indexId, String key, Object value) {
        try {
            return this.rmi().getIndexNodes(transactionId, indexId, key, value);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Void> indexNode(int transactionId, int indexId, long nodeId, String key, Object value) {
        try {
            return this.rmi().indexNode(transactionId, indexId, nodeId, key, value);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }

    @Override
    public RemoteResponse<Void> removeIndexNode(int transactionId, int indexId, long nodeId, String key, Object value) {
        try {
            return this.rmi().removeIndexNode(transactionId, indexId, nodeId, key, value);
        }
        catch (RemoteException ex) {
            throw this.remoteException(ex);
        }
    }
}

