/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.transports;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.neo4j.graphdb.Direction;
import org.neo4j.remote.BasicGraphDatabaseServer;
import org.neo4j.remote.ClientConfigurator;
import org.neo4j.remote.Configuration;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.IterableSpecification;
import org.neo4j.remote.NodeSpecification;
import org.neo4j.remote.RelationshipSpecification;
import org.neo4j.remote.RemoteConnection;
import org.neo4j.remote.RemoteResponse;
import org.neo4j.remote.transports.RmiConnection;
import org.neo4j.remote.transports.RmiRemoteTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RmiConnectionServer
extends UnicastRemoteObject
implements RmiConnection {
    private static final long serialVersionUID = 1L;
    private final transient RemoteConnection connection;

    static RmiRemoteTarget setup(BasicGraphDatabaseServer server) throws RemoteException {
        return new LoginServer(server);
    }

    static RmiRemoteTarget setup(BasicGraphDatabaseServer server, int port) throws RemoteException {
        return new LoginServer(server, port);
    }

    static RmiRemoteTarget setup(BasicGraphDatabaseServer server, int port, RMIClientSocketFactory clientSocket, RMIServerSocketFactory serverSocket) throws RemoteException {
        return new LoginServer(server, port, clientSocket, serverSocket);
    }

    private RmiConnectionServer(RemoteConnection connection, int port) throws RemoteException {
        super(port);
        this.connection = connection;
    }

    private RmiConnectionServer(RemoteConnection connection, int port, RMIClientSocketFactory client, RMIServerSocketFactory server) throws RemoteException {
        super(port, client, server);
        this.connection = connection;
    }

    @Override
    public ClientConfigurator configure(Configuration config) {
        return this.connection.configure(config);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public int beginTransaction() {
        return this.connection.beginTransaction();
    }

    @Override
    public void commit(int transactionId) {
        this.connection.commit(transactionId);
    }

    @Override
    public void rollback(int transactionId) {
        this.connection.rollback(transactionId);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getRelationshipTypes(int transactionId) {
        return this.connection.getRelationshipTypes(transactionId);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getMoreRelationshipTypes(int transactionId, int requestToken) {
        return this.connection.getMoreRelationshipTypes(transactionId, requestToken);
    }

    @Override
    public RemoteResponse<Void> closeRelationshipTypeIterator(int transactionId, int requestToken) {
        return null;
    }

    @Override
    public RemoteResponse<NodeSpecification> createNode(int transactionId) {
        return this.connection.createNode(transactionId);
    }

    @Override
    public RemoteResponse<NodeSpecification> getReferenceNode(int transactionId) {
        return this.connection.getReferenceNode(transactionId);
    }

    @Override
    public RemoteResponse<Boolean> hasNodeWithId(int transactionId, long nodeId) {
        return this.connection.hasNodeWithId(transactionId, nodeId);
    }

    @Override
    public RemoteResponse<Void> deleteNode(int transactionId, long nodeId) {
        return this.connection.deleteNode(transactionId, nodeId);
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getAllNodes(int transactionId) {
        return this.connection.getAllNodes(transactionId);
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getMoreNodes(int transactionId, int requestToken) {
        return this.connection.getMoreNodes(transactionId, requestToken);
    }

    @Override
    public RemoteResponse<Void> closeNodeIterator(int transactionId, int requestToken) {
        return null;
    }

    @Override
    public RemoteResponse<RelationshipSpecification> createRelationship(int transactionId, String relationshipTypeName, long startNodeId, long endNodeId) {
        return this.connection.createRelationship(transactionId, relationshipTypeName, startNodeId, endNodeId);
    }

    @Override
    public RemoteResponse<RelationshipSpecification> getRelationshipById(int transactionId, long relationshipId) {
        return this.connection.getRelationshipById(transactionId, relationshipId);
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getAllRelationships(int transactionId, long nodeId, Direction direction) {
        return this.connection.getAllRelationships(transactionId, nodeId, direction);
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getRelationships(int transactionId, long nodeId, Direction direction, String[] relationshipTypeNames) {
        return this.connection.getRelationships(transactionId, nodeId, direction, relationshipTypeNames);
    }

    @Override
    public RemoteResponse<IterableSpecification<RelationshipSpecification>> getMoreRelationships(int transactionId, int requestToken) {
        return this.connection.getMoreRelationships(transactionId, requestToken);
    }

    @Override
    public RemoteResponse<Void> closeRelationshipIterator(int transactionId, int requestToken) {
        return null;
    }

    @Override
    public RemoteResponse<Void> deleteRelationship(int transactionId, long relationshipId) {
        return this.connection.deleteRelationship(transactionId, relationshipId);
    }

    @Override
    public RemoteResponse<Object> getNodeProperty(int transactionId, long nodeId, String key) {
        return this.connection.getNodeProperty(transactionId, nodeId, key);
    }

    @Override
    public RemoteResponse<Object> getRelationshipProperty(int transactionId, long relationshipId, String key) {
        return this.connection.getRelationshipProperty(transactionId, relationshipId, key);
    }

    @Override
    public RemoteResponse<Object> setNodeProperty(int transactionId, long nodeId, String key, Object value) {
        return this.connection.setNodeProperty(transactionId, nodeId, key, value);
    }

    @Override
    public RemoteResponse<Object> setRelationshipProperty(int transactionId, long relationshipId, String key, Object value) {
        return this.connection.setRelationshipProperty(transactionId, relationshipId, key, value);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getNodePropertyKeys(int transactionId, long nodeId) {
        return this.connection.getNodePropertyKeys(transactionId, nodeId);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getRelationshipPropertyKeys(int transactionId, long relationshipId) {
        return this.connection.getRelationshipPropertyKeys(transactionId, relationshipId);
    }

    @Override
    public RemoteResponse<IterableSpecification<String>> getMorePropertyKeys(int transactionId, int requestToken) {
        return this.connection.getMorePropertyKeys(transactionId, requestToken);
    }

    @Override
    public RemoteResponse<Void> closePropertyKeyIterator(int transactionId, int requestToken) {
        return null;
    }

    @Override
    public RemoteResponse<Boolean> hasNodeProperty(int transactionId, long nodeId, String key) {
        return this.connection.hasNodeProperty(transactionId, nodeId, key);
    }

    @Override
    public RemoteResponse<Boolean> hasRelationshipProperty(int transactionId, long relationshiId, String key) {
        return this.connection.hasRelationshipProperty(transactionId, relationshiId, key);
    }

    @Override
    public RemoteResponse<Object> removeNodeProperty(int transactionId, long nodeId, String key) {
        return this.connection.removeNodeProperty(transactionId, nodeId, key);
    }

    @Override
    public RemoteResponse<Object> removeRelationshipProperty(int transactionId, long relationshipId, String key) {
        return this.connection.removeRelationshipProperty(transactionId, relationshipId, key);
    }

    @Override
    public RemoteResponse<Integer> getIndexId(String indexName) throws RemoteException {
        return this.connection.getIndexServiceId(indexName);
    }

    @Override
    public RemoteResponse<IterableSpecification<NodeSpecification>> getIndexNodes(int transactionId, int indexId, String key, Object value) throws RemoteException {
        return this.connection.getIndexNodes(transactionId, indexId, key, value);
    }

    @Override
    public RemoteResponse<Void> indexNode(int transactionId, int indexId, long nodeId, String key, Object value) throws RemoteException {
        return this.connection.indexNode(transactionId, indexId, nodeId, key, value);
    }

    @Override
    public RemoteResponse<Void> removeIndexNode(int transactionId, int indexId, long nodeId, String key, Object value) throws RemoteException {
        return this.connection.removeIndexNode(transactionId, indexId, nodeId, key, value);
    }

    private static class LoginServer
    extends UnicastRemoteObject
    implements RmiRemoteTarget {
        private static final long serialVersionUID = 1L;
        private final ConnectionTarget site;
        private int port = 0;
        private RMIClientSocketFactory client = null;
        private RMIServerSocketFactory server = null;

        LoginServer(ConnectionTarget site) throws RemoteException {
            this.site = site;
        }

        LoginServer(ConnectionTarget site, int port) throws RemoteException {
            super(port);
            this.port = port;
            this.site = site;
        }

        LoginServer(ConnectionTarget site, int port, RMIClientSocketFactory client, RMIServerSocketFactory server) throws RemoteException {
            super(port, client, server);
            this.site = site;
            this.port = port;
            this.client = client;
            this.server = server;
        }

        public RmiConnection connect() throws RemoteException {
            return this.connection(this.site.connect());
        }

        public RmiConnection connect(String username, String password) throws RemoteException {
            return this.connection(this.site.connect(username, password));
        }

        private RmiConnection connection(RemoteConnection connection) throws RemoteException {
            if (this.client != null) {
                return new RmiConnectionServer(connection, this.port, this.client, this.server);
            }
            return new RmiConnectionServer(connection, this.port);
        }
    }
}

