/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.transports;

import java.net.MalformedURLException;
import java.net.URI;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.RemoteConnection;
import org.neo4j.remote.transports.RmiConnection;
import org.neo4j.remote.transports.RmiConnectionAdapter;
import org.neo4j.remote.transports.RmiRemoteTarget;

final class RmiTarget
implements ConnectionTarget {
    private final URI uri;

    public RmiTarget(URI resourceUri) {
        this.uri = resourceUri;
    }

    private RmiRemoteTarget site() {
        try {
            return (RmiRemoteTarget)Naming.lookup(this.uri.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not connect to the RMI site at \"" + this.uri + "\"", e);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Could not connect to the RMI site at \"" + this.uri + "\"", e);
        }
        catch (NotBoundException e) {
            throw new RuntimeException("Could not connect to the RMI site at \"" + this.uri + "\"", e);
        }
    }

    public RemoteConnection connect() {
        RmiRemoteTarget site = this.site();
        try {
            RmiConnection rmic = site.connect();
            return new RmiConnectionAdapter(rmic);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Could not initiate connection.", e);
        }
    }

    public RemoteConnection connect(String username, String password) {
        RmiRemoteTarget site = this.site();
        try {
            RmiConnection rmic = site.connect(username, password);
            return new RmiConnectionAdapter(rmic);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Could not initiate connection.", e);
        }
    }
}

