/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.transports;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.remote.BasicGraphDatabaseServer;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.Transport;
import org.neo4j.remote.transports.LocalGraphDatabase;
import org.neo4j.remote.transports.RmiConnectionServer;
import org.neo4j.remote.transports.RmiTarget;

public final class RmiTransport
extends Transport {
    public RmiTransport() {
        super("rmi");
    }

    protected boolean handlesUri(URI resourceUri) {
        return "rmi".equals(resourceUri.getScheme());
    }

    protected ConnectionTarget create(URI resourceUri) {
        return new RmiTarget(resourceUri);
    }

    public static void register(BasicGraphDatabaseServer server, String resourceUri) throws RemoteException, MalformedURLException {
        Naming.rebind(resourceUri, RmiConnectionServer.setup(server));
    }

    public static void register(BasicGraphDatabaseServer server, String resourceUri, int port) throws RemoteException, MalformedURLException {
        Naming.rebind(resourceUri, RmiConnectionServer.setup(server, port));
    }

    public static void register(BasicGraphDatabaseServer server, String resourceUri, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException, MalformedURLException {
        Naming.rebind(resourceUri, RmiConnectionServer.setup(server, port, csf, ssf));
    }

    public static void main(String[] args) throws RemoteException, IllegalArgumentException {
        InetAddress[] localhosts;
        InetAddress localhost;
        InetAddress addr;
        URI uri;
        Method registerIndexMethod;
        Class<?> indexService;
        LocalGraphDatabase server;
        String usage = "Usage: " + RmiTarget.class.getName() + " <GraphDB dir> <rmi resource uri>";
        if (args.length < 2) {
            throw new IllegalArgumentException(usage);
        }
        try {
            server = new LocalGraphDatabase(args[0]);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException(usage, ex);
        }
        System.out.println("Created Neo4j server. Store directory: " + args[0]);
        try {
            indexService = Class.forName("org.neo4j.index.IndexService");
            registerIndexMethod = BasicGraphDatabaseServer.class.getDeclaredMethod("registerIndexService", String.class, indexService);
        }
        catch (Exception ex) {
            indexService = null;
            registerIndexMethod = null;
        }
        for (int i = 2; i < args.length; ++i) {
            if (indexService == null) {
                System.err.println("Could not instantiate index \"" + args[i] + "\"\n    The neo-index component is not loaded.");
                continue;
            }
            String[] argument = args[i].split(":", 2);
            String className = argument[0];
            String indexName = argument.length == 2 ? argument[1] : argument[0];
            try {
                Class<?> cls = Class.forName(className);
                Constructor<?> ctor = cls.getConstructor(GraphDatabaseService.class);
                Object index = ctor.newInstance(server.neo.service);
                registerIndexMethod.invoke((Object)server, indexName, index);
                System.out.println("Registered index service: " + indexName);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Could not instantiate index \"" + args[i]);
                ex.printStackTrace(System.err);
            }
        }
        try {
            uri = new URI(args[1]);
            addr = InetAddress.getByName(uri.getHost());
            localhost = InetAddress.getLocalHost();
            localhosts = InetAddress.getAllByName("localhost");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(usage, ex);
        }
        boolean addrIsLocalHost = addr.equals(localhost);
        for (InetAddress local : localhosts) {
            if (addrIsLocalHost) break;
            addrIsLocalHost = addr.equals(local);
        }
        if (addrIsLocalHost) {
            int port = uri.getPort();
            if (port == -1) {
                port = 1099;
            }
            try {
                LocateRegistry.createRegistry(port);
                System.out.println("Created RMI registry on localhost.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            RmiTransport.register(server, args[1]);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(usage, ex);
        }
        System.out.println("Neo4j RMI server registered at: " + args[1]);
        System.out.println("Press Ctrl+C to stop serving.");
    }
}

