/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.remote.transports;

import java.net.URI;
import org.neo4j.remote.ConnectionTarget;
import org.neo4j.remote.Transport;
import org.neo4j.remote.transports.CustomProtocolTarget;

final class TcpTransport
extends Transport {
    private static final int DEFAULT_PORT = 0;

    public TcpTransport() {
        super("tcp", "tcps");
    }

    protected ConnectionTarget create(URI resourceUri) {
        if (!this.handlesUri(resourceUri)) {
            throw new IllegalArgumentException("Unsupported resource URI.");
        }
        boolean useSSL = resourceUri.getScheme().equals("tcps");
        String host = resourceUri.getHost();
        int port = resourceUri.getPort();
        if (port <= 0) {
            port = 0;
        }
        return new CustomProtocolTarget(host, port, useSSL);
    }

    protected boolean handlesUri(URI resourceUri) {
        if ("tcp".equals(resourceUri.getScheme()) || "tcps".equals(resourceUri.getScheme())) {
            return resourceUri.getHost() != null && resourceUri.getRawPath() == null;
        }
        return false;
    }
}

