/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.Index;
import org.neo4j.index.IndexHits;
import org.neo4j.index.impl.SimpleIndexHits;
import org.neo4j.index.impl.btree.BTree;
import org.neo4j.index.impl.btree.KeyEntry;
import org.neo4j.kernel.EmbeddedGraphDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractIndex
implements Index {
    private static final Object GOTO_NODE = Long.MIN_VALUE;
    private static final String INDEX_NAME = "index_name";
    private static final String INDEX_KEY = "index_key";
    private static final String INDEX_TYPE = "index_type";
    protected static final String INDEX_VALUES = "index_values";
    private final Node underlyingNode;
    private BTree bTree;
    private String name;
    private GraphDatabaseService graphDb;

    protected abstract String getIndexType();

    protected abstract void addOrReplace(KeyEntry var1, long var2);

    protected abstract void addOrReplace(Node var1, long var2);

    protected abstract boolean removeAllOrOne(KeyEntry var1, long var2);

    protected abstract boolean removeAllOrOne(Node var1, long var2);

    protected abstract long[] getValues(KeyEntry var1);

    protected abstract long[] getValues(Node var1);

    protected abstract long getSingleValue(KeyEntry var1);

    protected abstract long getSingleValue(Node var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractIndex(String name, Node underlyingNode, GraphDatabaseService graphDb) {
        if (underlyingNode == null || graphDb == null) {
            throw new IllegalArgumentException("Null parameter underlyingNode=" + underlyingNode + " neo=" + graphDb);
        }
        this.underlyingNode = underlyingNode;
        this.graphDb = graphDb;
        Transaction tx = graphDb.beginTx();
        try {
            if (underlyingNode.hasProperty(INDEX_NAME)) {
                String storedName = (String)underlyingNode.getProperty(INDEX_NAME);
                if (!storedName.equals(name)) {
                    throw new IllegalArgumentException("Name of index for node=" + underlyingNode.getId() + "," + storedName + " is not same as passed in name=" + name);
                }
                if (!this.getIndexType().equals(underlyingNode.getProperty(INDEX_TYPE))) {
                    throw new IllegalArgumentException("This index is not a " + this.getIndexType() + " value index");
                }
                this.name = name;
            } else {
                underlyingNode.setProperty(INDEX_NAME, (Object)name);
                underlyingNode.setProperty(INDEX_TYPE, (Object)this.getIndexType());
                this.name = name;
            }
            Relationship bTreeRel = underlyingNode.getSingleRelationship((RelationshipType)BTree.RelTypes.TREE_ROOT, Direction.OUTGOING);
            if (bTreeRel != null) {
                this.bTree = new BTree(graphDb, bTreeRel.getEndNode());
            } else {
                Node bTreeNode = graphDb.createNode();
                underlyingNode.createRelationshipTo(bTreeNode, (RelationshipType)BTree.RelTypes.TREE_ROOT);
                this.bTree = new BTree(graphDb, bTreeNode);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public String getName() {
        return this.name;
    }

    protected Node getUnderlyingNode() {
        return this.underlyingNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(Node nodeToIndex, Object indexKey) {
        if (indexKey == null) {
            throw new IllegalArgumentException("Null index key");
        }
        if (nodeToIndex == null) {
            throw new IllegalArgumentException("Null node");
        }
        Transaction tx = this.graphDb.beginTx();
        try {
            int hashCode = indexKey.hashCode();
            long value = nodeToIndex.getId();
            KeyEntry entry = this.bTree.addIfAbsent(hashCode, value);
            if (entry != null) {
                entry.setKeyValue(indexKey);
            } else {
                entry = this.bTree.getAsKeyEntry(hashCode);
                Object goOtherNode = entry.getKeyValue();
                Node bucketNode = null;
                if (!goOtherNode.equals(GOTO_NODE)) {
                    Object prevValue = entry.getValue();
                    Object prevKey = entry.getKeyValue();
                    if (prevKey.equals(indexKey)) {
                        this.addOrReplace(entry, value);
                        tx.success();
                        return;
                    }
                    entry.setKeyValue(GOTO_NODE);
                    bucketNode = this.graphDb.createNode();
                    entry.setValue(bucketNode.getId());
                    Node prevEntry = this.graphDb.createNode();
                    bucketNode.createRelationshipTo(prevEntry, (RelationshipType)RelTypes.INDEX_ENTRY);
                    prevEntry.setProperty(INDEX_KEY, prevKey);
                    prevEntry.setProperty(INDEX_VALUES, prevValue);
                    Node newEntry = this.graphDb.createNode();
                    bucketNode.createRelationshipTo(newEntry, (RelationshipType)RelTypes.INDEX_ENTRY);
                    newEntry.setProperty(INDEX_KEY, indexKey);
                    newEntry.setProperty(INDEX_VALUES, (Object)value);
                } else {
                    bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                    for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.INDEX_ENTRY, Direction.OUTGOING)) {
                        Node entryNode = rel.getEndNode();
                        if (!entryNode.getProperty(INDEX_KEY).equals(indexKey)) continue;
                        this.addOrReplace(entryNode, value);
                        tx.success();
                        return;
                    }
                    Node newEntry = this.graphDb.createNode();
                    bucketNode.createRelationshipTo(newEntry, (RelationshipType)RelTypes.INDEX_ENTRY);
                    newEntry.setProperty(INDEX_KEY, indexKey);
                    newEntry.setProperty(INDEX_VALUES, (Object)value);
                }
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Node nodeToRemove, Object indexKey) {
        if (indexKey == null) {
            throw new IllegalArgumentException("Null index key");
        }
        if (nodeToRemove == null) {
            throw new IllegalArgumentException("Null node");
        }
        Transaction tx = this.graphDb.beginTx();
        try {
            int hashCode = indexKey.hashCode();
            KeyEntry entry = this.bTree.getAsKeyEntry(hashCode);
            if (entry != null) {
                Object goOtherNode = entry.getKeyValue();
                if (!goOtherNode.equals(GOTO_NODE)) {
                    if (goOtherNode.equals(indexKey) && this.removeAllOrOne(entry, nodeToRemove.getId())) {
                        entry.remove();
                    }
                } else {
                    Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                    for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.INDEX_ENTRY, Direction.OUTGOING)) {
                        Node entryNode = rel.getEndNode();
                        if (!entryNode.getProperty(INDEX_KEY).equals(indexKey) || !this.removeAllOrOne(entryNode, nodeToRemove.getId())) continue;
                        rel.delete();
                        entryNode.delete();
                    }
                }
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public void validate() {
        this.bTree.validateTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexHits<Node> getNodesFor(Object indexKey) {
        if (indexKey == null) {
            throw new IllegalArgumentException("Null index key");
        }
        Transaction tx = this.graphDb.beginTx();
        try {
            int hashCode = indexKey.hashCode();
            KeyEntry entry = this.bTree.getAsKeyEntry(hashCode);
            if (entry != null) {
                Object goOtherNode = entry.getKeyValue();
                if (!goOtherNode.equals(GOTO_NODE)) {
                    if (goOtherNode.equals(indexKey)) {
                        long[] nodeIds = this.getValues(entry);
                        Node[] nodes = new Node[nodeIds.length];
                        for (int i = 0; i < nodeIds.length; ++i) {
                            nodes[i] = this.graphDb.getNodeById(nodeIds[i]);
                        }
                        tx.success();
                        SimpleIndexHits<Node> i = new SimpleIndexHits<Node>(Arrays.asList(nodes), nodes.length);
                        return i;
                    }
                } else {
                    Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                    for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.INDEX_ENTRY, Direction.OUTGOING)) {
                        Node entryNode = rel.getEndNode();
                        if (!entryNode.getProperty(INDEX_KEY).equals(indexKey)) continue;
                        long[] nodeIds = this.getValues(entryNode);
                        Node[] nodes = new Node[nodeIds.length];
                        for (int i = 0; i < nodeIds.length; ++i) {
                            nodes[i] = this.graphDb.getNodeById(nodeIds[i]);
                        }
                        tx.success();
                        SimpleIndexHits<Node> simpleIndexHits = new SimpleIndexHits<Node>(Arrays.asList(nodes), nodes.length);
                        return simpleIndexHits;
                    }
                }
            }
            SimpleIndexHits<Node> simpleIndexHits = new SimpleIndexHits<Node>(Collections.emptyList(), 0);
            return simpleIndexHits;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getSingleNodeFor(Object indexKey) {
        if (indexKey == null) {
            throw new IllegalArgumentException("Null index key");
        }
        Transaction tx = this.graphDb.beginTx();
        try {
            int hashCode = indexKey.hashCode();
            KeyEntry entry = this.bTree.getAsKeyEntry(hashCode);
            if (entry != null) {
                Object goOtherNode = entry.getKeyValue();
                if (!goOtherNode.equals(GOTO_NODE)) {
                    if (goOtherNode.equals(indexKey)) {
                        long nodeId = this.getSingleValue(entry);
                        Node node = this.graphDb.getNodeById(nodeId);
                        tx.success();
                        Node node2 = node;
                        return node2;
                    }
                } else {
                    Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                    for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.INDEX_ENTRY, Direction.OUTGOING)) {
                        Node entryNode = rel.getEndNode();
                        if (!entryNode.getProperty(INDEX_KEY).equals(indexKey)) continue;
                        long nodeId = this.getSingleValue(entryNode);
                        Node node = this.graphDb.getNodeById(nodeId);
                        tx.success();
                        Node node3 = node;
                        return node3;
                    }
                }
            }
            Node node = null;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public void drop() {
        for (KeyEntry entry : this.bTree.entries()) {
            Object goOtherNode = entry.getKeyValue();
            if (!goOtherNode.equals(GOTO_NODE)) continue;
            Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
            for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.INDEX_ENTRY, Direction.OUTGOING)) {
                Node entryNode = rel.getEndNode();
                rel.delete();
                entryNode.delete();
            }
            bucketNode.delete();
        }
        this.bTree.delete();
        this.underlyingNode.delete();
    }

    @Override
    public void clear() {
        for (KeyEntry entry : this.bTree.entries()) {
            Object goOtherNode = entry.getKeyValue();
            if (!goOtherNode.equals(GOTO_NODE)) continue;
            Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
            for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.INDEX_ENTRY, Direction.OUTGOING)) {
                Node entryNode = rel.getEndNode();
                rel.delete();
                entryNode.delete();
            }
            bucketNode.delete();
        }
        this.bTree.delete();
        Node bTreeNode = this.graphDb.createNode();
        this.underlyingNode.createRelationshipTo(bTreeNode, (RelationshipType)BTree.RelTypes.TREE_ROOT);
        this.bTree = new BTree(this.graphDb, bTreeNode);
    }

    @Override
    public void drop(int commitInterval) {
        int count = 0;
        for (KeyEntry entry : this.bTree.entries()) {
            Object goOtherNode = entry.getKeyValue();
            if (goOtherNode.equals(GOTO_NODE)) {
                Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.INDEX_ENTRY, Direction.OUTGOING)) {
                    Node entryNode = rel.getEndNode();
                    rel.delete();
                    entryNode.delete();
                }
                bucketNode.delete();
            }
            if (++count < commitInterval) continue;
            try {
                ((EmbeddedGraphDatabase)this.graphDb).getConfig().getTxModule().getTxManager().getTransaction().commit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.graphDb.beginTx();
            count = 0;
        }
        this.bTree.delete(commitInterval);
        this.underlyingNode.delete();
    }

    @Override
    public Iterable<Node> values() {
        return new IndexIterator(this, this.bTree, this.graphDb);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexIterator
    implements Iterable<Node>,
    Iterator<Node> {
        private Iterator<Node> currentNodes;
        private final Iterator<KeyEntry> bTreeIterator;
        private final GraphDatabaseService graphDb;
        private final AbstractIndex index;

        private IndexIterator(AbstractIndex index, BTree bTree, GraphDatabaseService graphDb) {
            this.index = index;
            this.bTreeIterator = bTree.entries().iterator();
            this.graphDb = graphDb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.currentNodes != null && this.currentNodes.hasNext()) {
                return true;
            }
            Transaction tx = this.graphDb.beginTx();
            try {
                if (this.bTreeIterator.hasNext()) {
                    this.nextKeyEntry();
                    boolean bl = this.hasNext();
                    return bl;
                }
            }
            finally {
                tx.finish();
            }
            return false;
        }

        private void nextKeyEntry() {
            KeyEntry entry = this.bTreeIterator.next();
            Object goOtherNode = entry.getKeyValue();
            if (!goOtherNode.equals(GOTO_NODE)) {
                long[] nodeIds = this.index.getValues(entry);
                Node[] nodes = new Node[nodeIds.length];
                for (int i = 0; i < nodeIds.length; ++i) {
                    nodes[i] = this.graphDb.getNodeById(nodeIds[i]);
                }
                this.currentNodes = Arrays.asList(nodes).iterator();
            } else {
                Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                ArrayList<Node> nodeList = new ArrayList<Node>();
                for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.INDEX_ENTRY, Direction.OUTGOING)) {
                    Node entryNode = rel.getEndNode();
                    long[] nodeIds = this.index.getValues(entryNode);
                    Node[] nodes = new Node[nodeIds.length];
                    for (int i = 0; i < nodeIds.length; ++i) {
                        nodes[i] = this.graphDb.getNodeById(nodeIds[i]);
                    }
                    nodeList.addAll(Arrays.asList(nodes));
                }
                this.currentNodes = nodeList.iterator();
            }
        }

        @Override
        public Node next() {
            if (this.currentNodes == null || !this.currentNodes.hasNext()) {
                this.nextKeyEntry();
            }
            return this.currentNodes.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Node> iterator() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelTypes implements RelationshipType
    {
        INDEX_ENTRY;

    }
}

