/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl;

import java.util.Iterator;
import org.neo4j.commons.iterator.PrefetchingIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdToNodeIterator
extends PrefetchingIterator<Node> {
    private final Iterator<Long> ids;
    private final GraphDatabaseService graphDb;

    public IdToNodeIterator(Iterator<Long> ids, GraphDatabaseService graphDb) {
        this.ids = ids;
        this.graphDb = graphDb;
    }

    protected Node fetchNextOrNull() {
        Node result = null;
        while (result == null) {
            if (!this.ids.hasNext()) {
                return null;
            }
            long id = this.ids.next();
            try {
                return this.graphDb.getNodeById(id);
            }
            catch (NotFoundException e) {
            }
        }
        return result;
    }
}

