/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.Isolation;
import org.neo4j.index.impl.GenericIndexService;

public class IndexServiceQueue
extends Thread {
    private final GenericIndexService indexService;
    private final ConcurrentLinkedQueue<QueueElement> queue = new ConcurrentLinkedQueue();
    private final ArrayList<QueueElement> nonCommittedElements = new ArrayList();
    private static final int MAX_TX_OPERATION_COUNT = 100;
    private static final long MAX_WAIT_TIME = 600L;
    private static final int MAX_ERROR_COUNT = 3;
    private static final int MAX_PENDING_OPERATIONS = 1000;
    private boolean run = true;
    private int txOperationCount = 0;
    private long lastCommit;
    private long currentTimestamp;
    private Transaction tx;
    private boolean done = false;

    IndexServiceQueue(GenericIndexService service) {
        super("IndexServiceQueue");
        this.indexService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueIndex(Isolation level, Node node, String key, Object value) {
        if (level == Isolation.ASYNC_OTHER_TX) {
            QueueElement qe = new QueueElement(Operation.ADD, node, key, value);
            this.queue.add(qe);
            IndexServiceQueue indexServiceQueue = this;
            synchronized (indexServiceQueue) {
                this.notify();
            }
            if (this.nonCommittedElements.size() >= 1000) {
                this.waitForQueueElementNotify(qe);
            }
        } else if (level == Isolation.SYNC_OTHER_TX) {
            QueueElement qe = new QueueElement(Operation.ADD, node, key, value);
            this.queue.add(qe);
            IndexServiceQueue indexServiceQueue = this;
            synchronized (indexServiceQueue) {
                this.notify();
            }
            this.waitForQueueElementNotify(qe);
        } else {
            throw new IllegalArgumentException("Wrong isolation " + (Object)((Object)level));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueRemove(Isolation level, Node node, String key, Object value) {
        if (level == Isolation.ASYNC_OTHER_TX) {
            QueueElement qe = new QueueElement(Operation.REMOVE, node, key, value);
            this.queue.add(qe);
            IndexServiceQueue indexServiceQueue = this;
            synchronized (indexServiceQueue) {
                this.notify();
            }
            if (this.nonCommittedElements.size() >= 1000) {
                this.waitForQueueElementNotify(qe);
            }
        } else if (level == Isolation.SYNC_OTHER_TX) {
            QueueElement qe = new QueueElement(Operation.REMOVE, node, key, value);
            this.queue.add(qe);
            IndexServiceQueue indexServiceQueue = this;
            synchronized (indexServiceQueue) {
                this.notify();
            }
            this.waitForQueueElementNotify(qe);
        } else {
            throw new IllegalArgumentException("Wrong isolation " + (Object)((Object)level));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueueElementNotify(QueueElement qe) {
        do {
            try {
                QueueElement queueElement = qe;
                synchronized (queueElement) {
                    qe.wait(100L);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        } while (!qe.indexed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.tx = this.indexService.beginTx();
        this.lastCommit = System.currentTimeMillis();
        try {
            while (this.run || !this.queue.isEmpty()) {
                QueueElement qe = this.queue.poll();
                try {
                    if (qe != null) {
                        this.performIndexOperation(qe);
                        continue;
                    }
                    IndexServiceQueue indexServiceQueue = this;
                    synchronized (indexServiceQueue) {
                        this.wait(100L);
                    }
                    this.currentTimestamp = System.currentTimeMillis();
                    if (this.currentTimestamp - this.lastCommit <= 600L) continue;
                    this.tx.success();
                    this.tx.finish();
                    this.tx = this.indexService.beginTx();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            this.tx.success();
        }
        finally {
            this.done = true;
            this.tx.finish();
        }
        GenericIndexService genericIndexService = this.indexService;
        synchronized (genericIndexService) {
            this.indexService.notify();
            return;
        }
    }

    private void performIndexOperation(QueueElement qe) {
        if (qe.operation == Operation.ADD) {
            this.indexService.indexThisTx(qe.node, qe.key, qe.value);
        } else if (qe.operation == Operation.REMOVE) {
            this.indexService.removeIndexThisTx(qe.node, qe.key, qe.value);
        }
        this.nonCommittedElements.add(qe);
        ++this.txOperationCount;
        this.checkForCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForCommit() {
        if (this.txOperationCount >= 100 || this.currentTimestamp - this.lastCommit >= 600L) {
            this.tx.success();
            try {
                this.lastCommit = System.currentTimeMillis();
                this.tx.finish();
                for (QueueElement doneElement : this.nonCommittedElements) {
                    doneElement.setIndexed();
                    QueueElement queueElement = doneElement;
                    synchronized (queueElement) {
                        doneElement.notify();
                    }
                }
                this.nonCommittedElements.clear();
            }
            catch (Throwable t) {
                this.handleError(t);
            }
            this.tx = this.indexService.beginTx();
        }
    }

    private void handleError(Throwable t) {
        System.out.println("Problem with current index batch[" + t + "] retrying...");
        for (QueueElement qe : this.nonCommittedElements) {
            qe.tickError();
            if (qe.getErrorCount() >= 3) {
                this.reportError(qe);
            }
            this.queue.add(qe);
        }
        this.nonCommittedElements.clear();
    }

    private void reportError(QueueElement qe) {
        System.out.println("Unable to perform indexing operation: " + (Object)((Object)qe.operation) + " " + qe.node + " " + qe.key + "," + qe.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopRunning() {
        this.run = false;
        GenericIndexService genericIndexService = this.indexService;
        synchronized (genericIndexService) {
            while (!this.done) {
                try {
                    this.indexService.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
    }

    private static class QueueElement {
        final Operation operation;
        final Node node;
        final String key;
        final Object value;
        private volatile boolean indexed = false;
        private int errorCount = 0;

        QueueElement(Operation operation, Node node, String key, Object value) {
            this.operation = operation;
            this.node = node;
            this.key = key;
            this.value = value;
        }

        boolean indexed() {
            return this.indexed;
        }

        void setIndexed() {
            this.indexed = true;
        }

        void tickError() {
            ++this.errorCount;
        }

        int getErrorCount() {
            return this.errorCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        ADD,
        REMOVE;

    }
}

