/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.neo4j.commons.iterator.PrefetchingIterator;
import org.neo4j.index.lucene.HitsIterator;
import org.neo4j.index.lucene.IndexSearcherRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocToIdIterator
extends PrefetchingIterator<Long> {
    private final Iterator<Document> docs;
    private final Collection<Long> exclude;
    private final IndexSearcherRef searcherOrNull;
    private final Set<Long> alreadyReturnedIds = new HashSet<Long>();

    DocToIdIterator(Iterator<Document> docs, Collection<Long> exclude, IndexSearcherRef searcherOrNull) {
        this.docs = docs;
        this.exclude = exclude;
        this.searcherOrNull = searcherOrNull;
    }

    protected Long fetchNextOrNull() {
        Long result = null;
        while (result == null) {
            if (!this.docs.hasNext()) {
                this.endReached();
                break;
            }
            Document doc = this.docs.next();
            long id = Long.parseLong(doc.getField("id").stringValue());
            if (this.exclude.contains(id) || !this.alreadyReturnedIds.add(id)) continue;
            result = id;
        }
        return result;
    }

    private void endReached() {
        if (this.searcherOrNull != null) {
            this.searcherOrNull.closeStrict();
        }
    }

    public int size() {
        return ((HitsIterator)((Object)this.docs)).size();
    }
}

