/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.neo4j.graphdb.Node;
import org.neo4j.index.lucene.LuceneDataSource;
import org.neo4j.index.lucene.LuceneTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneFulltextTransaction
extends LuceneTransaction {
    private final Map<String, DirectoryAndWorkers> fulltextIndexed = new HashMap<String, DirectoryAndWorkers>();
    private final Map<String, DirectoryAndWorkers> fulltextRemoved = new HashMap<String, DirectoryAndWorkers>();

    LuceneFulltextTransaction(int identifier, XaLogicalLog xaLog, LuceneDataSource luceneDs) {
        super(identifier, xaLog, luceneDs);
    }

    private DirectoryAndWorkers getDirectory(Map<String, DirectoryAndWorkers> map, String key) {
        DirectoryAndWorkers result = map.get(key);
        if (result == null) {
            RAMDirectory directory = new RAMDirectory();
            try {
                IndexWriter writer = new IndexWriter((Directory)directory, this.getDataSource().getAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
                writer.close();
                result = new DirectoryAndWorkers((Directory)directory);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            map.put(key, result);
        }
        return result;
    }

    private IndexWriter newIndexWriter(Directory directory) throws IOException {
        return new IndexWriter(directory, this.getDataSource().getAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
    }

    private void insertAndRemove(DirectoryAndWorkers insertTo, DirectoryAndWorkers removeFrom, Node node, String key, Object value) {
        try {
            BooleanQuery deletionQuery = new BooleanQuery();
            deletionQuery.add((Query)new TermQuery(new Term(this.getDataSource().getDeleteDocumentsKey(), value.toString())), BooleanClause.Occur.MUST);
            deletionQuery.add((Query)new TermQuery(new Term("id", "" + node.getId())), BooleanClause.Occur.MUST);
            removeFrom.writer.deleteDocuments((Query)deletionQuery);
            removeFrom.invalidateSearcher();
            Document document = new Document();
            this.getDataSource().fillDocument(document, node.getId(), key, value);
            insertTo.writer.addDocument(document);
            insertTo.invalidateSearcher();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void index(Node node, String key, Object value) {
        super.index(node, key, value);
        this.insertAndRemove(this.getDirectory(this.fulltextIndexed, key), this.getDirectory(this.fulltextRemoved, key), node, key, value);
    }

    @Override
    void removeIndex(Node node, String key, Object value) {
        super.removeIndex(node, key, value);
        this.insertAndRemove(this.getDirectory(this.fulltextRemoved, key), this.getDirectory(this.fulltextIndexed, key), node, key, value);
    }

    @Override
    Set<Long> getDeletedNodesFor(String key, Object value) {
        return this.getNodes(this.getDirectory(this.fulltextRemoved, key), key, value);
    }

    @Override
    Set<Long> getNodesFor(String key, Object value) {
        return this.getNodes(this.getDirectory(this.fulltextIndexed, key), key, value);
    }

    private Set<Long> getNodes(DirectoryAndWorkers directory, String key, Object value) {
        try {
            IndexSearcher searcher = directory.getSearcher();
            Hits hits = searcher.search(this.getDataSource().getIndexService().formQuery(key, value));
            HashSet<Long> result = new HashSet<Long>();
            for (int i = 0; i < hits.length(); ++i) {
                result.add(Long.parseLong(hits.doc(i).getField("id").stringValue()));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doCommit() {
        for (DirectoryAndWorkers directory : this.fulltextIndexed.values()) {
            directory.close();
        }
        for (DirectoryAndWorkers directory : this.fulltextRemoved.values()) {
            directory.close();
        }
        super.doCommit();
    }

    private class DirectoryAndWorkers {
        private final Directory directory;
        private final IndexWriter writer;
        private IndexSearcher searcher;

        private DirectoryAndWorkers(Directory directory) throws IOException {
            this.directory = directory;
            this.writer = LuceneFulltextTransaction.this.newIndexWriter(directory);
        }

        private void safeClose(Object object) {
            if (object == null) {
                return;
            }
            try {
                if (object instanceof IndexWriter) {
                    ((IndexWriter)object).close();
                } else if (object instanceof IndexSearcher) {
                    ((IndexSearcher)object).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void invalidateSearcher() {
            this.safeClose(this.searcher);
            this.searcher = null;
        }

        private void close() {
            this.safeClose(this.writer);
            this.invalidateSearcher();
        }

        private IndexSearcher getSearcher() {
            try {
                this.writer.commit();
                if (this.searcher == null) {
                    this.searcher = new IndexSearcher(this.directory, true);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.searcher;
        }
    }
}

