/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;

class LuceneIndexStore {
    private long creationTime;
    private long randomIdentifier;
    private long version;
    private final FileChannel fileChannel;
    private final ByteBuffer buf = ByteBuffer.allocate(24);

    public LuceneIndexStore(String store) {
        if (!new File(store).exists()) {
            LuceneIndexStore.create(store);
        }
        try {
            this.fileChannel = new RandomAccessFile(store, "rw").getChannel();
            if (this.fileChannel.read(this.buf) != 24) {
                throw new RuntimeException("Expected to read 24 bytes");
            }
            this.buf.flip();
            this.creationTime = this.buf.getLong();
            this.randomIdentifier = this.buf.getLong();
            this.version = this.buf.getLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void create(String store) {
        if (new File(store).exists()) {
            throw new IllegalArgumentException(store + " already exist");
        }
        try {
            FileChannel fileChannel = new RandomAccessFile(store, "rw").getChannel();
            ByteBuffer buf = ByteBuffer.allocate(24);
            long time = System.currentTimeMillis();
            long identifier = new Random(time).nextLong();
            buf.putLong(time).putLong(identifier).putLong(0L);
            buf.flip();
            if (fileChannel.write(buf) != 24) {
                throw new RuntimeException("Expected to write 24 bytes");
            }
            fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomNumber() {
        return this.randomIdentifier;
    }

    public long getVersion() {
        return this.version;
    }

    public synchronized long incrementVersion() {
        long current = this.getVersion();
        ++this.version;
        this.writeOut();
        return current;
    }

    public synchronized void setVersion(long version) {
        this.version = version;
        this.writeOut();
    }

    private void writeOut() {
        this.buf.clear();
        this.buf.putLong(this.creationTime).putLong(this.randomIdentifier).putLong(this.version);
        this.buf.flip();
        try {
            if (this.fileChannel.write(this.buf, 0L) != 24) {
                throw new RuntimeException("Expected to write 24 bytes");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!this.fileChannel.isOpen()) {
            return;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

