/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.neo4j.graphdb.Node;
import org.neo4j.index.lucene.LuceneCommand;
import org.neo4j.index.lucene.LuceneDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneTransaction
extends XaTransaction {
    private final Map<String, Map<Object, Set<Long>>> txIndexed = new HashMap<String, Map<Object, Set<Long>>>();
    private final Map<String, Map<Object, Set<Long>>> txRemoved = new HashMap<String, Map<Object, Set<Long>>>();
    private final LuceneDataSource luceneDs;
    private final Map<String, List<LuceneCommand>> commandMap = new HashMap<String, List<LuceneCommand>>();

    LuceneTransaction(int identifier, XaLogicalLog xaLog, LuceneDataSource luceneDs) {
        super(identifier, xaLog);
        this.luceneDs = luceneDs;
    }

    void index(Node node, String key, Object value) {
        this.insert(node, key, value, this.txRemoved, this.txIndexed);
    }

    void removeIndex(Node node, String key, Object value) {
        this.insert(node, key, value, this.txIndexed, this.txRemoved);
    }

    private void insert(Node node, String key, Object value, Map<String, Map<Object, Set<Long>>> toRemoveFrom, Map<String, Map<Object, Set<Long>>> toInsertInto) {
        Set<Long> nodeIds;
        this.delFromIndex(node, key, value, toRemoveFrom);
        Map<Object, Set<Long>> keyIndex = toInsertInto.get(key);
        if (keyIndex == null) {
            keyIndex = new HashMap<Object, Set<Long>>();
            toInsertInto.put(key, keyIndex);
        }
        if ((nodeIds = keyIndex.get(value)) == null) {
            nodeIds = new HashSet<Long>();
        }
        nodeIds.add(node.getId());
        keyIndex.put(value, nodeIds);
    }

    private boolean delFromIndex(Node node, String key, Object value, Map<String, Map<Object, Set<Long>>> map) {
        Map<Object, Set<Long>> keyIndex = map.get(key);
        if (keyIndex == null) {
            return false;
        }
        Set<Long> nodeIds = keyIndex.get(value);
        if (nodeIds != null) {
            return nodeIds.remove(node.getId());
        }
        return false;
    }

    Set<Long> getDeletedNodesFor(String key, Object value) {
        Set<Long> nodeIds;
        Map<Object, Set<Long>> keyIndex = this.txRemoved.get(key);
        if (keyIndex != null && (nodeIds = keyIndex.get(value)) != null) {
            return nodeIds;
        }
        return Collections.emptySet();
    }

    Set<Long> getNodesFor(String key, Object value) {
        Set<Long> nodeIds;
        Map<Object, Set<Long>> keyIndex = this.txIndexed.get(key);
        if (keyIndex != null && (nodeIds = keyIndex.get(value)) != null) {
            return nodeIds;
        }
        return Collections.emptySet();
    }

    protected LuceneDataSource getDataSource() {
        return this.luceneDs;
    }

    private void indexWriter(IndexWriter writer, long nodeId, String key, Object value) {
        Document document = new Document();
        this.luceneDs.fillDocument(document, nodeId, key, value);
        try {
            writer.addDocument(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doAddCommand(XaCommand command) {
        LuceneCommand luceneCommand = (LuceneCommand)command;
        String key = luceneCommand.getKey();
        List<LuceneCommand> list = this.commandMap.get(key);
        if (list == null) {
            list = new ArrayList<LuceneCommand>();
            this.commandMap.put(key, list);
        }
        list.add(luceneCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() {
        this.luceneDs.getWriteLock();
        try {
            for (Map.Entry<String, List<LuceneCommand>> entry : this.commandMap.entrySet()) {
                String key = entry.getKey();
                IndexWriter writer = this.luceneDs.getIndexWriter(key);
                for (LuceneCommand command : entry.getValue()) {
                    if (command instanceof LuceneCommand.AddCommand) {
                        this.indexWriter(writer, command.getNodeId(), key, command.getValue());
                    } else if (command instanceof LuceneCommand.RemoveCommand) {
                        this.luceneDs.deleteDocumentsUsingWriter(writer, command.getNodeId(), command.getValue());
                    } else {
                        throw new RuntimeException("Unknown command type " + (Object)((Object)command) + ", " + ((Object)((Object)command)).getClass());
                    }
                    this.luceneDs.invalidateCache(key, command.getValue());
                }
                this.luceneDs.removeWriter(key, writer);
                this.luceneDs.invalidateIndexSearcher(key);
            }
        }
        finally {
            this.luceneDs.releaseWriteLock();
        }
    }

    protected void doPrepare() {
        for (String key : this.txIndexed.keySet()) {
            Map<Object, Set<Long>> addIndex = this.txIndexed.get(key);
            for (Object object : addIndex.keySet()) {
                for (long id : addIndex.get(object)) {
                    this.addCommand(new LuceneCommand.AddCommand(id, key, object.toString()));
                }
            }
        }
        for (String key : this.txRemoved.keySet()) {
            Map<Object, Set<Long>> removeIndex = this.txRemoved.get(key);
            for (Object object : removeIndex.keySet()) {
                for (long id : removeIndex.get(object)) {
                    this.addCommand(new LuceneCommand.RemoveCommand(id, key, object.toString()));
                }
            }
        }
    }

    protected void doRollback() {
        this.commandMap.clear();
        this.txIndexed.clear();
        this.txRemoved.clear();
    }

    public boolean isReadOnly() {
        return false;
    }
}

