/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphmatching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphmatching.ValueMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPatternObject<T extends PropertyContainer> {
    private T assocication;
    private Map<String, Collection<ValueMatcher>> constrains = new HashMap<String, Collection<ValueMatcher>>();

    AbstractPatternObject() {
    }

    public void addPropertyConstraint(String propertyKey, ValueMatcher matcher) {
        Collection<ValueMatcher> matchers = this.constrains.get(propertyKey);
        if (matchers == null) {
            matchers = new ArrayList<ValueMatcher>();
            this.constrains.put(propertyKey, matchers);
        }
        matchers.add(matcher);
    }

    public void setAssociation(T object) {
        this.assocication = object;
    }

    public T getAssociation() {
        return this.assocication;
    }

    public Iterable<Map.Entry<String, Collection<ValueMatcher>>> getPropertyConstraints() {
        Set<Map.Entry<String, Collection<ValueMatcher>>> matchers = this.constrains.entrySet();
        return matchers != null ? matchers : Collections.emptyList();
    }
}

