/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphmatching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphmatching.PatternElement;
import org.neo4j.graphmatching.PatternFinder;
import org.neo4j.graphmatching.PatternMatch;
import org.neo4j.graphmatching.PatternMatcher;
import org.neo4j.graphmatching.PatternNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionalPatternFinder {
    private List<PatternFinder> optionalFinders;
    private List<PatternMatch> currentMatches;
    private Collection<PatternNode> optionalNodes;
    private PatternMatch baseMatch;
    private int position = -1;
    private final PatternMatcher matcher;
    private boolean first = true;

    OptionalPatternFinder(PatternMatcher matcher, PatternMatch baseMatch, Collection<PatternNode> optionalNodes) {
        this.matcher = matcher;
        this.baseMatch = baseMatch;
        this.optionalNodes = optionalNodes;
        this.initialize();
    }

    PatternMatch findNextOptionalPatterns() {
        if (this.position < 0) {
            return null;
        }
        if (this.first && this.anyMatchFound()) {
            this.first = false;
            return PatternMatch.merge(this.currentMatches);
        }
        boolean found = false;
        while (this.position >= 0) {
            if (this.optionalFinders.get(this.position).hasNext()) {
                this.currentMatches.set(this.position, this.optionalFinders.get(this.position).next());
                if (this.position < this.currentMatches.size() - 1) {
                    ++this.position;
                    this.reset(this.position);
                }
                found = true;
                break;
            }
            --this.position;
        }
        if (!found) {
            return null;
        }
        return PatternMatch.merge(this.currentMatches);
    }

    boolean anyMatchFound() {
        return !this.currentMatches.isEmpty();
    }

    private void initialize() {
        this.optionalFinders = new ArrayList<PatternFinder>();
        this.currentMatches = new ArrayList<PatternMatch>();
        for (PatternNode node : this.optionalNodes) {
            PatternFinder finder = new PatternFinder(this.matcher, node, this.getNodeFor(node), true);
            if (!finder.hasNext()) continue;
            this.optionalFinders.add(finder);
            this.currentMatches.add(finder.next());
            ++this.position;
        }
    }

    private Node getNodeFor(PatternNode node) {
        for (PatternElement element : this.baseMatch.getElements()) {
            if (!node.getLabel().equals(element.getPatternNode().getLabel())) continue;
            return element.getNode();
        }
        throw new RuntimeException("Optional graph isn't connected to the main graph.");
    }

    private void reset(int fromIndex) {
        int i = fromIndex;
        while (i < this.optionalFinders.size()) {
            PatternFinder finder = this.optionalFinders.get(i);
            PatternFinder newFinder = new PatternFinder(this.matcher, finder.getStartPatternNode(), finder.getStartNode(), true);
            this.optionalFinders.set(i, newFinder);
            this.currentMatches.set(i, newFinder.next());
            this.position = i++;
        }
    }
}

