/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphmatching;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphmatching.PatternElement;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.graphmatching.PatternRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatch {
    private Map<PatternNode, PatternElement> elements = new HashMap<PatternNode, PatternElement>();
    private Map<PatternRelationship, Relationship> relElements = new HashMap<PatternRelationship, Relationship>();

    PatternMatch(Map<PatternNode, PatternElement> elements, Map<PatternRelationship, Relationship> relElements) {
        this.elements = elements;
        this.relElements = relElements;
    }

    public Node getNodeFor(PatternNode node) {
        return this.elements.containsKey(node) ? this.elements.get(node).getNode() : null;
    }

    public Relationship getRelationshipFor(PatternRelationship rel) {
        return this.relElements.containsKey(rel) ? this.relElements.get(rel) : null;
    }

    public Iterable<PatternElement> getElements() {
        return this.elements.values();
    }

    public static PatternMatch merge(Iterable<PatternMatch> matches) {
        HashMap<PatternNode, PatternElement> matchMap = new HashMap<PatternNode, PatternElement>();
        HashMap<PatternRelationship, Relationship> relElements = new HashMap<PatternRelationship, Relationship>();
        for (PatternMatch match : matches) {
            for (PatternNode node : match.elements.keySet()) {
                boolean exists = false;
                for (PatternNode existingNode : matchMap.keySet()) {
                    if (!node.getLabel().equals(existingNode.getLabel())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                matchMap.put(node, match.elements.get(node));
                relElements.put(match.elements.get(node).getFromPatternRelationship(), match.elements.get(node).getFromRelationship());
            }
        }
        PatternMatch mergedMatch = new PatternMatch(matchMap, relElements);
        return mergedMatch;
    }

    public static PatternMatch merge(PatternMatch ... matches) {
        return PatternMatch.merge(Arrays.asList(matches));
    }
}

