/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphmatching;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.graphmatching.PatternRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternUtil {
    public static void printGraph(PatternNode startNode, PrintStream out) {
        PatternUtil.printGraph(startNode, "", new HashSet<PatternNode>(), out);
    }

    private static void printGraph(PatternNode startNode, String prefix, Set<PatternNode> visited, PrintStream out) {
        visited.add(startNode);
        out.println(prefix + startNode + ": ");
        for (PatternRelationship relationship : startNode.getAllRelationships()) {
            out.print(prefix + "\t" + relationship);
            out.println(": " + relationship.getOtherNode(startNode));
            if (visited.contains(relationship.getOtherNode(startNode))) continue;
            PatternUtil.printGraph(relationship.getOtherNode(startNode), prefix + "\t\t", visited, out);
        }
    }
}

