/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.Serializable;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDbImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedGraphDatabase
implements GraphDatabaseService {
    private final EmbeddedGraphDbImpl neoImpl;

    public EmbeddedGraphDatabase(String storeDir) {
        this.neoImpl = new EmbeddedGraphDbImpl(storeDir, this);
    }

    public EmbeddedGraphDatabase(String storeDir, Map<String, String> params) {
        this.neoImpl = new EmbeddedGraphDbImpl(storeDir, params, this);
    }

    public static Map<String, String> loadConfigurations(String file) {
        return EmbeddedGraphDbImpl.loadConfigurations(file);
    }

    @Override
    public Node createNode() {
        return this.neoImpl.createNode();
    }

    @Override
    public Node getNodeById(long id) {
        return this.neoImpl.getNodeById(id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.neoImpl.getRelationshipById(id);
    }

    @Override
    public Node getReferenceNode() {
        return this.neoImpl.getReferenceNode();
    }

    @Override
    public void shutdown() {
        this.neoImpl.shutdown();
    }

    @Override
    public boolean enableRemoteShell() {
        return this.neoImpl.enableRemoteShell();
    }

    @Override
    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return this.neoImpl.enableRemoteShell(initialProperties);
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.neoImpl.getRelationshipTypes();
    }

    @Override
    public Transaction beginTx() {
        return this.neoImpl.beginTx();
    }

    public Config getConfig() {
        return this.neoImpl.getConfig();
    }

    public String toString() {
        return super.toString() + " [" + this.neoImpl.getStoreDir() + "]";
    }

    public String getStoreDir() {
        return this.neoImpl.getStoreDir();
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return this.neoImpl.getAllNodes();
    }
}

