/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.GraphDbInstance;
import org.neo4j.kernel.ShellService;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.TransactionFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbeddedGraphDbImpl {
    private static Logger log = Logger.getLogger(EmbeddedGraphDbImpl.class.getName());
    private ShellService shellService;
    private Transaction placeboTransaction = null;
    private final GraphDbInstance graphDbInstance;
    private final GraphDatabaseService graphDbService;
    private final NodeManager nodeManager;
    private final String storeDir;

    public EmbeddedGraphDbImpl(String storeDir, GraphDatabaseService graphDbService) {
        this.storeDir = storeDir;
        this.graphDbInstance = new GraphDbInstance(storeDir, true);
        this.graphDbInstance.start();
        this.nodeManager = this.graphDbInstance.getConfig().getNeoModule().getNodeManager();
        this.graphDbService = graphDbService;
    }

    public EmbeddedGraphDbImpl(String storeDir, Map<String, String> params, GraphDatabaseService graphDbService) {
        this.storeDir = storeDir;
        this.graphDbInstance = new GraphDbInstance(storeDir, true);
        this.graphDbInstance.start(params);
        this.nodeManager = this.graphDbInstance.getConfig().getNeoModule().getNodeManager();
        this.graphDbService = graphDbService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadConfigurations(String file) {
        Properties props = new Properties();
        try {
            FileInputStream stream = new FileInputStream(new File(file));
            try {
                props.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load " + file, e);
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        HashMap<String, String> stringProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            stringProps.put(key, value);
        }
        return stringProps;
    }

    public Node createNode() {
        return this.nodeManager.createNode();
    }

    public Node getNodeById(long id) {
        if (id < 0L || id > 0xFFFFFFFEL) {
            throw new NotFoundException("Node[" + id + "]");
        }
        return this.nodeManager.getNodeById((int)id);
    }

    public Relationship getRelationshipById(long id) {
        if (id < 0L || id > 0xFFFFFFFEL) {
            throw new NotFoundException("Relationship[" + id + "]");
        }
        return this.nodeManager.getRelationshipById((int)id);
    }

    public Node getReferenceNode() {
        return this.nodeManager.getReferenceNode();
    }

    public void shutdown() {
        if (this.shellService != null) {
            try {
                this.shellService.shutdown();
            }
            catch (Throwable t) {
                log.warning("Error shutting down shell server: " + t);
            }
        }
        this.graphDbInstance.shutdown();
    }

    public boolean enableRemoteShell() {
        return this.enableRemoteShell(null);
    }

    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        if (this.shellService != null) {
            throw new IllegalStateException("Shell already enabled");
        }
        Map<String, Serializable> properties = initialProperties;
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        try {
            this.shellService = new ShellService(this.graphDbService, properties);
            return true;
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Can't start remote Neo4j shell", e);
        }
        catch (ShellService.ShellNotAvailableException e) {
            log.info("Shell library not available. Neo4j shell not started. Please add the Neo4j shell jar to the classpath.");
            e.printStackTrace();
            return false;
        }
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.graphDbInstance.getRelationshipTypes();
    }

    public Transaction beginTx() {
        if (this.graphDbInstance.transactionRunning()) {
            if (this.placeboTransaction == null) {
                this.placeboTransaction = new PlaceboTransaction(this.graphDbInstance.getTransactionManager());
            }
            return this.placeboTransaction;
        }
        TransactionManager txManager = this.graphDbInstance.getTransactionManager();
        try {
            txManager.begin();
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to begin transaction", e);
        }
        return new TransactionImpl(txManager);
    }

    public Config getConfig() {
        return this.graphDbInstance.getConfig();
    }

    public String toString() {
        return super.toString() + " [" + this.storeDir + "]";
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public Iterable<Node> getAllNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                long highId = EmbeddedGraphDbImpl.this.nodeManager.getHighestPossibleIdInUse(Node.class) & 0xFFFFFFFFL;
                return new AllNodesIterator(highId);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllNodesIterator
    implements Iterator<Node> {
        private final long highId;
        private long currentNodeId = 0L;
        private Node currentNode = null;

        AllNodesIterator(long highId) {
            this.highId = highId;
        }

        @Override
        public synchronized boolean hasNext() {
            while (this.currentNode == null && this.currentNodeId <= this.highId) {
                try {
                    this.currentNode = EmbeddedGraphDbImpl.this.getNodeById(this.currentNodeId++);
                }
                catch (NotFoundException notFoundException) {}
            }
            return this.currentNode != null;
        }

        @Override
        public synchronized Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node nextNode = this.currentNode;
            this.currentNode = null;
            return nextNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class TransactionImpl
    implements Transaction {
        private boolean success = false;
        private final TransactionManager transactionManager;

        TransactionImpl(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public void failure() {
            this.success = false;
            try {
                this.transactionManager.getTransaction().setRollbackOnly();
            }
            catch (Exception e) {
                throw new TransactionFailureException("Failed to mark transaction as rollback only.", e);
            }
        }

        public void success() {
            this.success = true;
        }

        public void finish() {
            try {
                if (this.success) {
                    if (this.transactionManager.getTransaction() != null) {
                        this.transactionManager.getTransaction().commit();
                    }
                } else if (this.transactionManager.getTransaction() != null) {
                    this.transactionManager.getTransaction().rollback();
                }
            }
            catch (Exception e) {
                if (this.success) {
                    throw new TransactionFailureException("Unable to commit transaction", e);
                }
                throw new TransactionFailureException("Unable to rollback transaction", e);
            }
        }
    }

    private static class PlaceboTransaction
    implements Transaction {
        private final TransactionManager transactionManager;

        PlaceboTransaction(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public void failure() {
            try {
                this.transactionManager.getTransaction().setRollbackOnly();
            }
            catch (Exception e) {
                throw new TransactionFailureException("Failed to mark transaction as rollback only.", e);
            }
        }

        public void success() {
        }

        public void finish() {
        }
    }
}

