/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShellService {
    private final GraphDatabaseService graphDb;
    private final Object shellServer;

    ShellService(GraphDatabaseService neo, Map<String, Serializable> config) throws ShellNotAvailableException, RemoteException {
        this.graphDb = neo;
        if (!this.shellDependencyAvailable()) {
            throw new ShellNotAvailableException();
        }
        this.shellServer = this.startShellServer(config);
    }

    private boolean shellDependencyAvailable() {
        try {
            Class.forName("org.neo4j.shell.ShellServer");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private Object startShellServer(Map<String, Serializable> config) throws RemoteException {
        Integer port = (Integer)this.getConfig(config, "port", "DEFAULT_PORT");
        String name = (String)((Object)this.getConfig(config, "name", "DEFAULT_NAME"));
        try {
            Class<?> shellServerClass = Class.forName("org.neo4j.shell.kernel.GraphDatabaseShellServer");
            Object shellServer = shellServerClass.getConstructor(GraphDatabaseService.class).newInstance(this.graphDb);
            shellServer.getClass().getMethod("makeRemotelyAvailable", Integer.TYPE, String.class).invoke(shellServer, port, name);
            return shellServer;
        }
        catch (Exception e) {
            throw new RemoteException("Couldn't start shell '" + name + "' at port " + port, e);
        }
    }

    private Serializable getConfig(Map<String, Serializable> config, String key, String defaultVariableName) throws RemoteException {
        Serializable result = config.get(key);
        if (result == null) {
            try {
                result = (Serializable)Class.forName("org.neo4j.shell.impl.AbstractServer").getDeclaredField(defaultVariableName).get(null);
            }
            catch (Exception e) {
                throw new RemoteException("Default variable not found", e);
            }
        }
        return result;
    }

    public boolean shutdown() throws ShellNotAvailableException {
        try {
            this.shellServer.getClass().getMethod("shutdown", new Class[0]).invoke(this.shellServer, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static class ShellNotAvailableException
    extends Exception {
    }
}

