/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.SoftReferenceQueue;
import org.neo4j.kernel.impl.cache.SoftValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftLruCache<K, V>
implements Cache<K, V> {
    private final ConcurrentHashMap<K, SoftValue<K, V>> cache = new ConcurrentHashMap();
    private final SoftReferenceQueue<K, V> refQueue = new SoftReferenceQueue();
    private final String name;

    public SoftLruCache(String name) {
        this.name = name;
    }

    @Override
    public void put(K key, V value) {
        SoftValue<K, SoftValue> ref = new SoftValue<K, SoftValue>(key, (SoftValue)value, this.refQueue);
        this.cache.put(key, ref);
    }

    @Override
    public V get(K key) {
        SoftReference ref = this.cache.get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public V remove(K key) {
        SoftReference ref = this.cache.remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    public void pollAll() {
        SoftValue cv;
        while ((cv = (SoftValue)this.refQueue.poll()) != null) {
            this.cache.remove(cv.key);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void elementCleaned(V value) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAdaptive() {
        return true;
    }

    @Override
    public int maxSize() {
        return -1;
    }

    @Override
    public void resize(int newSize) {
    }

    @Override
    public void setAdaptiveStatus(boolean status) {
    }
}

