/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.impl.core.NeoPrimitive;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.TransactionFailureException;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.IntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockReleaser {
    private static Logger log = Logger.getLogger(LockReleaser.class.getName());
    private final ArrayMap<Transaction, List<LockElement>> lockMap = new ArrayMap(5, true, true);
    private final ArrayMap<Transaction, NeoPrimitiveElement> cowMap = new ArrayMap(5, true, true);
    private NodeManager nodeManager;
    private final LockManager lockManager;
    private final TransactionManager transactionManager;
    private PropertyIndexManager propertyIndexManager;

    public LockReleaser(LockManager lockManager, TransactionManager transactionManager) {
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
    }

    void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    void setPropertyIndexManager(PropertyIndexManager propertyIndexManager) {
        this.propertyIndexManager = propertyIndexManager;
    }

    public void addLockToTransaction(Object resource, LockType type) throws NotInTransactionException {
        Transaction tx = this.getTransaction();
        List<LockElement> lockElements = this.lockMap.get(tx);
        if (lockElements != null) {
            lockElements.add(new LockElement(resource, type));
        } else {
            if (tx == null) {
                if (type == LockType.WRITE) {
                    this.lockManager.releaseWriteLock(resource);
                } else if (type == LockType.READ) {
                    this.lockManager.releaseReadLock(resource);
                }
                return;
            }
            lockElements = new ArrayList<LockElement>();
            this.lockMap.put(tx, lockElements);
            lockElements.add(new LockElement(resource, type));
            try {
                tx.registerSynchronization((Synchronization)new ReadOnlyTxReleaser(tx));
            }
            catch (Exception e) {
                throw new TransactionFailureException("Failed to register lock release synchronization hook", e);
            }
        }
    }

    private Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Failed to get current transaction.", e);
        }
    }

    public IntArray getCowRelationshipRemoveMap(NodeImpl node, String type) {
        ArrayMap<Integer, CowNodeElement> cowElements;
        CowNodeElement element;
        NeoPrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && (element = (cowElements = primitiveElement.nodes).get(node.id)) != null && element.relationshipRemoveMap != null) {
            return element.relationshipRemoveMap.get(type);
        }
        return null;
    }

    public IntArray getCowRelationshipRemoveMap(NodeImpl node, String type, boolean create) {
        IntArray set;
        if (!create) {
            return this.getCowRelationshipRemoveMap(node, type);
        }
        NeoPrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
        CowNodeElement element = cowElements.get(node.id);
        if (element == null) {
            element = new CowNodeElement();
            cowElements.put(node.id, element);
        }
        if (element.relationshipRemoveMap == null) {
            element.relationshipRemoveMap = new ArrayMap();
        }
        if ((set = element.relationshipRemoveMap.get(type)) == null) {
            set = new IntArray();
            element.relationshipRemoveMap.put(type, set);
        }
        return set;
    }

    public ArrayMap<String, IntArray> getCowRelationshipAddMap(NodeImpl node) {
        ArrayMap<Integer, CowNodeElement> cowElements;
        CowNodeElement element;
        NeoPrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && (element = (cowElements = primitiveElement.nodes).get(node.id)) != null) {
            return element.relationshipAddMap;
        }
        return null;
    }

    public IntArray getCowRelationshipAddMap(NodeImpl node, String type) {
        ArrayMap<Integer, CowNodeElement> cowElements;
        CowNodeElement element;
        NeoPrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && (element = (cowElements = primitiveElement.nodes).get(node.id)) != null && element.relationshipAddMap != null) {
            return element.relationshipAddMap.get(type);
        }
        return null;
    }

    public IntArray getCowRelationshipAddMap(NodeImpl node, String type, boolean create) {
        IntArray set;
        if (!create) {
            return this.getCowRelationshipRemoveMap(node, type);
        }
        NeoPrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
        CowNodeElement element = cowElements.get(node.id);
        if (element == null) {
            element = new CowNodeElement();
            cowElements.put(node.id, element);
        }
        if (element.relationshipAddMap == null) {
            element.relationshipAddMap = new ArrayMap();
        }
        if ((set = element.relationshipAddMap.get(type)) == null) {
            set = new IntArray();
            element.relationshipAddMap.put(type, set);
        }
        return set;
    }

    public void commit() {
        Transaction tx = this.getTransaction();
        this.propertyIndexManager.commit(tx);
        this.releaseCows(tx, 3);
        this.releaseLocks(tx);
    }

    public void rollback() {
        Transaction tx = this.getTransaction();
        this.propertyIndexManager.rollback(tx);
        this.releaseCows(tx, 4);
        this.releaseLocks(tx);
    }

    void releaseLocks(Transaction tx) {
        List<LockElement> lockElements = this.lockMap.remove(tx);
        if (lockElements != null) {
            for (LockElement lockElement : lockElements) {
                try {
                    if (lockElement.lockType == LockType.READ) {
                        this.lockManager.releaseReadLock(lockElement.resource);
                        continue;
                    }
                    if (lockElement.lockType != LockType.WRITE) continue;
                    this.lockManager.releaseWriteLock(lockElement.resource);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.severe("Unable to release lock[" + (Object)((Object)lockElement.lockType) + "] on resource[" + lockElement.resource + "]");
                }
            }
        }
    }

    void releaseCows(Transaction cowTxId, int param) {
        NeoPrimitiveElement element = this.cowMap.remove(cowTxId);
        if (element == null) {
            return;
        }
        ArrayMap<Integer, CowNodeElement> cowNodeElements = element.nodes;
        Set<Map.Entry<Integer, CowNodeElement>> nodeEntrySet = cowNodeElements.entrySet();
        for (Map.Entry<Integer, CowNodeElement> entry : nodeEntrySet) {
            NodeImpl node = this.nodeManager.getNodeIfCached(entry.getKey());
            if (node == null) continue;
            CowNodeElement nodeElement = entry.getValue();
            if (param == 3) {
                node.commitRelationshipMaps(nodeElement.relationshipAddMap, nodeElement.relationshipRemoveMap);
                node.commitPropertyMaps(nodeElement.propertyAddMap, nodeElement.propertyRemoveMap);
                continue;
            }
            if (param == 4) continue;
            throw new TransactionFailureException("Unknown transaction status: " + param);
        }
        ArrayMap<Integer, CowRelElement> cowRelElements = element.relationships;
        Set<Map.Entry<Integer, CowRelElement>> relEntrySet = cowRelElements.entrySet();
        for (Map.Entry<Integer, CowRelElement> entry : relEntrySet) {
            RelationshipImpl rel = this.nodeManager.getRelIfCached(entry.getKey());
            if (rel == null) continue;
            CowRelElement relElement = entry.getValue();
            if (param == 3) {
                rel.commitPropertyMaps(relElement.propertyAddMap, relElement.propertyRemoveMap);
                continue;
            }
            if (param == 4) continue;
            throw new TransactionFailureException("Unknown transaction status: " + param);
        }
        this.cowMap.remove(cowTxId);
    }

    public synchronized void dumpLocks() {
        System.out.print("Locks held: ");
        Iterator<Transaction> itr = this.lockMap.keySet().iterator();
        if (!itr.hasNext()) {
            System.out.println("NONE");
        } else {
            System.out.println();
        }
        while (itr.hasNext()) {
            Transaction transaction = itr.next();
            System.out.println("" + transaction + "->" + this.lockMap.get(transaction).size());
        }
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(NeoPrimitive primitive) {
        ArrayMap<Integer, CowRelElement> cowElements;
        CowRelElement element;
        NeoPrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements2 = primitiveElement.nodes;
            CowNodeElement element2 = cowElements2.get(primitive.id);
            if (element2 != null) {
                return element2.propertyRemoveMap;
            }
        } else if (primitiveElement != null && primitive instanceof RelationshipImpl && (element = (cowElements = primitiveElement.relationships).get(primitive.id)) != null) {
            return element.propertyRemoveMap;
        }
        return null;
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(NeoPrimitive primitive) {
        ArrayMap<Integer, CowRelElement> cowElements;
        CowRelElement element;
        NeoPrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements2 = primitiveElement.nodes;
            CowNodeElement element2 = cowElements2.get(primitive.id);
            if (element2 != null) {
                return element2.propertyAddMap;
            }
        } else if (primitiveElement != null && primitive instanceof RelationshipImpl && (element = (cowElements = primitiveElement.relationships).get(primitive.id)) != null) {
            return element.propertyAddMap;
        }
        return null;
    }

    private NeoPrimitiveElement getAndSetupPrimitiveElement() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        NeoPrimitiveElement primitiveElement = this.cowMap.get(tx);
        if (primitiveElement == null) {
            primitiveElement = new NeoPrimitiveElement();
            this.cowMap.put(tx, primitiveElement);
        }
        return primitiveElement;
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(NeoPrimitive primitive, boolean create) {
        if (!create) {
            return this.getCowPropertyAddMap(primitive);
        }
        NeoPrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        if (primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
            CowNodeElement element = cowElements.get(primitive.id);
            if (element == null) {
                element = new CowNodeElement();
                cowElements.put(primitive.id, element);
            }
            if (element.propertyAddMap == null) {
                element.propertyAddMap = new ArrayMap();
            }
            return element.propertyAddMap;
        }
        if (primitive instanceof RelationshipImpl) {
            ArrayMap<Integer, CowRelElement> cowElements = primitiveElement.relationships;
            CowRelElement element = cowElements.get(primitive.id);
            if (element == null) {
                element = new CowRelElement();
                cowElements.put(primitive.id, element);
            }
            if (element.propertyAddMap == null) {
                element.propertyAddMap = new ArrayMap();
            }
            return element.propertyAddMap;
        }
        return null;
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(NeoPrimitive primitive, boolean create) {
        if (!create) {
            return this.getCowPropertyRemoveMap(primitive);
        }
        NeoPrimitiveElement primitiveElement = this.getAndSetupPrimitiveElement();
        if (primitive instanceof NodeImpl) {
            ArrayMap<Integer, CowNodeElement> cowElements = primitiveElement.nodes;
            CowNodeElement element = cowElements.get(primitive.id);
            if (element == null) {
                element = new CowNodeElement();
                cowElements.put(primitive.id, element);
            }
            if (element.propertyRemoveMap == null) {
                element.propertyRemoveMap = new ArrayMap();
            }
            return element.propertyRemoveMap;
        }
        if (primitive instanceof RelationshipImpl) {
            ArrayMap<Integer, CowRelElement> cowElements = primitiveElement.relationships;
            CowRelElement element = cowElements.get(primitive.id);
            if (element == null) {
                element = new CowRelElement();
                cowElements.put(primitive.id, element);
            }
            if (element.propertyRemoveMap == null) {
                element.propertyRemoveMap = new ArrayMap();
            }
            return element.propertyRemoveMap;
        }
        return null;
    }

    public void removeNodeFromCache(int nodeId) {
        if (this.nodeManager != null) {
            this.nodeManager.removeNodeFromCache(nodeId);
        }
    }

    public void addRelationshipType(RelationshipTypeData type) {
        if (this.nodeManager != null) {
            this.nodeManager.addRelationshipType(type);
        }
    }

    public void addPropertyIndex(PropertyIndexData index) {
        if (this.nodeManager != null) {
            this.nodeManager.addPropertyIndex(index);
        }
    }

    public void removeRelationshipFromCache(int id) {
        if (this.nodeManager != null) {
            this.nodeManager.removeRelationshipFromCache(id);
        }
    }

    public void removeRelationshipTypeFromCache(int id) {
        if (this.nodeManager != null) {
            this.nodeManager.removeRelationshipTypeFromCache(id);
        }
    }

    public void clearCache() {
        if (this.nodeManager != null) {
            this.nodeManager.clearCache();
        }
    }

    private class ReadOnlyTxReleaser
    implements Synchronization {
        private final Transaction tx;

        ReadOnlyTxReleaser(Transaction tx) {
            this.tx = tx;
        }

        public void afterCompletion(int status) {
            LockReleaser.this.releaseLocks(this.tx);
        }

        public void beforeCompletion() {
        }
    }

    private static class LockElement {
        Object resource;
        LockType lockType;

        LockElement(Object resource, LockType type) {
            this.resource = resource;
            this.lockType = type;
        }
    }

    private static class CowRelElement {
        ArrayMap<Integer, PropertyData> propertyAddMap = null;
        ArrayMap<Integer, PropertyData> propertyRemoveMap = null;

        CowRelElement() {
        }
    }

    private static class CowNodeElement {
        ArrayMap<String, IntArray> relationshipAddMap = null;
        ArrayMap<String, IntArray> relationshipRemoveMap = null;
        ArrayMap<Integer, PropertyData> propertyAddMap = null;
        ArrayMap<Integer, PropertyData> propertyRemoveMap = null;

        CowNodeElement() {
        }
    }

    private static class NeoPrimitiveElement {
        final ArrayMap<Integer, CowNodeElement> nodes = new ArrayMap();
        final ArrayMap<Integer, CowRelElement> relationships = new ArrayMap();

        NeoPrimitiveElement() {
        }
    }
}

