/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Map;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.cache.AdaptiveCacheManager;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.ReadOnlyNodeManager;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.persistence.IdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TransactionFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoModule {
    private static Logger log = Logger.getLogger(NeoModule.class.getName());
    private boolean startIsOk = true;
    private static final int INDEX_COUNT = 2500;
    private final TransactionManager transactionManager;
    private final AdaptiveCacheManager cacheManager;
    private final LockManager lockManager;
    private final IdGenerator idGenerator;
    private NodeManager nodeManager;
    private boolean readOnly = false;

    public NeoModule(AdaptiveCacheManager cacheManager, LockManager lockManager, TransactionManager transactionManager, IdGenerator idGenerator) {
        this.cacheManager = cacheManager;
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.idGenerator = idGenerator;
    }

    public NeoModule(AdaptiveCacheManager cacheManager, LockManager lockManager, TransactionManager transactionManager, IdGenerator idGenerator, boolean readOnly) {
        this.cacheManager = cacheManager;
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.idGenerator = idGenerator;
        this.readOnly = readOnly;
    }

    public void init() {
    }

    public void start(LockReleaser lockReleaser, PersistenceManager persistenceManager, Map<Object, Object> params) {
        if (!this.startIsOk) {
            return;
        }
        boolean useNewCache = true;
        if (params.containsKey("use_old_cache") && params.get("use_old_cache").equals("true")) {
            useNewCache = false;
        }
        this.nodeManager = !this.readOnly ? new NodeManager(this.cacheManager, this.lockManager, lockReleaser, this.transactionManager, persistenceManager, this.idGenerator, useNewCache) : new ReadOnlyNodeManager(this.cacheManager, this.lockManager, lockReleaser, this.transactionManager, persistenceManager, this.idGenerator, useNewCache);
        RelationshipTypeData[] relTypes = null;
        PropertyIndexData[] propertyIndexes = null;
        this.beginTx();
        relTypes = persistenceManager.loadAllRelationshipTypes();
        propertyIndexes = persistenceManager.loadPropertyIndexes(2500);
        this.commitTx();
        this.nodeManager.addRawRelationshipTypes(relTypes);
        this.nodeManager.addPropertyIndexes(propertyIndexes);
        if (propertyIndexes.length < 2500) {
            this.nodeManager.setHasAllpropertyIndexes(true);
        }
        this.nodeManager.start(params);
        this.startIsOk = false;
    }

    private void beginTx() {
        try {
            this.transactionManager.begin();
        }
        catch (NotSupportedException e) {
            throw new TransactionFailureException("Unable to begin transaction.", e);
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Unable to begin transaction.", e);
        }
    }

    private void commitTx() {
        try {
            this.transactionManager.commit();
        }
        catch (SecurityException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (IllegalStateException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (RollbackException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (HeuristicMixedException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Failed to commit.", e);
        }
    }

    public void setReferenceNodeId(Integer nodeId) {
        this.nodeManager.setReferenceNodeId(nodeId);
        try {
            this.nodeManager.getReferenceNode();
        }
        catch (NotFoundException e) {
            log.warning("Reference node[" + nodeId + "] not valid.");
        }
    }

    public Integer getCurrentReferenceNodeId() {
        try {
            return (int)this.nodeManager.getReferenceNode().getId();
        }
        catch (NotFoundException e) {
            return -1;
        }
    }

    public void createNewReferenceNode() {
        Node node = this.nodeManager.createNode();
        this.nodeManager.setReferenceNodeId((int)node.getId());
    }

    public void reload(Map<Object, Object> params) {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        this.nodeManager.clearPropertyIndexes();
        this.nodeManager.clearCache();
        this.nodeManager.stop();
    }

    public void destroy() {
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.nodeManager.getRelationshipTypes();
    }
}

