/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.core.NodeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeProxy
implements Node {
    private final NodeManager nm;
    private final int nodeId;

    NodeProxy(int nodeId, NodeManager nodeManager) {
        this.nodeId = nodeId;
        this.nm = nodeManager;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public void delete() {
        this.nm.getNodeForProxy(this.nodeId).delete();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.nm.getNodeForProxy(this.nodeId).getRelationships();
    }

    @Override
    public boolean hasRelationship() {
        return this.nm.getNodeForProxy(this.nodeId).hasRelationship();
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).getRelationships(dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).hasRelationship(dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.nm.getNodeForProxy(this.nodeId).getRelationships(types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.nm.getNodeForProxy(this.nodeId).hasRelationship(types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).getRelationships(type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).hasRelationship(type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        return this.nm.getNodeForProxy(this.nodeId).getSingleRelationship(type, dir);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.nm.getNodeForProxy(this.nodeId).setProperty(key, value);
    }

    @Override
    public Object removeProperty(String key) throws NotFoundException {
        return this.nm.getNodeForProxy(this.nodeId).removeProperty(key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.nm.getNodeForProxy(this.nodeId).getProperty(key, defaultValue);
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.nm.getNodeForProxy(this.nodeId).getPropertyValues();
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.nm.getNodeForProxy(this.nodeId).getPropertyKeys();
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        return this.nm.getNodeForProxy(this.nodeId).getProperty(key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.nm.getNodeForProxy(this.nodeId).hasProperty(key);
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        return this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return this.nodeId;
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.nm.getNodeForProxy(this.nodeId).createRelationshipTo(otherNode, type);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return this.nm.getNodeForProxy(this.nodeId).traverse(traversalOrder, stopEvaluator, returnableEvaluator, relationshipType, direction);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return this.nm.getNodeForProxy(this.nodeId).traverse(traversalOrder, stopEvaluator, returnableEvaluator, firstRelationshipType, firstDirection, secondRelationshipType, secondDirection);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        return this.nm.getNodeForProxy(this.nodeId).traverse(traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }
}

