/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelationshipProxy
implements Relationship {
    private final int relId;
    private final NodeManager nm;

    RelationshipProxy(int relId, NodeManager nodeManager) {
        this.relId = relId;
        this.nm = nodeManager;
    }

    @Override
    public long getId() {
        return this.relId;
    }

    @Override
    public void delete() {
        this.nm.getRelForProxy(this.relId).delete();
    }

    @Override
    public Node[] getNodes() {
        return this.nm.getRelForProxy(this.relId).getNodes();
    }

    @Override
    public Node getOtherNode(Node node) {
        return this.nm.getRelForProxy(this.relId).getOtherNode(node);
    }

    @Override
    public Node getStartNode() {
        return this.nm.getRelForProxy(this.relId).getStartNode();
    }

    @Override
    public Node getEndNode() {
        return this.nm.getRelForProxy(this.relId).getEndNode();
    }

    @Override
    public RelationshipType getType() {
        return this.nm.getRelForProxy(this.relId).getType();
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.nm.getRelForProxy(this.relId).getPropertyKeys();
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.nm.getRelForProxy(this.relId).getPropertyValues();
    }

    @Override
    public Object getProperty(String key) {
        return this.nm.getRelForProxy(this.relId).getProperty(key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.nm.getRelForProxy(this.relId).getProperty(key, defaultValue);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.nm.getRelForProxy(this.relId).hasProperty(key);
    }

    @Override
    public void setProperty(String key, Object property) {
        this.nm.getRelForProxy(this.relId).setProperty(key, property);
    }

    @Override
    public Object removeProperty(String key) {
        return this.nm.getRelForProxy(this.relId).removeProperty(key);
    }

    @Override
    public boolean isType(RelationshipType type) {
        return this.nm.getRelForProxy(this.relId).isType(type);
    }

    public int compareTo(Object rel) {
        int theirId;
        Relationship r = (Relationship)rel;
        int ourId = (int)this.getId();
        if (ourId < (theirId = (int)r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Relationship)) {
            return false;
        }
        return this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return this.relId;
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }
}

